;***************************************************************
;*                                                             *
;* File: tsrvars.inc                                           *
;*                                                             *
;***************************************************************
;-----------------------------------------------
; video width, mode, and page of host program
HostVwidth      db      ?                       ;
HostVmode       db      ?                       ;
HostVpage       db      ?                       ;

;-----------------------------------------------
; TSR's video segment
TsrVidseg       dw      ?                       ;
MsgPassPos      dw      0                       ;
MsgPassAttr     db      0                       ;

;-----------------------------------------------
TsrSig          db      'Z'+080h                ;
; if not zero, size of tsr (used to override default)
TsrSize         dw      0

;-----------------------------------------------
; TSR's PSP segment
HostPsp         dw      0                       ;
TsrPsp          dw      0                       ;
; Pointer to Host's DTA
HostDta         EQU     THIS DWORD              ;
HostDtaO        dw      0                       ;
HostDtaS        dw      0                       ;
; host's SS:SP
HostStk         EQU     THIS DWORD              ;
HostSS          dw      0                       ;
HostSP          dw      0                       ;
; host's SDA
HostSda         EQU     THIS DWORD              ;
HostSdaO        dw      0                       ;
HostSdaS        dw      0                       ;
HostSdaCnt      dw      0                       ;
SdaInDosCnt     dw      0                       ;
SdaSafeCnt      dw      0                       ;

;-----------------------------------------------
; TSR's PSP segment
Tsrpsp          dw      0                       ;
; Pointer to TSR's stack
TsrStk          EQU     THIS DWORD              ;
TsrSS           dw      0                       ;
TsrSP           dw      0                       ;
; Pointer to TSR's DTA
TsrDta          EQU     THIS DWORD              ;
TsrDtaO         dw      0                       ;
TsrDtaS         dw      0                       ;

;-----------------------------------------------
; Save area for dos swap
TsrSda          db      800h    dup(0)          ;
TsrSda1         db      100h    dup(0)          ;

;------------------------------------------------
VideoBusy       db      0                       ;
DiskBusy        db      0                       ;
AbsRdBusy       db      0                       ;
AbsWrBusy       db      0                       ;
DosCrit         db      0                       ;
NetWorkBusy     db      0                       ;

;-----------------------------------------------
; Keyboard definitions
ALT     equ     8
CTRL    equ     4
LSHIFT  equ     2
RSHIFT  equ     1
HotScan0        db      0Fh                     ;TAB
ShiftMsk0       db      LSHIFT                  ;
EscPress0       db      0                       ;

;-----------------------------------------------
; TSR state flag
TsrStopReq      db      0                       ;TSR is requested to stop
TsrStoped       db      0                       ;TSR has been stoped
TsrPopReq       db      0                       ;TSR is requested to popup
TsrPoped        db      0                       ;TSR is running now
TsrKill         db      0                       ;
PopUpState      db      0                       ;popup state

;------------------------------------------------
TickCnt         db      18                      ;
TickSec         db      0                       ;
TickMin         db      0                       ;
TimeTick00      dw      0                       ;
TimeTick1       dw      0                       ;
TimeTick2       dw      0                       ;
TimerCom        dw      0                       ;
Ringtime        dw      0                       ;
Ringcnt0        dw      0                       ;
Ringcnt1        dw      0                       ;

;------------------------------------------------
ComRing         dw      1                       ;
ComPort         dw      0                       ;
Comrdfpth       db      80      dup(0)          ;file path
Comfpthcnt      dw      0                       ;

Comrdfh         dw      -1                      ;save file pointer

Arg_func        dw      0                       ;

POPUP_DISK      equ     1                       ;pop up to do disk i/o
POPUP_EOF       equ     2                       ;end of file
POPUP_ATA       equ     3                       ;pop up tp send 'ATA'
COMBUFLENGTH    equ     800h                    ;
                ;-------------------------------
DC2             equ     18
                ;--------------------------------
RESP_IDLE       equ     -1                      ;
RESP_OK         equ     0                       ;
RESP_ERROR      equ     1                       ;
RESP_RING       equ     2                       ;
RESP_ZYXEL      equ     3                       ;
RESP_NOCARRIER  equ     4                       ;
RESP_CONNFAX    equ     5                       ;
RESP_DISC       equ     6                       ;
RESP_S          equ     7                       ;
                ;------ communication state ----
COMM_IDLE       equ     0                       ;ComState
COMM_CONN       equ     1                       ;
                ;------ variables belongs to configuration ---
POPUP_NONE      equ     0                       ;unknown reason
POPUP_DISK      equ     1                       ;pop up to do disk i/o
POPUP_DISC      equ     2                       ;pop up to finish connection
POPUP_ATA       equ     3                       ;pop up to send 'ATA'
POPUP_OPEN      equ     4                       ;pop up to open a file
POPUP_RESET     equ     5                       ;pop up to reset the modem
POPUP_INT       equ     6                       ;pop up to reset the modem

        ; error code
ERR_NONE        equ     0                       ;
ERR_DOSFUNC     equ     1                       ;Invalid dos function
ERR_NOFILE      equ     2                       ;file not found
ERR_NOPATH      equ     3                       ;path not found
ERR_NOHANDLE    equ     4                       ;no handle available
ERR_DOSACCESS   equ     5                       ;access denied by dos
ERR_HANDLE      equ     6                       ;invalid handle
ERR_DISKFULL    equ     7                       ;disk full
ERR_PRINTER     equ     10h                     ;printer error
ERR_NOGRAFONT   equ     11h                     ;no graph font
ERR_FAXFONT     equ     12h                     ;no zfax font
ERR_NOTZYXEL    equ     20h                     ;not zyxel modem
ERR_FAIL        equ     21h                     ;fail to send fax
ERR_BUSY        equ     22h                     ;busy
ERR_CARRIER     equ     23h                     ;no carrier
ERR_DIALTONE    equ     24h                     ;no dial tone
ERR_COMERR      equ     25h                     ;no response from com port
ERR_DCDOFF      equ     26h                     ;DCD drop while sending
ERR_USRABT      equ     30h                     ;user abort
ERR_CRITDISK    equ     40h                     ;critical error on disk
