
BLACK           equ     0
BLUE            equ     1
GREEN           equ     2
CYAN            equ     3
RED             equ     4
MAGENTA         equ     5
BROWN           equ     6
LIGHTGRAY       equ     7
DARKGRAY        equ     8
LIGHTBLUE       equ     9
LIGHTGREEN      equ     10
LIGHTCYAN       equ     11
LIGHTRED        equ     12
LIGHTMAGENTA    equ     13
YELLOW          equ     14
WHITE           equ     15
ATTR            equ     BLUE*16+YELLOW          ;

MSG_WINPOS      equ     18+256*8                        ;
WIN_HEIGHT      equ     4
WIN_WIDTH       equ     44                              ;
MSG_WINSIZE     equ     WIN_WIDTH+WIN_HEIGHT*256        ;
MSG_FNAMEPOS    equ     MSG_WINPOS+1*256+17             ;
MSG_WINATTR     equ     ATTR                            ;

; ****************************************************************
; *                                                              *
; *                  D  A  T  A  S                               *
; *                                                              *
; ****************************************************************
                ;----------------------------------
video_buf       db      (WIN_WIDTH+4)*(WIN_HEIGHT+5)*2  dup(0)
border_type     db      'Ŀ    Ĵ;';double/single line border
border_type0    db      'zw{x  xuwt';double/single line border
                ;----------------------------------
                ; string for convert msg
MsgPtr          dw      0                       ;
TlePtr          dw      0                       ;
BdrPtr          dw      0                       ;
MsgStusPtr      dw      0                       ;
                ;----------------------------------
FaxStr          db      ' File Name   : ',0
                db      ' Fax Number  : ',0
                db      ' Fax Speed   : ',0
                db      ' Average CPS : ',0
MsgStus         db      ' Status : ',0
RcvFaxTitle     db      ' ZFAX 2.23 Receive Fax Utility ',0

CFaxStr         db      '    W : ',0
                db      '  u  X : ',0
                db      '  u t v : ',0
                db      '  yqq : ',0
CMsgStus        db      '   A : ',0
CRcvFaxTitle    db      ' ZFAX 2.23  u     {  ',0
                ;----------------------------------
showbytes       db      6       dup(0)          ;
_cpspos         dw      0                       ;
Msg_WinShadow0  dw      1                       ;

; ****************************************************************
; *             CreatMsgWin
; *
; *  Input :    al -> x0, ah -> y0
; *             bx -> title string ptr
; *
; *  output :   if setup window, ax,bx->put msg coord.
; *
; ****************************************************************
public          CreatMsgWin
CreatMsgWin     proc    near

                lea     ax,RcvFaxTitle          ;
                lea     bx,FaxStr               ;
                lea     cx,border_type          ;
                lea     dx,MsgStus              ;
                mov     TlePtr,ax               ;
                mov     MsgPtr,bx               ;
                mov     BdrPtr,cx               ;
                mov     MsgStusPtr,dx           ;
                mov     ax,9100h                ;
                int     10h                     ;
                cmp     ah,91h                  ;
                jz      crwin_000               ;it is not in chinese system
                test    dh,80h                  ;
                jnz     crwin_000               ;not in chinese video mode
                lea     ax,CRcvFaxTitle         ;
                lea     bx,CFaxStr              ;
                lea     cx,border_type0         ;
                lea     dx,CMsgStus             ;
                mov     TlePtr,ax               ;
                mov     MsgPtr,bx               ;
                mov     BdrPtr,cx               ;
                mov     MsgStusPtr,dx           ;
crwin_000:      mov     ax,MSG_WINPOS           ;
                mov     bx,MSG_WINSIZE          ;bl=width, bh=high
                add     bx,0504h                ;
                call    StoreWin                ;get the window text to buffer
                mov     ch,MSG_WINATTR          ;
                mov     ax,MSG_WINPOS           ;
                mov     bx,MSG_WINSIZE          ;bl=width, bh=high
                call    DrawBdr                 ;draw the border
                mov     ax,MSG_WINPOS           ;
                mov     bx,MSG_WINSIZE          ;
                mov     si,TlePtr               ;
                call    PutCenStr               ;
                mov     si,MsgPtr               ;
                add     al,2                    ;
                xor     bl,bl                   ;
                xor     cx,cx                   ;
crwin_001:      inc     ah                      ;
                call    PutStr                  ;put header
                dec     bh                      ;
                jnz     crwin_001               ;
                push    ax                      ;
                add     ax,18                   ;
                call    Cord2Addr               ;
                mov     cs:_cpspos,di           ;
                pop     ax                      ;
                ;------ set put string position -------
                add     ah,2                    ;
                call    PutStr                  ;put CPS string
                add     ax,13                   ;
                call    Cord2Addr               ;
                mov     cs:MsgPassPos,di        ;
                mov     cs:MsgPassAttr,MSG_WINATTR
                ret

CreatMsgWin     endp

; ****************************************************************
; *             CloseMsgWin
; *
; *  Input :    si -> title string ptr
; *             al -> x0, ah -> y0
; *             cx -> 0:setup window, 1:clear window
; *
; *  output :   if setup window, ax,bx->put msg coord.
; ****************************************************************
public          CloseMsgWin
CloseMsgWin     proc    near

                mov     ax,MSG_WINPOS           ;
                mov     bx,MSG_WINSIZE          ;bl=width, bh=high
                add     bx,0504h                ;
                call    RestoreWin              ;get the window text to buffer
                ret                             ;

CloseMsgWin     endp

; **********************************************************************
; *             RestoreWin
; *
; * Description : get the original text that display on the window
; *
; * Input :     al -> x0
; *             ah -> y0
; *             bl -> xlen
; *             bh -> ylen
; *
; **********************************************************************
RestoreWin      proc    near

                call    Cord2Addr               ;di = address to be save
                mov     dx,di                   ;
                lea     si,video_buf            ;
                mov     es,TsrVidseg            ;es = txtpage
                xor     ax,ax                   ;
                mov     al,bl                   ;
RestoreTxt:     mov     di,dx                   ;
                mov     cx,ax                   ;
                rep     movsw                   ;
                add     dx,160                  ;
                dec     bh                      ;
                jnz     RestoreTxt              ;

                ret

RestoreWin      endp

; **********************************************************************
; *             StoreWin
; *
; * Description : get the original text that display on the window
; *
; * Input :     al -> x0
; *             ah -> y0
; *             bl -> xlen
; *             bh -> ylen
; *
; **********************************************************************
StoreWin        proc    near

                push    ds                      ;
                call    Cord2Addr               ;di = address to be save
                mov     dx,di                   ;
                lea     di,video_buf            ;
                mov     ax,ds                   ;es = ds
                mov     es,ax                   ;
                mov     ds,TsrVidseg            ;ds = txtpage
                xor     ax,ax                   ;
                mov     al,bl                   ;
StoreTxt:       mov     cx,ax                   ;store the text
                mov     si,dx                   ;
                rep     movsw                   ;
                add     dx,160                  ;
                dec     bh                      ;
                jg      StoreTxt                ;
                pop     ds                      ;
                ret

StoreWin        endp


; **********************************************************************
; *                     DrawBdr
; *
; * Description : Draw the border of the window.
; *
; * Input :     al -> x0
; *             ah -> y0
; *             bl -> xlen
; *             bh -> ylen
; *             ch -> border attribute (window attribute)
; *
; **********************************************************************
DrawBdr         proc    near

                call    Cord2Addr               ;di = address of left-up corner
                mov     ah,ch                   ;attribute
                mov     si,BdrPtr               ;
                mov     es,TsrVidseg            ;display segment
                call    Draw1Line               ;Draw 1st line
                add     di,160                  ;
                add     si,6                    ;
DrawBdrMid:     call    Draw1Line               ;Draw central lines
                add     di,160                  ;
                dec     bh                      ;
                jg      DrawBdrMid              ;
                add     si,6                    ;
                call    Draw1Line               ;Draw last line
                add     di,160                  ;
                sub     si,6                    ;
                call    Draw1Line               ;Draw last line
                add     di,160                  ;
                add     si,12                   ;
                call    Draw1Line               ;Draw last line
DrawBdrShdw:    cmp     Msg_WinShadow0,0        ;need shadow ?
                jz      DrawBdrRet              ;no
                mov     al,(DARKGRAY+(BLACK*16))
                add     di,165                  ;
                mov     cx,WIN_WIDTH+4          ;
DrawShdwLoop:   stosb                           ;draw the bottom shadow
                inc     di                      ;
                loop    DrawShdwLoop            ;
DrawBdrRet:     ret

DrawBdr         endp

; **********************************************************************
; *                     PutCenStr
; *
; * Description : Put String on the central screen
; *
; * Input :       ax -> x0, y0
; *               bx -> x1, y1
; *
; * Output :      si -> pass the end of the string
; *
; **********************************************************************
PutCenStr       proc    near

                .push   ax,bx
                call    StrLen                  ;string length of title
                sub     bl,cl                   ;
                jl      putcen_000              ;
                shr     bl,1                    ;bl = xlen/2-strlen/2
                add     al,bl                   ;al = x0+xlen/2-strlen/2
                and     al,0feh                 ;
                xor     cx,cx                   ;put string length
putcen_000:     mov     bl,MSG_WINATTR          ;
                call    PutStr                  ;put string on the screen
                .pop    ax,bx
                ret

PutCenStr       endp



; **********************************************************************
; *             Put string function
; *
; * Description : This function puts a string on the screen with the
; *               defined attribute.
; *
; * Input :       ax -> x0, y0
; *               bl -> attr, 0 defined to be default attr
; *               cx -> string width, 0 defined to be the length of the string
; *               si -> ptr to the string
; *
; * Output :      si -> pass the end of the string
; *
; **********************************************************************
public          PutStr
PutStr          proc    near

                .push   ax,cx,di,es
                call    Cord2Addr               ;convert coordination to addr
                cmp     cx,0                    ;
                jnz     putstr_000              ;put the str len width ?
                call    StrLen                  ;yes, get the width
                jz      putstr_005              ;
putstr_000:     cmp     byte ptr ds:[si],0      ;
                jz      putstr_002              ;
                cmp     byte ptr ds:[si],0dh    ;
                jz      putstr_002              ;
                cmp     bl,0                    ;the default attr ?
                jz      putstr_001              ;no, the defined attr
                mov     es:[di+1],bl            ;
putstr_001:     movsb                           ;
                inc     di                      ;use the default attr
                loop    putstr_000              ;
                jmp     putstr_005              ;
putstr_002:     mov     al,' '                  ;fill space
putstr_003:     cmp     bl,0                    ;the default attr ?
                jz      putstr_004              ;no, the defined attr
                mov     es:[di+1],bl            ;
putstr_004:     stosb                           ;
                inc     di                      ;
                loop    putstr_003              ;
putstr_005:     inc     si                      ;
                .pop    ax,cx,di,es
putstr_ret:     ret


PutStr          endp


; **********************************************************************
; *                     Draw1Line
; *
; * Description : Draw one horizontal line of the border
; *
; * Input :       si -> ptr to the font
; *               di -> ptr to the address to be display
; *               cx -> # of central part characters
; *               es -> offset address of display page
; *               ah -> attribute
; *
; **********************************************************************
Draw1Line       proc    near

                .push   si,di                   ;
                xor     cx,cx                   ;
                mov     cl,bl                   ;
                shr     cl,1                    ;
                dec     cl                      ;
                jle     drline_001              ;
                ;-------------------------------
                lodsb                           ;Left Character
                stosw                           ;
                lodsb                           ;Left Character
                stosw                           ;
                ;-------------------------------
drline_000:     mov     al,ds:[si]              ;
                stosw                           ;
                mov     al,ds:[si+1]            ;
                stosw                           ;
                loop    drline_000              ;
                add     si,2                    ;
                ;-------------------------------
                lodsb                           ;Left Character
                stosw                           ;
                lodsb                           ;Left Character
                stosw                           ;
                cmp     Msg_WinShadow0,0        ;need shadow ?
                jz      drline_001              ;no
                mov     al,(DARKGRAY+(BLACK*16))
                inc     di                      ;
                stosb                           ;
                inc     di                      ;
                stosb                           ;
drline_001:     .pop    si,di                   ;
                ret

Draw1Line       endp


; **********************************************************************
; *                      Cord2Addr
; *
; * Description : Convert the display coordination into offset address
; *
; * Input :       al -> x0
; *               ah -> y0
; *
; * OutPut:       di -> offset address
; *
; **********************************************************************
public          Cord2Addr
Cord2Addr       proc    near

                mov     es,TsrVidseg            ;es = display offset
                mov     di,ax                   ;
                and     di,0ffh                 ;di=x0
                mov     al,80                   ;
                mul     ah                      ;ax=80*y0
                add     di,ax                   ;
                shl     di,1                    ;
                ret                             ;

Cord2Addr       endp


; **********************************************************************
; *                      StrLen
; *
; * Description : Returns the length of a string
; *
; * Input :       ds:si   address of the string ("string")
; *
; * Output :      cx       length of "string"
; *
; **********************************************************************
public          StrLen
StrLen          proc    near

                .push   ax,di,es
                push    ds
                pop     es              ;setup es for scas
                mov     di,si           ;setup di for scas
                mov     cx,-1           ;init counter to 65535
                xor     al,al           ;setup to scan for a NULL
                repne   scasb           ;scan for it
                not     cx              ;fix the counter
                dec     cx              ;don't count the NULL
                .pop    ax,di,es
                ret

StrLen          endp

PutConMsg       proc    near

                xor     bl,bl                   ;attribute = default
                mov     ax,MSG_FNAMEPOS         ;
                mov     cx,25                   ;
                lea     si,cs:Comrdfpth         ;
                call    PutStr                  ;
                inc     ah                      ;
                mov     cx,20                   ;
                lea     si,cs:LogFaxnum         ;
                call    PutStr                  ;
                inc     ah                      ;
                mov     cx,5                    ;
                lea     si,cs:LogSpeed          ;speed
                call    PutStr                  ;
                ret

PutConMsg       endp

; *****************************************************************************
; *             Put bytes message
; *
; *  Description :   This function uses puts a string on the screen with the
; *                  same attribute.
; *
; *  Argument    :   none
; *
; *  Return      :   none.
; *****************************************************************************
public          _Putbytes
_Putbytes       proc    near

                cmp     cs:TimeTick2,0          ;
                jz      putbytes_000            ;
                ret
putbytes_000:   .push   dx,es,si,di             ;
                mov     di,offset ds:showbytes  ;
                mov     word ptr [di],0         ;
                mov     word ptr [di+2],0       ;
                mov     word ptr [di+4],0       ;
                xor     dx,dx                   ;
                mov     ax,cs:debugl            ;
                add     di,4                    ;
                call    _itot                   ;
                mov     cs:debugl,0             ;
                mov     cs:debugh,0             ;
                mov     si,di                   ;
                mov     es,TsrVidseg            ;
                mov     di,_cpspos              ;
                mov     ah,ATTR                 ;
putbyte_001:    mov     al,[si]                 ;
                dec     si                      ;
                cmp     al,0                    ;
                jz      putbyte_002             ;
                mov     es:[di],ax              ;
                sub     di,2                    ;
                jmp     putbyte_001             ;
putbyte_002:    mov     cs:TimeTick2,18         ;
                .pop    dx,es,si,di             ;
                ret

_Putbytes       endp


; *****************************************************************************
; *                             itot
; *
; *  Description :   This function converts an integer to a string
; *
; *  Argument    :   dx;ax -- integer number
; *                  di    -- points to the end of ascii string
; *
; *  Return      :   str.
; *****************************************************************************
public          _itot
_itot           proc    near

                .push   bx,cx,dx,di             ;
                mov     bx,10                   ;
itot_000:       xor     cx,cx                   ;
                cmp     dx,bx                   ;is a divide overflow possible?
                jb      itot_001                ;no, only need to divide once
                xchg    ax,cx                   ;DX;AX = 0;high word
                xchg    ax,dx                   ;CX = low word
                div     bx                      ;divide 0;high word by divisor
                xchg    ax,cx                   ;DX;AX = rem of high divide
                                                ;        low word
itot_001:       div     bx                      ;
                xchg    dx,cx                   ;DX;AX = quotient, CX = rem
                or      cl,30h                  ;
                mov     [di],cl                 ;
                dec     di                      ;
                cmp     dx,0                    ;
                jnz     itot_000                ;
                cmp     ax,0                    ;
                jnz     itot_000                ;
                .pop    bx,cx,dx,di             ;
                ret

_itot           endp

