(*=========================================================================

    Name:       Demo_Prn.Pas   Copyright 1992-94, Rob W. Smetana
                Support file for The Printer (tm).

Requires:       PRINTER.CFG.

                This program displays the contents of Printer.Cfg.
                Therefore, BEFORE running this, you MUST run Printer.Exe,
                select a printer, then press F2 to SAVE Printer.Cfg.


 Purpose:       * Demonstrate reading printer code records.

                * Show how one might display printer codes.

                  Something like this might be used inside a
                  program to show users which codes are
                  available (ie., not blank) and perhaps what
                  they should do to invoke each option.

    NOTE:       Some printer codes may contain control codes which
                will screw up the display.  Try a different printer.
                And in your own programs you might want to use an ASM
                "quickprint" routine to overcome this problem.

=========================================================================*)

Program Demo_Prn;

Uses DOS,CRT;

{ ...include two TYPES useful for reading printer codes. }

(*{$I The_Prn.Pas} *)

{...NOTE:  Although we loaded some TYPEs, we won't use them!  For what     }
{   we're about to do, it's easier to read stuff in simple 14-byte chunks. }

Var

  F     : File;
  Headr : Array[1..44] of Char;
  Labels: Array[1..980] of Char;
  Codes : Array[1..980] of Char;

  Cfg_File: String;

  Ch : Char;
  Temp, N, Offset : Integer;
  BytesRead : Word;
  Row, Col : Byte;

{=========================================================================}
Procedure PrintHeader;                  { print Manufacturer, model, etc. }
{=========================================================================}
  Begin
  TextAttr := 27; ClrScr;
  For N := 1 to 44 Do                   { print our 44-byte header }
     Begin
        Case N of
          1:  Write ( '  Manufacturer: ');
          16: Write ( '  Model: ');
          30: Write ( '  Emulation: ');
        End;
        Write(Headr [N]);
     End;
   TextAttr := 26;
   End;

{=========================================================================}
Begin
{=========================================================================}

  Cfg_File := 'Printer.Cfg';

  {$I-}

  ClrScr;

  Assign(F, Cfg_File);
  Reset(F, 1);

  If IOResult <> 0 then
     Begin
        Write('Error:  ',Cfg_File, ' was not found! ');
        Close(F);
        Halt;
     End;

  { read the header, the labels, the header again and the printer codes }
  BlockRead (F, Headr, SizeOf(Headr), BytesRead);
  BlockRead (F, Labels, SizeOf(Labels), BytesRead);
  BlockRead (F, Headr, SizeOf(Headr), BytesRead);
  BlockRead (F, Codes, SizeOf(Codes), BytesRead);

  If IOResult <> 0 then
     Begin
        Write('Error reading: ',Cfg_File,'');
        Close(F);
        Halt;
     End;

  Close(F);

  PrintHeader;

  { Now parse our two 980-byte buffers and print Labels:Codes }

  Offset :=1 ;Row := 3; Col := 3;

  { Display our 70, 14-byte labels and printer codes }

  For Temp := 1 to 70 Do

    Begin

       GotoXY(Col, Row);
       { Print the labels }
       For N := 1 to 14 Do
           Write(Labels[Offset+N-1]);

       Write('    ');

       { and now the codes }
       For N := 1 to 14 Do
           Write(Codes[Offset+N-1]);

       { move to the next }
       Offset := Offset + 14;

       { there are more codes than will fit on a screen, so pause }

       If (Temp = 42) then
          Begin
            GotoXY(15, 25); Write ('There''s more.   Press <SPACE> to continue . . .');
            Ch:=ReadKey;
            If Ch = #27 then Halt;
            PrintHeader;
            Row :=2; Col := 3;
          End;

       Inc(Row);

       If (Row > 23) then
          Begin
            Row :=3; Col := 40;
          End;
    End;

    GotoXY(15, 25); Write ('That''s all.     Press <SPACE> to continue . . .');
    Ch:=ReadKey;

End.
