//********************************************************************
//*                                                                  *
//*                       Hierarchical Listbox                       *
//*                           Version 1.0                            *
//*                        OWL Wrapper Module                        *
//*                                                                  *
//*   Copyright (c) 1993 Applied Visions, Inc. All Rights Reserved   *
//*                                                                  *
//********************************************************************

#include <owl.h>
#pragma hdrstop
#include "hierlist.h"

HINSTANCE THierListBox::hLib = NULL;


//------------------------------------------------------------------
// Hierarchical Listbox constructor
//------------------------------------------------------------------

THierListBox::THierListBox(PTWindowsObject AParent, int AnId,
                           int X, int Y, int W,
                           int H, PTModule AModule)
    : TControl(AParent, AnId, " ", X, Y, W, H, AModule)
{
  Attr.Style |= (WS_BORDER | WS_VSCROLL);
}


//------------------------------------------------------------------
// Hier Listbox constructor
//------------------------------------------------------------------

THierListBox::THierListBox(PTWindowsObject AParent, int ResourceId,
                           PTModule AModule)
    : TControl(AParent, ResourceId,AModule)
{
}

 
//------------------------------------------------------------------
// Adds an entry to the listbox
//------------------------------------------------------------------

int THierListBox::AddString(LPSTR String, BYTE Level)
{
  HIERENTRY HierEntry;
  HierEntry.String = String;
  HierEntry.Level  = Level;

  return ((int)SendMessage(HWindow, HLB_ADDENTRY, 0, (long)(LPSTR)&HierEntry));
}


//------------------------------------------------------------------
// Sets redraw based on the given flag.
//------------------------------------------------------------------

void THierListBox::Redraw(BOOL Redraw)
{
  SendMessage(HWindow, WM_SETREDRAW, Redraw, 0L);
}

  
//------------------------------------------------------------------
// Retrieves current selection index
//------------------------------------------------------------------

int THierListBox::GetSelIndex()
{
  return ((int)SendMessage(HWindow, HLB_GETCURSEL, 0, 0L));
}


//------------------------------------------------------------------
// Sets tabs
//------------------------------------------------------------------

void THierListBox::SetTabs(WORD NumTabs, LPWORD Tabs)
{
  SendMessage(HWindow, HLB_SETTABSTOPS, NumTabs, (long)Tabs);
}


//------------------------------------------------------------------
// Sets horizontal extent
//------------------------------------------------------------------

void THierListBox::SetHorizExtent(WORD Extent)
{
  SendMessage(HWindow, HLB_SETHORIZONTALEXTENT, Extent, 0L);
}


//------------------------------------------------------------------
// Retrieves length of string at specified index
//------------------------------------------------------------------

int THierListBox::GetStringLen(int Index)
{
  int Len;

  Len = (int) SendMessage(HWindow, HLB_GETTEXTLEN, Index, 0L);
  return(Len);
}


//------------------------------------------------------------------
// Retrieves string at specified index. Length of string is returned.
//------------------------------------------------------------------

int THierListBox::GetString(LPSTR AString, int Index)
{
  int Len;

  Len = (int) SendMessage(HWindow, HLB_GETTEXT, Index, (long)AString);
  return(Len);
}


//------------------------------------------------------------------
// Clears Hierarchical listbox
//------------------------------------------------------------------

void THierListBox::ClearList()
{
  SendMessage(HWindow, HLB_RESETCONTENT, 0, 0L);
}


//------------------------------------------------------------------
// Loads Hierlist library
//------------------------------------------------------------------

BOOL THierListBox::LoadLibrary()
{			
  hLib  = ::LoadLibrary("HIERLIST.DLL");
  if (hLib < HINSTANCE_ERROR) 
  {
    return(FALSE);
  }
  return(TRUE);
}


//------------------------------------------------------------------
// Frees Hierlist library
//------------------------------------------------------------------

void THierListBox::FreeLibrary()
{
  if (hLib != NULL)
    ::FreeLibrary(hLib);
}
