//********************************************************************
//*                                                                  *
//*                           Hierlistbox                            *
//*                           Version 1.0                            *
//*              Copyright (c) 1993 Applied Visions, Inc.            *
//*                                                                  *
//********************************************************************
#ifndef __HLBTEST_H
#define __HLBTEST_H

#ifndef __TESTIDS_H
#include "testids.h"
#endif

//------------------------------------------------------------------
// Define constants
//------------------------------------------------------------------
const WORD ID_HIERLISTBOX = 110;

//------------------------------------------------------------------
// Define application class
//------------------------------------------------------------------
class TTestApp : public TApplication
{
public:
  TTestApp(LPSTR AName, HINSTANCE hInstance, HINSTANCE hPrevInstance,
    LPSTR lpCmdLine, int nCmdShow)
    : TApplication(AName, hInstance, hPrevInstance, lpCmdLine, nCmdShow) {};
  virtual void InitMainWindow();
};

//------------------------------------------------------------------
// Define Hierlistbox window
//------------------------------------------------------------------
class THierListBoxWindow : public TWindow
{
private:
  void CMDialog(RTMessage Msg) = [CM_FIRST + IDM_DIALOG];
  void CMAbout(RTMessage Msg) = [CM_FIRST + IDM_ABOUT];
public:
  PTHierListBox HierListBox;
  THierListBoxWindow(PTWindowsObject AParent, LPSTR ATitle);
  ~THierListBoxWindow();
  virtual void SetupWindow();
  virtual void CNHierList(RTMessage Msg)
    = [ID_FIRST + ID_HIERLISTBOX];
  virtual void WMSetFocus(RTMessage Msg) =
    [WM_FIRST + WM_SETFOCUS];
};


//------------------------------------------------------------------
// Define test dialogbox
//------------------------------------------------------------------
_CLASSDEF(TTestDialog)
class TTestDialog : public TDialog {
  PTHierListBox HierListBox;
protected:
  virtual void CMListBox(RTMessage Msg) = [ID_FIRST + IDD_LISTBOX];
  virtual void CMFill(RTMessage Msg) = [ID_FIRST + IDD_FILLLIST];
  virtual void CMClear(RTMessage Msg) = [ID_FIRST + IDD_CLEARLIST];
  virtual void SetupWindow();
public:
  TTestDialog(PTWindowsObject AParent, LPSTR AName);
};


#endif			

