/******************************************************************************
  
  DLGTST_I.PXP - Dialogue gadgets test suite
  Written for Autodesk 3D Studio 3.0
  
  (C) Copyright 1994 by Autodesk, Inc.

  This program is copyrighted by Autodesk, Inc. and is licensed to you under
  the following conditions.  You may not distribute or publish the source
  code of this program in any form.  You may incorporate this code in object
  form in derivative works provided such derivative works are (i.) are de-
  signed and intended to work solely with Autodesk, Inc. products, and (ii.)
  contain Autodesk's copyright notice "(C) Copyright 1994 by Autodesk, Inc."

  AUTODESK PROVIDES THIS PROGRAM "AS IS" AND WITH ALL FAULTS.  AUTODESK SPE-
  CIFICALLY DISCLAIMS ANY IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR
  A PARTICULAR USE.  AUTODESK, INC.  DOES NOT WARRANT THAT THE OPERATION OF
  THE PROGRAM WILL BE UNINTERRUPTED OR ERROR FREE.

*******************************************************************************/

#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include "pxp.h"
#include "dialog.h"
#include "keys.h"

/* IPAS III Dialog Definition */

/* Tree Identifiers: TREE1 */

#define REGUP	1
#define REGDN	2
#define REGSL	3
#define NUMUP	4
#define SCR50	5
#define SCR20	6
#define SCR5	7
#define SCRPICK	8
#define SCRDN	9
#define FIVE	10
#define FOUR	11
#define THREE	12
#define TWO	13
#define ICON2	14
#define ANY816	15
#define UPPER16	16
#define ANY12	17
#define FLOAT8	18
#define STRING	19
#define BUTTON	20
#define POSINT4	21
#define FRAME	22
#define BOX	23
#define ICON	24
#define BOXCHAR	25
#define EXIT	26
#define ONE	27
#define SCRBOX	29
#define SCRUP	30
#define SCRSL	31
#define SCR0	33
#define NUMSL	34
#define NUMDN	35
#define REGVALUE	36

/* Tree Dialog: TREE1 */

Dialog maindlg[]=
{
{ -1, 1, -1, -1, 0, 5, 5, 264, 428, NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, -1, 2, 1, 182, 376, 18, 18, "+", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 1, 3, 1, 16, 376, 18, 18, "-", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 2, 4, 0, 36, 376, 144, 18, NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 3, 5, 1, 230, 352, 18, 18, "+", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 4, 6, 1, 162, 292, 66, 18, "50", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 5, 7, 1, 162, 266, 66, 18, "20", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 6, 8, 1, 162, 238, 66, 18, "5", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 7, 9, 4, 36, 324, 82, 18, "1234567890", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 8, 10, 1, 126, 302, 20, 18, "", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 9, 11, 1, 195, 156, 42, 18, "5", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 10, 12, 1, 153, 156, 42, 18, "4", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 11, 13, 1, 111, 156, 42, 18, "3", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 12, 14, 1, 69, 156, 42, 18, "2", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 13, 15, 6, 148, 112, 43, 10, (void *)0, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 14, 16, 5, 60, 108, 75, 18, (void *)0, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 15, 17, 5, 52, 84, 139, 18, (void *)1, NULL, 0, 0, 0, 5, FNULL, FNULL, 0 }, 
{ 0, -1, 16, 18, 5, 148, 58, 107, 18, (void *)2, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 17, 19, 5, 62, 58, 75, 18, (void *)3, NULL, 0, 0, 0, 2, FNULL, FNULL, 0 }, 
{ 0, -1, 18, 20, 4, 8, 6, 248, 18, "Dialog test", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 19, 21, 1, 10, 30, 66, 18, " Button ", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 20, 22, 5, 10, 58, 43, 18, (void *)4, NULL, 0, 0, 0, 3, FNULL, FNULL, 0 }, 
{ 0, -1, 21, 23, 2, 88, 30, 68, 18, NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 22, 24, 0, 172, 30, 66, 18, NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 23, 25, 6, 204, 84, 52, 18, (void *)60, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 24, 26, 3, 10, 84, 28, 18, " C ", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 25, 27, 1, 98, 402, 66, 18, "Exit", NULL, 0, 0, 13, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 26, 28, 1, 27, 156, 42, 18, "1", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 27, 29, 4, 75, 136, 114, 18, "Radio Buttons:", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 28, 30, 0, 32, 202, 92, 118, NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 29, 31, 1, 126, 202, 20, 18, "", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 30, 32, 0, 126, 222, 20, 78, NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 31, 33, 4, 55, 182, 154, 18, "Scrolling Text Box:", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 32, 34, 1, 162, 212, 66, 18, "0", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 33, 35, 0, 36, 352, 192, 18, NULL, NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 34, 36, 1, 16, 352, 18, 18, "-", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
{ 0, -1, 35, -1, 3, 208, 376, 40, 18, "999", NULL, 0, 0, 0, 0, FNULL, FNULL, 0 }, 
};

/* Editables */

char editbuf0[17];
char editbuf1[17];
char editbuf2[13];
char editbuf3[9];
char editbuf4[5];

Editable mainedit[]=
{
{ 8, 16, 0, editbuf0, 0, 0, 0, NULL, NULL }, 
{ 16, 16, 0, editbuf1, 5, 0, 0, NULL, NULL }, 
{ 12, 12, 0, editbuf2, 0, 0, 0, NULL, NULL }, 
{ 8, 8, 0, editbuf3, 2, 0, 0, NULL, NULL }, 
{ 4, 4, 0, editbuf4, 3, 0, 0, NULL, NULL }, 
};

/* Icons */

uchar mainicon[]=
{
   0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 
   0x80, 0x00, 0x00, 0x00, 0x00, 0x20, 
   0x9E, 0x71, 0xCC, 0xC2, 0x8E, 0x20, 
   0x8C, 0xDB, 0x6E, 0xC7, 0xDB, 0x20, 
   0x8C, 0xC3, 0x6E, 0xC2, 0x83, 0x20, 
   0x8C, 0xC3, 0x6D, 0xC2, 0x8E, 0x20, 
   0x8C, 0xDB, 0x6D, 0xC7, 0xD8, 0x20, 
   0x9E, 0x71, 0xCC, 0xC2, 0x9F, 0x20, 
   0x80, 0x00, 0x00, 0x00, 0x00, 0x20, 
   0x7F, 0xFF, 0xFF, 0xFF, 0xFF, 0xC0, 
   0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 
   0x1C, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 
   0x03, 0x80, 0x00, 0x00, 0x00, 0x1C, 0x00, 
   0x00, 0x70, 0x00, 0x00, 0x00, 0xE0, 0x00, 
   0x00, 0x0E, 0x00, 0x00, 0x07, 0x00, 0x00, 
   0x00, 0x01, 0xC0, 0x00, 0x38, 0x00, 0x00, 
   0x00, 0x00, 0x38, 0x01, 0xC0, 0x00, 0x00, 
   0x00, 0x00, 0x07, 0x0E, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x07, 0x0E, 0x00, 0x00, 0x00, 
   0x00, 0x00, 0x38, 0x01, 0xC0, 0x00, 0x00, 
   0x00, 0x01, 0xC0, 0x00, 0x38, 0x00, 0x00, 
   0x00, 0x0E, 0x00, 0x00, 0x07, 0x00, 0x00, 
   0x00, 0x70, 0x00, 0x00, 0x00, 0xE0, 0x00, 
   0x03, 0x80, 0x00, 0x00, 0x00, 0x1C, 0x00, 
   0x1C, 0x00, 0x00, 0x00, 0x00, 0x03, 0x80, 
   0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 
};

extern void see_box(), see_reg_value();

static SeeSub main_see[]=
{
   SCRBOX, see_box, 
   REGVALUE, see_reg_value, 
   -1, FNULL
};

extern void feel_exit(), feel_boxchar();
extern void feel_scr0(), feel_scr5(), feel_scr20(), feel_scr50();

static FeelSub main_feel[]=
{
   EXIT, feel_exit, 
   BOXCHAR, feel_boxchar, 
   SCR0, feel_scr0, 
   SCR5, feel_scr5, 
   SCR20, feel_scr20, 
   SCR50, feel_scr50, 
   -1, FNULL
};

int rad_nums=1;

static RadSub main_rad[]=
{
   ONE, feel_radio, &rad_nums, 1, 
   TWO, feel_radio, &rad_nums, 2, 
   THREE, feel_radio, &rad_nums, 3, 
   FOUR, feel_radio, &rad_nums, 4, 
   FIVE, feel_radio, &rad_nums, 5, 
   -1, FNULL, NULL, -1
};

Name_list *main_list=NULL;
Scroller main_scroll=
{0, 0, 0, 0, 0, NULL, NULL, NULL};
extern void feel_main_box();

static ScrSub main_scr[]=
{
   SCRUP, SCRDN, SCRSL, SCRBOX, feel_main_box, &main_scroll, 
   -1, -1, -1, -1, FNULL, NULL
};

static Slider numsl=
{0, 100, 50};
static Slider regsl=
{-40, 40, 0};

static SlidSub main_slid[]=
{
   NUMSL, NUMDN, NUMUP, SLID_NUM, 0, &numsl, 
   REGSL, REGDN, REGUP, SLID_REG, 1, &regsl, 
   -1, -1, -1, -1, -1, NULL
};

/* End of IPAS III Dialog */

void maindlg_special(void);

/* Variable definitions */

/************************/

/* Dialog description */

DlgEntry cdialog[]=
{
   0, NULL
};

/* Version test value */

#define VERSION 0x0000

typedef struct
{
   ulong version;
} State;

/* Function Prototypes */
void do_user_interaction();
void load_names(int number, int draw);

/* the "state" struct MUST start with a "ulong" which is the version#, 
   to prevent using data from old versions of this program.
   This verification is performed automatically. */

static State init_state = { VERSION };
static State state = { VERSION };

/*----------------------------------------------------------------*/

int ClientUsesInitDialog(void)
{
   return(0);
}

void ClientSetStateVar(int id, void *ptr)
{
   OVL o;
   ulong *ul;
   char *s;
   
   ul=(ulong *)ptr;
   s=(char *)ptr;
   o.ul = *ul;
}

ulong ClientGetStateVar(int id)
{
   OVL o;
   return(o.ul);
}

int ClientVarSize(int id)
{
      return(1);
}

char  *ClientGetState(int *size)
{
   *size = sizeof(State);
   return((char *)&state);
}

void ClientResetState()
{
   state = init_state;
}

void ClientStartup(EXPbuf *buf)
{
   int version=studio_version();
   
   if(version<300)
   {
      strcpy(buf->data.string, "ERROR: Requires 3DS version 3.0 or greater");
      buf->opcode=EXP_CONTINUE;
      buf->usercode=EXP_TERMINATE;
   }
   else
   {
      buf->opcode=EXP_NOP;
      buf->usercode=0x0200;
   }
}

/* User routines -- use user codes to process your data */

void ClientUserCode(EXPbuf *buf)
{
   switch(buf->usercode)
   {
   case 0x0200:
      do_user_interaction();
      buf->opcode=EXP_TERMINATE;
      buf->usercode=EXP_TERMINATE;
      break;
      
   default:
      buf->opcode=buf->usercode=EXP_TERMINATE;
      buf->status=0;
      break;
   }
}

void ClientTerminate(void)
{
   /* free any data structures, etc. */
}

DlgEntry *ClientDialog(int n)
{
   return(&cdialog[n]);
}

/* This function should return 1 if the PXP can function in any module, 	*/
/* otherwise, it should return 0.										*/

int ClientIsUniversal(void)
{
   return(1);
}

void do_user_interaction()
{
   static int inited = 0;
   
   if (! inited)
   {
      init_dialog(maindlg, mainedit, mainicon);
      inited = 1;
   }
   ready_dialog(maindlg, mainedit, main_see, main_feel, main_rad, main_scr, 
		main_slid);
   maindlg_special();
   center_dialog(maindlg);
   save_under_dialog(maindlg);
   draw_dialog(maindlg);
   do_dialog(maindlg, FLOAT8);
   restore_under_dialog();
}

/* User-defined dialog control functions */

void maindlg_special(void)
{
   init_editable(&maindlg[POSINT4], "123");
   init_editable(&maindlg[FLOAT8], "12.345");
   init_editable(&maindlg[ANY12], "Any Chars");
   init_editable(&maindlg[UPPER16], "UPPERCASE 16");
   init_editable(&maindlg[ANY816], "Any Chars 8/16");
   
   /* Build up a list of names, don't draw */
   
   load_names(20, 0);
}

void feel_exit(Dialog *d, int mouse)
{
   int status;
   
   if(mouse)
      if(!(press_button(d)))
	 return;
   gfx_yes_no_line("Exit test suite?", status);
   if(status)
      dialog_done=1;
}

void feel_boxchar(Dialog *d, int mouse)
{
   gfx_continu_line("Pressed BOXCHAR");
}

void see_box(Dialog *d)
{
   draw_inbox(d, CYAN);
   prt_list(d);
}

void feel_main_box(Dialog *d, int mouse)
{
   char *name;
   
   if ((name = sel_name(d))!=NULL)
   {
      strcpy(maindlg[SCRPICK].text, name);
      centered_text(&maindlg[SCRPICK], WHITE, DKGRAY, 1);
   }
}

void feel_scr0(Dialog *d, int mouse)
{
   if(mouse)
      if(!(press_button(d)))
	 return;
   load_names(0, 1);
}

void feel_scr5(Dialog *d, int mouse)
{
   if(mouse)
      if(!(press_button(d)))
	 return;
   load_names(5, 1);
}

void feel_scr20(Dialog *d, int mouse)
{
   if(mouse)
      if(!(press_button(d)))
	 return;
   load_names(50, 1);
}

void feel_scr50(Dialog *d, int mouse)
{
   if(mouse)
      if(!(press_button(d)))
	 return;
   load_names(50, 1);
}

void load_names(int number, int draw)
{
   int ix=0;
   char *names[]=
   {
      "Tom", 
      "Bill", 
      "Jacob", 
      "Mike", 
      "Dan", 
      "Gary", 
      "Mark", 
      "Richard", 
      "Elizabeth", 
      "Ralph", 
      "Clyde", 
      "Aurora", 
      "Steve", 
      "Robert", 
      "James", 
      "Mitchell", 
      "Aaron", 
      "Douglas", 
      "Patricia", 
      "Jane", 
      "Mary", 
      "Susan", 
      "Kathy", 
      "Stephanie", 
      "Ellie", 
      "David", 
      "Sandy", 
      "Clint", 
      "Cliff", 
      "Kyle", 
      "Mercy", 
      "Bob", 
      "Joan", 
      "Jon", 
      "John", 
      "Julie", 
      "Tim", 
      "Terry", 
      "Tony", 
      "Dorothy", 
      "Keith", 
      "Marvin", 
      "Bernie", 
      "Roger", 
      "Anne", 
      "Paul", 
      "Jerry", 
      "Marina", 
      "Brent", 
      "Patrick", 
      NULL
   };
   
   strcpy(maindlg[SCRPICK].text, "----------");
   
   free_name_list(&main_list);
   
   while(names[ix] && number)
   {
      add_to_name_list(&main_list, names[ix++]);
      number--;
   }
   
   sort_name_list(main_list);
   init_scroller(&main_scroll, main_list);
   if(draw)
   {
      draw_item_number(maindlg, SCRBOX);
      draw_item_number(maindlg, SCRSL);
      draw_item_number(maindlg, SCRPICK);
   }
}

void ClientSliderAction(int code)
{
   Dialog *d;
   
   switch(code)
   {
   case 1:
      d= &maindlg[REGVALUE];
      (d->see)(d);
      break;
   }
}

static void see_reg_value(Dialog *d)
{
   sprintf(d->text, "%d", regsl.value);
   see_boxchar(d);
}










