#ifndef IMAGE_LS
#define IMAGE_LS
#include "..\library\liberror.h"  // all error codes

#define         MAX_FILE_NAME           127

#define ERR_CODE        WORD

// LIST of error codes of the ERR_CODE type
#define ERR_OK                          0x0000  // there is no error
#define ERR                                     0x8003

/* File types... */
	#define  BMP_FILE       1
	#define  GIF_FILE       2
	#define  PCX_FILE       3
	#define  TGA_FILE       4
	#define  TIF_FILE       5
	#define  FLI_FILE       6
	#define  FLC_FILE       7
	#define  JPG_FILE       8

	#define ERR_CODE        WORD

// LIST of error codes of the ERR_CODE type
	#define ERR_OK          0x0000  // there is no error
	#define ERR                     0x8003
	#define         ERR_RETURN      WORD
     #define    S_TYPE          FAR PASCAL

	#define  IS_ANIMATION_TYPE(x) (x==FLI_FILE || x==FLC_FILE)

/* FILEINFO structure is used with all load and save functions */

typedef struct {
	char szFileName[MAX_FILE_NAME+1];  //Name of the file
	WORD wFileType;                         //File type (one of the following)
	WORD wCompression;                              //0=no compression, 1=compression
							//With JPEG file this parametar defines quality (1..100)
	WORD nFrames;                      //Number of frames (in animation file only - wFileType is FLI_FILE or FLC_FILE)
} FILEINFO, FAR *LPFILEINFO;

ERR_RETURN S_TYPE ImageLoad(LPFILEINFO lpFileInfo, LPFRAME lpFrame, short nFrame);

ERR_RETURN S_TYPE ImageSave(LPFILEINFO lpFileInfo, LPFRAME lpFrame);

ERR_RETURN S_TYPE FLXGetInfo(LPFILEINFO lpFileInfo, LPFRAME lpFrame);
ERR_RETURN S_TYPE FLXLoad(LPFILEINFO lpFileInfo, LPFRAME FAR* lpFrame, short nStartFrame,short nEndFrame);
ERR_RETURN S_TYPE FLXSave(LPFILEINFO lpFileInfo, LPFRAME FAR* lpFrame, short nFrames);
ERR_RETURN S_TYPE FLXAppend(LPFILEINFO lpFileInfo, LPFRAME FAR* lpFrame, short nFrames);

#endif
