/* This header is made for user defined modules in in which
   Image Tools DLL or Image Tools LIB will be linked.
   It is a short replacement for system.h, file.h and picture.h */

#ifndef SYSPIC_H
  #define SYSPIC_H

#include <fcntl.h>

#define 	MAX_FILE_NAME		127

#ifdef BORLAND
	#pragma option -a-      /* Assume byte packing throughout */
#endif
/*
#define USHORT					    		WORD
#define SHORT					    		short
#define ULONG						    	DWORD
#define LONG							long
*/
typedef WORD                            huge *LPHWORD;
typedef BYTE                            huge *LPHBYTE;
typedef char                            huge *LPHSTR;

#define ERR_CODE 	WORD

// LIST of error codes of the ERR_CODE type
#define	ERR_OK				0x0000	// there is no error
#define	ERR					0x8003

/* Three usefull macros */
#define ROUND2LONG(x)	(((x & 3) == 0) ? (x) : ((x | 3) + 1))
#define AllocFrame(x)	((x).hPicture=GlobalAlloc(GPTR, (long)ROUND2LONG((x).iWidth*3)*(x).iHeight))
#define FreeFrame(x)	{if((x).hPalette) DeleteObject((x).hPalette);if((x).hPicture) GlobalFree((x).hPicture);if((x).hBackground) GlobalFree((x).hBackground);}

typedef struct {
    WORD    	iWidth,        // picture dimensions
            	iHeight;
    HANDLE  	hPicture;		// handle of memory allocation for picture bits
    HANDLE  	hBackground;	// handle of memory allocation for background bits
   						//	... for now only '.TGA' picture format
    WORD	  	iNumBits,      // 8 or 24
    	  		nPalEntries;   // number of optimized palette entries
    HPALETTE  	hPalette;      // handle of windows logic palette
} FRAME, FAR *LPFRAME;
#endif //SYSPIC
