#include "colors.inc"
#include "shapes.inc"
#include "textures.inc"
#include "tour.inc"

#declare Ball1_Texture = texture {
   color Red
   phong .8  phong_size 60
   ambient 0.15
   diffuse 0.8
}

#declare Building_Texture = texture {
   phong .8  phong_size 60
   ambient 0.4
   diffuse 0.5
}

camera {
	location <xpos ypos zpos>
	direction <0 0 1.5>
	up <0 1 0>
	right <1.33 0 0>
	look_at <xlook ylook zlook>
}

object {
	light_source { <-10 10 -20> color White}
}

object {
	light_source { <10 10 -20> color White}
}

object {
	light_source { <3 10 20> color White}
}

//  Buildings
object {
	box {<-.5 0 -2> <.5 3 2>}
	texture {Building_Texture color green .8}
	translate <-8 0 0>
}

object {
	box {<-1 0 -.5> <1 2 .5>}
	texture {Building_Texture color blue .8}
	translate <4 0 -4>
}

object {
	box {<-1 0 -.5> <1 2 .5>}
	texture {Building_Texture color blue .8}
	translate <9 0 -4>
}

object {
	box {<-1 0 -.5> <1 2 .5>}
	texture {Building_Texture color blue .8}
	translate <4 0 4>
}

object {
	box {<-1 0 -.5> <1 2 .5>}
	texture {Building_Texture color blue .8}
	translate <9 0 4>
}

object {
	box {<-.7 0 -.5> <.7 4 .5>}
	texture {Building_Texture color blue .5 red .5}
	translate <-6 0 -6>
}

object {
	box {<-2 0 -.5> <2 3 .5>}
	texture {Building_Texture color blue .5 red .5}
	translate <-7 0 6>
}

//  Dome
object {
	sphere { <0 0 0> 1.6}
	texture { Ball1_Texture }
}


// floor
object {
   plane { <0 1 0> 0 }
   texture { color red .7 green .7 blue .7}
}

/*
// back wall
object {
   plane { <0 0 1> 100 }
   texture { color red 0.3 green 0.3 blue 0.5 }
}
*/
