// ddemdi.cpp

#include "ddemdi.h"

/***************************** TMDIDDETestApp ************************************/

// Construct the TMDIDDETestApp's MainWindow object, loading its menu
void TMDIDDETestApp::InitMainWindow()
{
  MainWindow = new TMDIFrameDDETest("MDIDDETest", "MAIN_MENU");
}

/******************************* TMDIFrameDDETest ***************************************/

// TMDIFrameDDETest Constructor
TMDIFrameDDETest::TMDIFrameDDETest(LPSTR ATitle, LPSTR MenuName)
	: TMDIFrame(ATitle, MenuName)
{
	ConnectAWindow = ConnectBWindow = NULL;
}

// TMDIFrameDDETest destructor
TMDIFrameDDETest::~TMDIFrameDDETest()
{

}

// Routine to Create a Connection Window for first instance of Server
void TMDIFrameDDETest::MConnectA()
{
	if( ConnectAWindow )
		ConnectAWindow->CloseWindow();
	else
	{
		strcpy(ChildName,"ServerA");
		ConnectAWindow = (PTConnectWindow)CreateChild();
    }
}

// Routine to Create a Connection Window for second instance of Server
void TMDIFrameDDETest::MConnectB()
{
	if( ConnectBWindow )
		ConnectBWindow->CloseWindow();
	else
	{
  		strcpy(ChildName,"ServerB");
		ConnectBWindow = (PTConnectWindow)CreateChild();
    }
}

// Create a MDI Child Window
PTWindowsObject TMDIFrameDDETest::InitChild()
{
	return new TConnectWindow(this, ChildName, ChildName);
}

/******************************** TConnectWindow *****************************************/

// TConnectWindow Constructor
TConnectWindow::TConnectWindow(PTWindowsObject WType, LPSTR WTitle, char *service)
	: TWindow(WType, WTitle)
{
	Parent = (PTMDIFrameDDETest) WType;
    strcpy(Service, service);
	Data = NULL;

    // Allocate DDEManager, try to connect 4 times
	if( DDEConv = new DDEManager(Parent->GetApplication()->hInstance, this) )
    {
		if( !DDEConv->Connect(Service, "Topic") )
		{
			WinExec("DDESVTST", SW_MINIMIZE);
			for( int i=0; i<3; i++ )
				if( DDEConv->Connect(Service, "Topic") )
					break;
        }
		if( DDEConv->IsConnected() )
		{
			if( !DDEConv->RegisterAdviseProc(&AdviseProc, "Item") )
				MessageBox(NULL, DDEConv->GetErrorText(), "DDE Register Failed", MB_OK);
		}
        else
			MessageBox(NULL, DDEConv->GetErrorText(), "DDE Connect Failed", MB_OK);
	}
    else
		MessageBox(NULL, "new DDE Manager Allocation Failed", "DDEMDI", MB_OK);
}

// Callback function for Advise loop.  This is actually a member of TConnectWindow,
// but cannot have a "this" pointer, so is declared externally.  DDEManager will
// return my "this" pointer if suppplied in the Initialize step
void AdviseProc(char * data, void * This)
{
	PTConnectWindow CThis = (PTConnectWindow) This;
	if( CThis )
	{
		if( CThis->Data )
        	delete [] CThis->Data;
		CThis->Data = data;
	}

    InvalidateRect(CThis->HWindow, NULL, TRUE);
}

// Display data if it exists
void TConnectWindow::Paint(HDC DC, PAINTSTRUCT&)
{
	if( Data )
		TextOut(DC, 0, 0, Data, strlen(Data));
}

// TConnectWindow Destructor
TConnectWindow::~TConnectWindow()
{
    // Tell Parent that child has been closed
	if( !strcmp(Service, "ServerA") )
		Parent->ConnectAWindow = NULL;
	else
		Parent->ConnectBWindow = NULL;
	if( DDEConv )
		delete DDEConv;
}


/********************************** WinMain *******************************************/

// Run the MDIApp
int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
		   LPSTR lpCmd, int nCmdShow)
{
    TMDIDDETestApp MDIApp ("DDEMDI", hInstance, hPrevInstance,
		lpCmd, nCmdShow);
    MDIApp.Run();
    return (MDIApp.Status);
}
