// Pre-packaged DDE Client class that encapsulates DDE and combines some functions
// Intellectual property of Lance Klein 11/93
//
//*********************************************************************************
//  Instructions for Use:
//  --------------------
//  There are two basic ways to use this class:
//   1. One-time request
//   2. Full-fledged conversation management
//
//  ONE TIME REQUEST:
//  ================
//   1. Declare instance of DDEManager
//   2. Call GetDDEItem function:
//      pstrResult = pDDEManager->GetDDEItem( "Service", "Topic", "Item",
//                                            pstrData, lstrData, hInstance );
//      where:
//       "Service" is the name of the service desired (i.e. "MSAccess")
//       "Topic" is the name of the topic desired (i.e. "NWIND")
//       "Item" is the name of the item desired (i.e. "TableList")
//         (by the way, the above examples will cause Microsoft Access -
//         assuming Access is running and the Northwind Database is open -
//         to return a list of available tables)
//       pstrData is a pointer to the return string the user would like to use
//         (if this pointer is NULL, GetDDEItem returns a pointer to a dynamically
//         allocated character array, which the user must then delete)
//       lstrData is an integer value of the length of pstrData (i.e. sizeof())
//       pstrResult is a pointer to the returned data (may be pstrData if not NULL).
//         If the function fails, pstrResult will be NULL.
//       hInstance is the instance handle of the user application (a Windows API thing) 
//         (this may optionally be NULL if it was supplied in the constructor
//         call - i.e. pDDEManager = new DDEManager(hInstance); )
//
//  FULL-FLEDGED CONVERSATION MANAGEMENT:
//  ====================================
//   1. Declare Instance of DDEManager
//   2. Call Connect function:
//      BoolResult = pDDEManager->Connect( "Service", "Topic", hInstance );
//      where:
//       "Service" is the name of the service desired (i.e. "MSAccess")
//       "Topic" is the name of the topic desired (i.e. "NWIND;SQL ")
//       hInstance is the instance handle of the user application (a Windows API thing)
//         (this may optionally be NULL if it was supplied in the constructor
//         call - i.e. pDDEManager = new DDEManager(hInstance); )
//       If the connect fails (i.e. the server is not available or detects an error)
//         then BoolResult will be FALSE.
//   3. Call the IsConnected funtion:
//      BoolResult = pDDEManager->IsConnected();
//       BoolResult will be TRUE if the connection is active, FALSE if not.
//   4. Call the Poke function
//      BoolResult = pDDEManager->Poke("Item", pstrPokeString )
//      where:
//       "Item" is the name of the item desired (i.e. "Data")
//       pstrPokeString is the string of data to be sent to the Server
//         (i.e. "select * from Customers;") 
//   5. Call the Request function:
//      pstrResult = pDDEManager->Request( "Item", pstrData, lstrData )
//       where:
//       "Item" is the name of the item desired (i.e. "Data")
//         (by the way, the above examples will cause Microsoft Access -
//         assuming Access is running and the Northwind Database is open -
//         to return the result of the SQL statement in tab-separated lines)
//       pstrData is a pointer to the return string the user would like to use
//         (if this pointer is NULL, GetDDEItem returns a pointer to a dynamically
//         allocated character array, which the user must then delete)
//       lstrData is an integer value of the length of pstrData (i.e. sizeof())
//       pstrResult is a pointer to the returned data (may be pstrData if not NULL).
//         If the function fails, pstrResult will be NULL.
//   6. Call the Execute function:
//      BoolResult = pDDEManager->Execute("Command");
//       where "Command" is the command to be executed (i.e. "[CloseDatabase]")
//       BoolResult will be FALSE if the function failed.
//   7. Call the Disconnect function:
//      BoolResult = pDDEManager->Disconnect();
//       This will terminate the DDE Conversation.
//       BoolResult will be FALSE if the function failed.
//
//   The text of any error message can be accessed using the GetErrorText() function.
//
//*********************************************************************************

#ifndef _DDEMGR_H_
#define _DDEMGR_H_

#include <string.h>
#include <windows.h>
#include <ddeml.h>

#define	MAX_PTRS	50

class	DDEManager;
class	ThisServer;
typedef	void adviseproc(char * data, void * This);
static	ThisServer *TServer = NULL;


// Server to manage "this" pointers for DDEManager instances 
class ThisServer
{
public:
	// Constructor:
	ThisServer() 
	{
		memset(&ThisTable[0], 0x0, sizeof(DDEManager *)*MAX_PTRS);
		memset(&ConvTable[0], 0x0, sizeof(HCONV)*MAX_PTRS);
		num_ptrs = 0;
	};

	// Register a this pointer (verify not already registered)
	BOOL RegisterThis(DDEManager *This, HCONV hConv)
	{
		if( !GetThis(hConv) && (num_ptrs != MAX_PTRS) )
		{
			ConvTable[first_empty] = hConv;
			ThisTable[first_empty] = This;
			num_ptrs++;
			return TRUE;
		}
		return FALSE;
	};

	// Find this pointer and remove from table
	BOOL UnRegisterThis(HCONV hConv)
	{
		if( GetThis(hConv) )
		{	
			ConvTable[curr_selection] = 0;
			ThisTable[curr_selection] = NULL;
			num_ptrs--;
			return TRUE;
		}
		return FALSE;
	};

	// Find requested this pointer
	DDEManager * GetThis(HCONV hConv)
	{
		first_empty = curr_selection = MAX_PTRS;
		for( int i=0; (i < MAX_PTRS) &&
				(first_empty == MAX_PTRS || curr_selection == MAX_PTRS); i++)
		{
			if( !ThisTable[i] && (first_empty == MAX_PTRS) )
				first_empty = i;
			if( ConvTable[i] && (ConvTable[i] == hConv) )
				curr_selection = i;
		}
		if( curr_selection < MAX_PTRS )
			return ThisTable[curr_selection];
		else
			return NULL;
	};

	int NumThis() { return num_ptrs; };

private:
	DDEManager *	ThisTable[MAX_PTRS];
	HCONV		ConvTable[MAX_PTRS];
	int first_empty, curr_selection, num_ptrs;
};


class DDEManager
{
public:

	// Constructor & Destructor
	DDEManager(HINSTANCE Inst = NULL, void * clientthis = NULL,
				char * DDEService = NULL, char * DDETopic = NULL);
	virtual ~DDEManager();

	// Single request function:
	virtual char *GetDDEItem(char * DDEService, char * DDETopic, char * DDEItem,
						char * retdata = NULL, int lenretdata = 0,
						HINSTANCE Inst = NULL, void * clientthis = NULL);

	// Conversation management functions:
	virtual BOOL Initialize(HINSTANCE, void * clientthis = NULL);
	virtual BOOL Connect(char * DDEService, char * DDETopic,
						void * clientthis = NULL, HINSTANCE Inst = NULL);
	virtual char *Request(char * DDEItem, char * retdata = NULL, int lenretdata = 0);
	virtual BOOL Poke(char * DDEItem, char * data);
	virtual BOOL Execute(char * command);
	virtual BOOL RegisterAdviseProc(adviseproc * advproc, char * DDEItem = NULL);
	virtual BOOL BeginAdvise(char * DDEItem);
	virtual BOOL EndAdvise();
	virtual BOOL Disconnect();

	// Informational functions:
	virtual BOOL IsConnected();
	virtual BOOL IsRegistered();
	virtual char *GetErrorText();

	// Callback funtion:
	static HDDEDATA FAR PASCAL _export CallBack(WORD Type, WORD,
			HCONV Conv, HSZ, HSZ, HDDEDATA Data, DWORD, DWORD);


protected:
	HSZ hszService, hszTopic, hszItem;
	DWORD idInst;
	HCONV hConv;
	HINSTANCE hInst;
	FARPROC lpCallBack;
	char * RetData;
	int LenRetData;
	BOOL IsInAdviseLoop, IsAdviseData;
	char errortext[80];
	void * ClientThis;

	virtual void ReceivedData(HDDEDATA hData);
	
	adviseproc * pClientReceiveProc;

};

#endif


