// ddetest.h

#include <owl.h>
#include <inputdia.h>
#include <stdio.h>
#include <string.h>
#include <dialog.h>
#include <edit.h>

#include "ddemgr.h"
#include "ddetestr.h"

struct ItemBuf
{
	char Service[64];
	char Topic[256];
	char Item[256];
};


_CLASSDEF(TDMLClApp)
class TDMLClApp : public TApplication
{
public:
    TDMLClApp( LPSTR, HINSTANCE, HINSTANCE, LPSTR, int );
    ~TDMLClApp();
    virtual void InitMainWindow();
};

_CLASSDEF(TDMLClWnd)
class TDMLClWnd : public TWindow
{
public:
    TDMLClWnd( PTWindowsObject, LPSTR );
	virtual ~TDMLClWnd();

    virtual void SetupWindow();
	virtual void Paint( HDC, PAINTSTRUCT _FAR & );

    virtual void WMInitMenu( RTMessage ) = [WM_FIRST + WM_INITMENU];
    virtual void CMExit( RTMessage ) = [CM_FIRST + CM_EXIT];
    virtual void CMUConnect( RTMessage ) = [CM_FIRST + CM_U_CONNECT];
    virtual void CMURequest( RTMessage ) = [CM_FIRST + CM_U_REQUEST];
	virtual void CMUPoke( RTMessage ) = [CM_FIRST + CM_U_POKE];
	virtual void CMUExecute( RTMessage ) = [CM_FIRST + CM_U_EXECUTE];
	virtual void CMUAdvise( RTMessage ) = [CM_FIRST + CM_U_ADVISE];
	virtual void CMUDisconnect( RTMessage ) = [CM_FIRST + CM_U_DISCONNECT];
	virtual void CMUGetItem( RTMessage ) = [CM_FIRST + CM_U_GETITEM];
	virtual void CMUHelpAbout( RTMessage ) = [CM_FIRST + CM_U_HELPABOUT];

    ItemBuf ItemBuffer;

	char	*sData;

protected:
	DDEManager *DDEConv1;

	char	sService[128], sTopic[128], sItem[128], sPoke[128], sExec[128];
	BOOL	tfLoop;
	
	
};


class DDEItemDialog : public TDialog
{
public:
	DDEItemDialog(PTWindowsObject AParent,
				int lenservice, int lentopic, int lenitem );
	~DDEItemDialog();

	void WMCtlColor(RTMessage Msg) = [WM_FIRST + WM_CTLCOLOR];

	COLORREF BKColor;
	HBRUSH hBkBrush;

	PTEdit EditService;
	PTEdit EditTopic;
	PTEdit EditItem;
};

// Forward declaration of client callback for advise loop:
void AdviseProc(char *, void *);

