/* cputz4p.c  -  Decoding image in Z4Plane format to VRAM, CHAINED mode.
 *
 * Description:
 *   Uses the coding method, described in mputz4p.c
 * See Also:
 *      mputz4p.c, uputz4p.c
 * Functions:
 *      CputZ4Planes().
 * Portability: BORLANDC
 *                                      (c) erdy 1992
 * $Header: $
 */
#pragma inline
#include "far.h"
#include "vgaprefx.h"
#include "vgadrv.h"
#include "screen.h"


void CputZ4Planes(char far *image, unsigned x, unsigned y, int rows)
        /* in case of ZC_PREPARED x is unused, y contains VRAM offset.
         */
{
        _ES = Scdraw_seg;

	asm push ds;
	asm lds si, image;
	asm cld;
#       ifdef ZC_PREPARED
                asm mov di, y;
#       else  ZC_PREPARED
                _DI = VIDEO_CADDRESS(x, y);
#       endif ZC_PREPARED

        asm mov dx, rows;
        asm push bp;
        asm mov cx, BITPLANES;
PlaneLoop:
        /*
         * Planes loop.
         * CX contains plane counter.
         * DX contains row counter.
         */
        asm push cx;                    /* Save plane counter */
        asm push di;                    /* Save starting offset */
        asm mov  cx, dx;                /* Store row counter in cx */
RowLoop:
                /*
                 * Scanlines loop. CX contains nrows.
                 * Scratch registers:
                 *      bx - saving the ram index (di)
                 *      bp - saving the loop counter (cx)
                 */
                asm mov bx, di;                 /* Save ram index */
                asm mov bp, cx;                 /* Save loop counter */
                asm xor ch, ch;                 /* Zero high byte, ch always zero */
                /* Loop until EOL */
                asm jmp short LineLoop;         /* Jump over the literal-dealing code */
                                                /* This tricky is for optimizing jumps */
Literal:
                        asm movsb;              /* Copy cx bytes */
                        asm add di, BITPLANES-1;
                        asm loop Literal;
LineLoop:
			asm lodsb;              /* al <- ds:[si++]; get next byte */
                        asm mov cl, al;         /* Move code */

                        asm or al, al;          /* Query flags */
                        asm jg Literal;         /* al > 0, so literally */
                        asm je short String;    /* al == 0, string or EOL */
Skip:                                           /* Otherwise skipping */
                        asm neg cl;             /* Invert counter */
                        asm jo Eol;             /* Overflow, i.e. neg 128 */
                        asm shl cx, 1;          /* Mul by 4 */
                        asm shl cx, 1;
                        asm add di, cx;         /* Advance the index */
                        asm xor ch, ch;         /* Zero high byte, ch always zero */
                        asm jmp short LineLoop;
String:
                        asm lodsb;              /* Get counter byte */
			asm mov cl, al;		/* Put counter to cl */
                        asm lodsb;              /* Get color byte into al */
Sloop:
                        asm stosb;              /* Store cx bytes of al */
                        asm add di, BITPLANES-1;
                        asm loop Sloop;

                        asm jmp short LineLoop;
Eol:
		asm mov di, bx;                 /* Restore ram index */
                asm add di, BPERROW_CHAINED;            /* Advance ram index to next row */

		asm mov cx, bp;                 /* Restore row counter */
		asm loop RowLoop;

	asm pop di;             /* Restore the initial offset */
        asm inc di;             /* Next bitplane */
        asm pop cx;             /* Restore loop counter */
        asm loop PlaneLoop;

        asm pop bp;
	asm pop ds;
	return;
}