/* UputZCompact().   Drawing image in ZCompact format.
 *
 * UNCHAINED mode version. For mode 13h (MCGA), C4 off (UNCHAINED).
 *
 * Uses following coding method:
 *
 * Line    ends by a 0, 0 (color code = 0, counter = 0)
 * Picture ends by rows counter.
 *
 *     +7-------------------6+5----------------------0+
 *     | counter (1 till 3)  |  color code (0 - 63)   |
 *     +---------------------+------------------------+
 * or
 *     +7-6+5------------0+    +7---------------------0+
 *     | 0 | color code   |    |  counter              |
 *     +---+--------------+    +-----------------------+
 *
 * Functions:
 *      UputZCompact().
 *
 * See Also: cputc.c
 * Portability: BORLANDC
 *                                       (c) erdy 1992
 * $Header: $
 */
#pragma inline
#include "far.h"
#include "vgaprefx.h"
#include "vgadrv.h"
#include "screen.h"

static void near map_masks(void) /* Just to situate the mask table */
{
#if 0
	asm lmsk label byte
        asm db 0xF, 0x7, 0x3, 0x1;
#endif
	asm rmsk label byte
        asm db 0x0, 0x1, 0x3, 0x7;
}

#ifdef ZC_PREPARED
        void UputZCompact(char far *image, int mask, int offset, int rows)
#else
        void UputZCompact(char far *image, int x, int y, int rows)
#endif ZC_PREPARED
{
	_CX = rows;
        _ES = Scdraw_seg;

        asm mov dx, VGA_SER_ADR;      /* Point the gate to Map Mask Register */
        asm mov al, _SER_MAPMASK;
	asm out dx, al;

	asm push ds;
	asm pop bx;

	asm lds si, image;

#       ifdef ZC_PREPARED
		asm mov di, offset;
		asm mov ax, mask;
		asm push bp;
		asm mov bp, ax;         /* Initial starting offset */
#       else  ZC_PREPARED
		asm mov ax, y;          /* Get argument */
		asm mov dx, BPERROW;
		asm mul dx;

		asm mov dx, x;          /* Get argument */
		asm mov di, dx;
		asm shr di, 1;          /* Divide di by 4 */
		asm shr di, 1;
		asm and dx, 3;
		asm add di, ax;

		asm push bp;
		asm mov bp, dx;         /* Get initial starting offset */
#       endif ZC_PREPARED
	asm push bx;
	asm cld;
	/*
	 * Scanline loop. CX contains nrows.
	 */
Loop:
		asm push cx;                    /* Loop counter */
		asm push bp;                    /* Starting offset */
		asm push di;                    /* Save DI */

		asm mov bh, byte ptr cs:rmsk[bp];/* Starting mask */

		for (;;) {
			asm lodsb;              /* al <- ds:[si++]; get next byte */
			asm mov dl, al;         /* Save color code */

			asm rol al, 1;          /* Get counter */
                        asm rol al, 1;          /* = shr al, 6 */
                        asm and ax, 3;          /* ah = 0, al &= 3 */
			asm jne short OKCounter;
				asm lodsb;      /* Long counter */
				if (_AL == 0) { /* End of this scanline */
#if 0
					if (_DL == 0)   /* Next scan line */
						break;

					asm mov ax, ds;
					if (_DL == 1) { /* Next colormap */
                                                asm add ax, 4; /* Shift to next colormap */
                                                asm sub si, 0x40; /* Shift to 4 paragraphs size */
					}
					if (_DL == 2) { /* Previous colormap */
                                                asm sub ax, 4; /* Shift to next colormap */
                                                asm add si, 0x40; /* Shift to 4 paragraphs size */
					}
					asm mov ds, ax;
#endif
					break;
				}
OKCounter:
			asm not bh;             /* Starting Mask */

			/* Add previous offset. Now it contains length
			 * counted from the left edge of 4-pixels group.
			 * (AH already zero).
			 */
			asm add ax, bp;         /* Add previous offset */
			asm mov cx, ax;         /* Save length */
			asm and ax, 3;          /* Get plane mask index */
			asm shr cx, 1;          /* Divide by 4 */
			asm shr cx, 1;

			if (_DL == 0) {         /* Zero color code -> skipping */
				asm mov bp, ax; /* Save mask */
				asm add di, cx; /* Advance the index */
				asm mov bh, byte ptr cs:rmsk[bp];/* Get start mask */
				continue;
			}
Drawing:
			/* Color map table must reside at segment:0.
			 */
                        asm and dx, 0x3F;               /* Mask off color code */
			asm mov bp, dx;                 /* Put color index into bp */
                        asm mov dl, byte ptr ds:[bp];   /* Map color code */

			asm mov bp, ax;                 /* Now save offset */
                        asm mov bl, byte ptr cs:rmsk[bp];/* Get end mask */
			asm mov ah, dl;                 /* Put mapped color */
                        asm mov dx, VGA_SER_GATE;

			asm dec cx;                     /* ...altering flags */
			asm jg  short Cont;             /* If cx > 0 - cx groups */
			asm je  short Next;             /* If cx == 0 - Next group */

Piece:                  /* Just a piece of 4-group */
				asm mov al, bl;         /* End mask */
				asm and al, bh;         /* Compute mask */
				asm out dx, al;         /* Set mask */
				asm mov byte ptr es:[di], ah;/* Write the color */
				asm mov bh, bl;         /* New mask */
				continue;
			{
Next:
			/* Starting piece */
			asm mov al, bh;              /* Starting mask */
			asm out dx, al;              /* Set Mask */
			asm mov byte ptr es:[di], ah;/* Write the color */
			asm inc di;                  /* Advance the address */
			/* Ending piece */
			asm mov al, bl;         /* End mask */
			asm out dx, al;         /* Set Mask */
                        asm mov byte ptr es:[di], ah;/* Write the color */
                        asm mov bh, bl;         /* New mask */
			continue;

Cont:                   /* Number of entire 4-groups */
			/* Starting piece */
			asm mov al, bh;              /* Starting mask */
                        asm out dx, al;              /* Set Mask */
			asm mov byte ptr es:[di], ah;/* Write the color */
			asm inc di;                  /* Advance the address */
                        asm mov al, 0xF;             /* All planes   */
                        asm out dx, al;              /* Set Mask     */
			asm mov al, ah;              /* Fill value   */
			asm rep stosb;               /* Write colors */
			/* Ending piece */
			asm mov al, bl;              /* End mask */
			asm out dx, al;              /* Set Mask */
			asm mov byte ptr es:[di], ah;/* Write the color */
			asm mov bh, bl;              /* New mask */
			continue;
			}
		}
		asm pop di;
		asm pop bp;                             /* Initial starting offset */
		asm pop cx;                             /* 稪 横 */
		asm add di, BPERROW;
	asm dec cx;
	asm jcxz short Exit;
	asm jmp near Loop;
Exit:
	asm pop ds;
	asm pop bp;
	return;
}