//ASM.CPP
// part of JDHEAP class by John M. Dlugosz
// This is posted for academic pursuits, and may
// be used freely, with attribution.

#include "usual.h"
#include "jdheap.h"

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

#if defined __WATCOMC__

extern void* do_normalize (void*);
#pragma aux do_normalize= \
   "mov BX,AX" \
   "shr AX,4"  \
   "add DX,AX" \
   "mov AX,BX" \
   "and AX,15" \
   modify [BX] \
   value [DX AX] \
   parm [DX AX]

void* jdheap::normalize (void* p)
{
return do_normalize(p);
}

#elif defined __BORLANDC__

void* jdheap::normalize (void* p)
{
#error  not coded yet!
// put inline asm here for Borland C++ compiler
}

#else
 #error need code for jdheap::normalize()
#endif

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

#if defined __WATCOMC__

ulong jdheap::to_linear (void* p)
{
extern ulong temp1 (void*);
#pragma aux temp1= \
   "mov BX,DX" \
   "shr DX,12" \
   "shl BX,4"  \
   "add AX,BX" \
   "adc DX,0"  \
   modify [BX] \
   value [DX AX] \
   parm [DX AX]
return temp1 (p);
}

#elif defined __BORLANDC__

void* jdheap::to_linear (void* p)
{
#error  not coded yet!
// put inline asm here for Borland C++ compiler
}

#else
 #error need code for jdheap::to_linear()
#endif

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */

#if defined __WATCOMC__

void* jdheap::from_linear (ulong x)
{
extern void* temp2 (ulong);
#pragma aux temp2= \
   "mov BX,AX" \
   "shl DX,12" \
   "shr BX,4"  \
   "add DX,BX" \
   "and AX,15" \
   modify [BX] \
   value [DX AX] \
   parm [DX AX]
return temp2 (x);
}

#elif defined __BORLANDC__

void* jdheap::from_linear (void* p)
{
#error  not coded yet!
// put inline asm here for Borland C++ compiler
}

#else
 #error need code for jdheap::from_linear()
#endif

/* /\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\ */
