//DUMP.CPP
// part of JDHEAP class by John M. Dlugosz
// This is posted for academic pursuits, and may
// be used freely, with attribution.


// this shows the contents of the heap, and also does a consistancy check
// at the same time, and marks each entry with an OK or suitable error message.

#include "usual.h"
#include "jdheap.h"
#include <stdio.h>

//class notes:  note that this is a non-member function.

static const char* check (jdheap::record* list, int x, ulong Start, ulong End)
{
int mode= 0;  //interior
jdheap::record& r= list[x];
if (r.prev == -1)  {
   // set undefined fields to canonocal form, for readability
   r.pointer= 0;
   r.size= 0;
   return "unused";
   }
if (r.pointer == Start)  mode= 2;
ulong target= r.pointer + r.size;
if (r.pointer < Start || target > End)  return "pointer error";
jdheap::record* r2= list+r.next;
if (target == End)  mode= 1;
else if (target != r2->pointer)  return "region error";
if (r2->prev != x)  return "forward pointer mismatch";
r2= list+r.prev;
if (r2->next != x)  return "back pointer mismatch";
// ... other tests here as they are devised
static const char* strings[3]= { "OK", "OK (last node)", "OK (first node)" };
return strings[mode];
}

void jdheap::debug_dump() const
{
printf ("free list at %d, rover at %d\n", freehead, rover);
for (int loop= 0;  loop < capacity;  loop++) {
   jdheap::record& r= list[loop];
   if (r.prev == -1)  continue;  //don't display unused nodes
   const char* markstr= r.mark_string;
   if (!markstr) markstr= "";
   const char* s= check (list, loop, Start, End);
   char mark= '+';  //memory allocated
   if (r.prev == -1)  mark= ' ';  //unused
   else if (r.isfree())  mark= '-';  //memory free
   printf ("%3d: %05lx %c %6ld %5u   %3d %3d  %-17s %s\n",
      loop, r.pointer, mark, r.size, r.counter, r.next, r.prev, s, markstr );
   }
fflush (stdout);
}

