;heapasm.asm
;utility for jdheap


        .model  large, c
        .286
        %pagesize 120,132
        .code

        public seek_for_fit

memrec  struc
  rec_ptr  dd   ?       ;linear address of memory block
  rec_size dd   ?
  rec_markstr dd ?
  rec_counter dw ?
  rec_next dw   ?
  rec_prev dw   ?
ends


seek_for_fit    proc

        arg     list:far ptr memrec, listsize:word, x:word, bsize:dword
        uses    ds, si, di

        mov     cx, [listsize]          ; CX = listsize
        jcxz    L3                      ; abort if listsize is 0
        lds     bx, [list]              ; DS:BX -> list
        mov     si, [x]                 ; SI = x
        mov     dx, word ptr [bsize+2]  ; DX:AX = bsize
        mov     ax, word ptr [bsize]    ; BP,DI = scratch

       ; for (;listsize--;x=p->next) {
       ; p= list+x
L1:     mov     di, si
        shl     di, 4
        add     di, si
        add     di, si

       ; if (p->counter != 0)  continue;
        test    [(bx+di).rec_counter], 0ffffh
        jnz     L2

       ; if (p->size >= bsize)  return x;  //found one!
        cmp     word ptr [(bx+di).rec_size+2], dx
        ja      L4
        jb      L2
        cmp     word ptr [(bx+di).rec_size], ax
        jb      L2
L4:     mov     ax, si                  ;return x in AX
exit:   ret

L2:    ; end of for loop
        mov     si, [(bx+di).rec_next]    ; x= p->next
        loop    L1                      ; loop until count == 0

L3:     mov     ax, -1                  ; return -1 in AX on failure
        jmp     exit

seek_for_fit    endp

        end
