/* 
WHTITLES.C -- dump titles from Windows .HLP or .MVB file
Pete Davis and Andrew Schulman, September 1993
From Dr. Dobb's Journal, October 1993

bcc -DDO_TITLES whtitles.c helpdir.c
*/

#pragma pack(1)
#include <conio.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "whstruct.h"

extern void fail(const char *s);

#define GET_STRING(f, s) { char *p = (s); while (*p++ = fgetc(f)) ; *p = 0; }

#define PAGE_SIZE       1024L        /* 1k pages for WHIFS B-Tree */
#define TTLPAGE_SIZE    2048L        /* 2k pages for TTLBTREE     */

int GetFirstLeaf(FILE *HelpFile, long FirstPageLoc, int LeafLevel) {
   int              CurrLevel = 1, NextPage = 0;
   BTREEINDEXHEADER CurrNode;

   while (CurrLevel < LeafLevel) {
     fread(&CurrNode, 4, 1, HelpFile);
     fread(&NextPage, sizeof(int), 1, HelpFile);
     GotoPage(NextPage);
     CurrLevel++;
   }
   return NextPage;
}

long find_whifs_file(FILE *HelpFile, long WHIFSStart, char *name)
{
   BTREENODEHEADER	WHIFSNode;
   long FileOffset;
   char filename[20];
   int file;
   
   do {
       fread(&WHIFSNode, sizeof(WHIFSNode), 1, HelpFile);
    
       /* Search all entries in node */
       for (file = 1; file <= WHIFSNode.NEntries; file ++) {
		  GET_STRING(HelpFile, filename);
          fread(&FileOffset, sizeof(FileOffset), 1, HelpFile);
		  if (strcmp(filename, name) == 0)
			  return FileOffset;
       }
       if (WHIFSNode.NextPage != -1)
          fseek(HelpFile, WHIFSStart + (WHIFSNode.NextPage * PAGE_SIZE), 
			  SEEK_SET);
   } while (WHIFSNode.NextPage != -1);
   return 0L;	// can't find
}

void do_titles(FILE *HelpFile, long WHIFSStart)
{
   BTREEHEADER		BTreeHdr;
   BTREENODEHEADER  CurrNode;
   FILEHEADER		FileHdr;
   long				FirstPageLoc, CurrPage;
   unsigned long	TopicOffset;
   long				TTLBTreeOffset=0, FileStart;
   char				Title[80], *data;
   int				file, txt, count, *Offsets;

   if (! (TTLBTreeOffset=find_whifs_file(HelpFile, WHIFSStart, "|TTLBTREE")))
	   fail("Can't locate |TTLBTREE file");
	
   /* Get TTLBTREE header */
   fseek(HelpFile, TTLBTreeOffset, SEEK_SET);
   fread(&FileHdr, sizeof(FileHdr), 1, HelpFile);
   fread(&BTreeHdr, sizeof(BTreeHdr), 1, HelpFile);
   FirstPageLoc = ftell(HelpFile);
   GotoPage(BTreeHdr.RootPage);

   printf("%lu titles in |TTLBTREE:\n\n", BTreeHdr.TotalBtreeEntries);
   CurrPage = GetFirstLeaf(HelpFile, FirstPageLoc, BTreeHdr.NLevels);
   
   do {
     GotoPage(CurrPage);
     fread(&CurrNode, 8, 1, HelpFile);
     for(count = 1; count <= CurrNode.NEntries; count++) {
        fread(&TopicOffset, sizeof(TopicOffset), 1, HelpFile);
  	    GET_STRING(HelpFile, Title);
        if (*Title) 
		{
			printf("0x%05lX/0x%04X\t%s\n",
				TopicOffset >> 15L,		// block number = upper 17 bits
				(unsigned short) TopicOffset & 0x8FFF,	// char offset
				Title);
		}
     }
     CurrPage = CurrNode.NextPage;
   } while(CurrPage != -1);
}


