#ifndef ENVIRON_H
#define ENVIRON_H



/*------------------------------------------------------------------------------
   Copyright           : (c)1994 by Logical Operators
                         All Rights Reserved.
   Filename            : Environ.H
   Header File         : Environ.H
   Purpose             : Header file which provides the environment-specific
                         definitions needed to compile Logical Operators' class
                         libraries. This file should be altered if the "root"
                         base class of the programming environment's is renamed
                         or if unique #defines are needed to compile the class
                         library for a particular platform.
   Compiler Directives : None

   Modifications       :
   Version   Date    Programmer and Description of Changes
   ------- --------  --------------------------------------------------------
    1.00   01/25/94  Original version by Warren J. Hairston.
   ---------------------------------------------------------------------------*/



   //Programmer-required defines
   //---------------------------
   /* Define the compilation environment and class library to be used. Defining
      one of the valid entries may cause others to be automatically defined by
      this header file. Valid entries:
         BORLAND_CONTAIN = Borland Container Classes
         BORLAND_OWL     = Borland ObjectWindows Library
         BORLAND_TV      = Borland Turbo Vision
         NOROOT          = No Root Class */
   //-------------------------------------------------------------------------
   #define NOROOT

   /* Define the target executable. Defining one of the valid entries may cause
      others to be automatically defined by this header file. Not all valid
      entries here are compatible with all entries for the compilation
      environment (for example:  BORLAND_OWL is NOT compatible with TARGET_DOS).
      Valid entries:
         TARGET_DOS     = MS-DOS .EXE or .COM
         TARGET_WINDOWS = MS-Windows .EXE or .DLL */
   //--------------------------------------------------------------------------
   #define TARGET_DOS



   //--------------------------------------------------------------------------
   // PROGRAMMERS:  DON'T CHANGE ANYTHING BELOW THIS COMMENT!
   //--------------------------------------------------------------------------



   //other required #defines
   //-----------------------
   #define ALERTDRIVER_VERSION 0x0100   //AlertDriver Class Library version



   /* Macros invoked for the compiler used to compile this library. Each
      compiler (or compilation environment) should define the following:
         1. #include any compiler-specific (non-ANSI) header files needed to
            access the functions defined in the following steps.
         2. #define macro GETCHE as the name of the function used to return a
            single character from the keyboard. This function should preferably
            return the character immediately after it is pressed and should
            echo the character to the screen. This function is invoked when
            processing certain user prompts. The function should accept no
            parameters (void) and return an int. If your compiler does not
            provide such a function, you may use the standard C function which
	    reads from stdin but buffers input (requires an ENTER keypress
	    before returning). */
   //---------------------------------------------------------------------------
   #ifndef TARGET_WINDOWS
      #ifdef __BCPLUSPLUS__   //using a Borland C++ compiler
         #include <conio.h>   //for getche() function prototype
         #define GETCHE getche()   //gets single character w/echo from console
      #elif (defined _MSC_VER)   //using a Microsoft C compiler
         #if (_MSC_VER >= 700)   //using Microsoft C/C++ v7.00 or later
	    #include <conio.h>   //for getche() function prototype
	    #define GETCHE getche()   //gets single char w/echo from console
         #endif   //_MSC_VER >= 700
      #endif   //__BCPLUSPLUS__
   #endif   //!TARGET_WINDOWS

   #ifndef GETCHE   //if GETCHE not previously defined
      #include <stdio.h>   //for getchar() function prototype
      #define GETCHE getchar()   //gets single character from stdin
   #endif   //!GETCHE



   /* Macros invoked for compilation environment. Each compilation environment
      should define the following:
         1. Optionally #define any macros needed by compilation-environment
            specific libraries and/or #include files.
         2. Optionally #include all necessary header files for the compilation
            environment, including the file which declares the base class for
            the intended class hierarchy.
         3. Optionally #define macro ROOTCLASS as the name of the class which
            will be the root class for the intended class hierarchy. ROOTCLASS
            should be able to be instantiated without parameters. If ROOTCLASS
            is defined, then classes ReferenceCounter and AlertableObject will
            be derived directly from ROOTCLASS; otherwise, those classes will
            not have parent classes.
         4. #define macro DEFAULT_ALERTDRIVER as the name of the specific
            AlertDriver class to be instantiated as the default AlertDriver for
            each object in the target environment. */
   //---------------------------------------------------------------------------
   #ifdef BORLAND_OWL   //compile for Borland's ObjectWindows Library
      #ifndef TARGET_WINDOWS
         #error "environ.h - Target Windows when compiling for OWL."
      #endif   //TARGET_WINDOWS

      #define BORLAND_CONTAIN   //OWL uses Container Class's Object as root
      #include <bwcc.h>   //Borland Windows Custom Controls header
   #endif   //BORLAND_OWL

   #ifdef BORLAND_CONTAIN   //compile for Borland's Container Classes
      #include <object.h>

      #define ROOTCLASS Object
      #ifdef TARGET_WINDOWS
         #define DEFAULT_ALERTDRIVER WindowsAlertDriver()
      #else
         #define DEFAULT_ALERTDRIVER StdAlertDriver()
      #endif   //TARGET_WINDOWS
   #endif   //BORLAND_CONTAIN

   #ifdef BORLAND_OWL
      //change the default AlertDriver for OWL programs
      #undef DEFAULT_ALERTDRIVER
      #define DEFAULT_ALERTDRIVER BWCCAlertDriver()
   #endif   //BORLAND_OWL

   #ifdef NOROOT   //compile w/o a common root class
      #ifdef TARGET_WINDOWS
         #define DEFAULT_ALERTDRIVER WindowsAlertDriver()
      #else
         #define DEFAULT_ALERTDRIVER StdAlertDriver()
      #endif   //TARGET_WINDOWS
   #endif   //NOROOT

   #ifdef BORLAND_TV   //compile for Borland's Turbo Vision
      #ifndef TARGET_DOS
         #error "environ.h - Target DOS when compiling for Turbo Vision."
      #endif   //TARGET_DOS

      #define Uses_MsgBox
      #define Uses_TButton
      #define Uses_TDeskTop
      #define Uses_TDialog
      #define Uses_TProgram
      #define Uses_TScreen
      #define Uses_TStaticText
      #include <tv.h>

      #define ROOTCLASS TObject
      #define DEFAULT_ALERTDRIVER TurboVisionAlertDriver()
   #endif   //BORLAND_TV



   //Ensure that all required compilation environment macros were defined
   //--------------------------------------------------------------------
   #ifndef DEFAULT_ALERTDRIVER
      #error "environ.h - DEFAULT_ALERTDRIVER not defined."
   #endif   //DEFAULT_ALERTDRIVER



   /* Macros invoked for target environment. Each target environment should
      define the following:
         1. Optionally #define any macros needed by target-environment specific
            libraries and/or #include files.
         2. Optionally #include all necessary header files for compilation of
            the AlertDriver Class Library for the target environment.
         3. #define macro ESC_CODE as the keycode representation of the ESC key
            in the target environment. This keycode is examined to determine if
            the user presses the ESC (or equivalent) key when responding to
            certain prompts.
         4. #define macro MAXTEXTSIZE as the length of the largest text string
            to be output as an error, info, message, or warning alert. This size
            should include the terminating zero-byte.
         5. #define macro MAXTIMESTAMP as the length of the largest text string
            to be used to hold the text representation of the current timestamp
            returned by AlertDriver::GetTimeStamp(). This length should include
            the terminating zero-byte. */
   //---------------------------------------------------------------------------
   #ifdef TARGET_WINDOWS   //target MS-Windows .EXE or .DLL files
      #define TARGET_DOS   //Windows compilation has same requirements as DOS
      #include <adwindll.h>   //AlertDriver for Windows DLL Header
   #endif   //TARGET_WINDOWS

   #ifdef TARGET_DOS   //target MS-DOS .EXE or .COM files
      #define ESC_CODE 27
      #define MAXTEXTSIZE 256
      #define MAXTIMESTAMP 50
   #endif   //TARGET_DOS



   //Ensure that all required target environment macros were defined
   //---------------------------------------------------------------
   #ifndef ESC_CODE
      #error "environ.h - ESC_CODE not defined."
   #endif   //ESC_CODE

   #ifndef MAXTEXTSIZE
      #error "environ.h - MAXTEXTSIZE not defined."
   #endif   //MAXTEXTSIZE

   #ifndef MAXTIMESTAMP
      #error "environ.h - MAXTIMESTAMP not defined."
   #endif   //MAXTIMESTAMP



#endif //ENVIRON_H
