/*  Project filesrch

	 Copyright  1993. All Rights Reserved.

	 SUBSYSTEM:    filesrch.exe Application
	 FILE:         flsmdicc.cpp
	 AUTHOR:       Earl Bennett


	 OVERVIEW
	 ========
	 Source file for implementation of filesrchMDIChildClient (TWindow).
*/

#include <owl\owlpch.h>
#include <owl\scroller.h>
#pragma hdrstop

#include "flsmdicc.h"

static int tabs[] = {8};

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(filesrchMDIChildClient, TWindow)
//{{filesrchMDIChildClientRSP_TBL_BEGIN}}
	 EV_WM_SIZE,
//{{filesrchMDIChildClientRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{filesrchMDIChildClient Implementation}}


filesrchMDIChildClient::filesrchMDIChildClient (TWindow* parent, TLines *lines,
	const char far* title, TModule* module):
	 TWindow(parent, title, module)
{
	 // Override the default window style for TWindow.
	 Attr.Style |= WS_CHILD | WS_HSCROLL | WS_VISIBLE | WS_VSCROLL;

	 // INSERT>> Your constructor code here.

	myLines = lines;
	Scroller = new TScroller (this, 1, 1, 100, 100);
}


filesrchMDIChildClient::~filesrchMDIChildClient ()
{
	 Destroy();

	 // INSERT>> Your destructor code here.

	if (myLines != NULL)
		delete myLines;
}


void filesrchMDIChildClient::Paint (TDC& dc, BOOL, TRect&)
{
	TEXTMETRIC	tm;

	//	Get the text metrics and set up some initial parameters

	dc.GetTextMetrics (tm);
	dc.SetTextAlign (TA_TOP);
	int y = 0;

	//	Print out each string in myLines

	for (int i = 0; i < myLines->GetItemsInContainer(); i++)
	{
		const char _FAR *tmp = (*myLines)[i].c_str();
		dc.TabbedTextOut (TPoint(0, y), tmp, strlen(tmp), 1, tabs, 0);

		//	Now determine the Y coordinate for the next word

		y += tm.tmHeight + tm.tmExternalLeading;
	}
}


void filesrchMDIChildClient::EvSize (UINT sizeType, TSize& size)
{
	TEXTMETRIC		tm;
	TSize				sz;

	if (sizeType != SIZE_MINIMIZED) {

		//	 Get a DC for the window so that we can establish
		//	text metrics

		TClientDC	dc(HWindow);
		dc.GetTextMetrics (tm);

		//	Determine the range for the Y scroll bar by determining
		//	the number of lines which can be displayed in the current
		// client area. If all lines can be displayed, then range
		// can be set to 0.

		int lineCount = myLines->GetItemsInContainer();
		long ySize = size.cy / tm.tmHeight;
		ySize = (ySize > lineCount) ? 0l : lineCount - ySize;

		//	Determine the range for the X scroll bar by finding the longest
		//	line and calculating the width of the longest line. If the longest
		// line can fit into the current window, then the Xrange will be set
		// to 0

		int maxLen = 0;
		for (int index = 0; index < lineCount; index++)
		{
			dc.GetTabbedTextExtent ((*myLines)[index].c_str(),
				(int) (*myLines)[index].length(), 1, tabs, sz);
			maxLen = max(maxLen, sz.cx+10);
		}
		long xSize = (size.cx > (long) maxLen) ? 0l : (long) (maxLen - size.cx);

		//	Set the scroll bar range and units

		Scroller->SetRange (xSize, ySize);
		Scroller->SetUnits (1, tm.tmHeight);
	}
}

