/*  Project filesrch

	 Copyright  1993. All Rights Reserved.

	 SUBSYSTEM:    filesrch.exe Application
	 FILE:         flsrchap.cpp
	 AUTHOR:       Earl Bennett


	 OVERVIEW
	 ========
	 Source file for implementation of filesrchApp (TApplication).
*/


#include <owl\owlpch.h>
#include <owl\checkbox.h>
#include <owl\edit.h>
#include <dir.h>
#include <direct.h>
#pragma hdrstop


#include "flsrchap.h"
#include "flsrmdic.h"
#include "flsrchad.h"      // Definition of about dialog.
#include "setfilnm.h"		// Definition of SetFileName dialog
#include "stprfrnc.h"		// Definition of Set Preferences dialog
#include "flsdmdif.h"		// Definition of MDI frame class

//
// Generated help file.
//
const char HelpFileName[] = "filesrch.hlp";

//{{filesrchApp Implementation}}

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(filesrchApp, TApplication)
//{{filesrchAppRSP_TBL_BEGIN}}
	 EV_COMMAND(CM_HELPCONTENTS, CmHelpContents),
	 EV_COMMAND(CM_HELPUSING, CmHelpUsing),
	 EV_COMMAND(CM_HELPABOUT, CmHelpAbout),
	 EV_COMMAND(CM_PREFER, CmSetPreferences),
	 EV_COMMAND(CM_EDITFIND, CmEditFind),
	 EV_COMMAND(CM_MDIFILENEW, CmMDIFileNew),
	 EV_COMMAND(CM_EDITFINDNEXT, CmEditFindNext),
//{{filesrchAppRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// filesrchApp
// =====
//
filesrchApp::filesrchApp (char *moduleName) : TApplication(moduleName)
{
	 HelpState = FALSE;
	 ContextHelp = FALSE;
	 HelpCursor = 0;
	 getSearchString = FALSE;
	 fileName[0] = '\0';

	 // INSERT>> Your constructor code here.

	 // Common file file flags and filters for Open/Save As dialogs.  Filename and directory are
	 // computed in the member functions CmFileOpen, and CmFileSaveAs.
	 FileData.Flags = OFN_NOVALIDATE | OFN_NOTESTFILECREATE | OFN_HIDEREADONLY
			| OFN_OVERWRITEPROMPT | OFN_PATHMUSTEXIST;
	 FileData.SetFilter("All Files (*.*)|*.*|"
							  "Text Files (*.TXT)|*.txt|"
							  "List Files (*.LST)|*.lst|"
							  "INI Files (*.INI)|*.ini|"
							  "C Header Files (*.H)|*.h|"
							  "C++ Header Files (*.HPP)|*.hpp|"
							  "C Source Files (*.C)|*.c|"
							  "C++ Source Files (*.CPP)|*.cpp|");
}


filesrchApp::~filesrchApp ()
{
	 // INSERT>> Your destructor code here.

}


BOOL filesrchApp::CanClose ()
{
	 BOOL result = TApplication::CanClose();

	 //
	 // Close the help engine if we used it.
	 //
	 if (result && HelpState)
		  MainWindow->WinHelp(HelpFileName, HELP_QUIT, 0L);

	 return result;
}


//////////////////////////////////////////////////////////
// filesrchApp
// =====
// Application intialization.
//
void filesrchApp::InitMainWindow ()
{
	 TDecoratedMDIFrame* frame =
		(TDecoratedMDIFrame *) new filesrchDecoratedMDIFrame(Name, MDI_MENU,
		*(new filesrchMDIClient), TRUE);

	 nCmdShow = (nCmdShow != SW_SHOWMINNOACTIVE) ? SW_SHOWNORMAL : nCmdShow;

	 //
	 // Menu associated with window and accelerator table associated with table.
	 //
	 frame->AssignMenu(MDI_MENU);

	 //
	 // Associate with the accelerator table.
	 //
	 frame->Attr.AccelTable = MDI_MENU;

	//	Set up the status bar

	 sb = new TStatusBar(frame, TGadget::Recessed);
	 TTextGadget *tx = new TTextGadget (1, TGadget::Recessed,
			TTextGadget::Left, 20);
	 sb->Insert (*tx);
	 tx = new TTextGadget (2, TGadget::Recessed, TTextGadget::Left, 6);
	 sb->Insert (*tx);
	 tx = new TTextGadget (3, TGadget::Recessed, TTextGadget::Left, 10);
	 sb->Insert (*tx);
	 sb->SetHintMode (TGadgetWindow::EnterHints);
	 frame->Insert(*sb, TDecoratedFrame::Bottom);

	 MainWindow = frame;

	 //
	 // Borland Windows custom controls.
	 //
	 EnableBWCC();
}


//////////////////////////////////////////////////////////
// filesrchApp
// =====
// Menu Help Contents command
void filesrchApp::CmHelpContents ()
{
	 //
	 // Show the help table of contents.
	 //
	 HelpState = MainWindow->WinHelp(HelpFileName, HELP_CONTENTS, 0L);
}


//////////////////////////////////////////////////////////
// filesrchApp
// =====
// Menu Help Using Help command
void filesrchApp::CmHelpUsing ()
{
	 //
	 // Display the contents of the Windows help file.
	 //
	 HelpState = MainWindow->WinHelp(HelpFileName, HELP_HELPONHELP, 0L);
}


//////////////////////////////////////////////////////////
// filesrchApp
// ===========
// Menu Help About filesrch.exe command
void filesrchApp::CmHelpAbout ()
{
	 //
	 // Show the modal dialog.
	 //
	filesrchAboutDlg(MainWindow).Execute();
}

BOOL filesrchApp::ProcessAppMsg (MSG& msg)
{
	 if (msg.message == WM_COMMAND) {
		  if (ContextHelp || (GetKeyState(VK_F1) < 0)) {
				ContextHelp = FALSE;
				MainWindow->WinHelp(HelpFileName, HELP_CONTEXT, msg.wParam);
				return TRUE;
		  }
	 } else
		  switch (msg.message) {
		  case WM_KEYDOWN:
				if (msg.wParam == VK_F1) {
					 // If the Shift/F1 then set the help cursor and turn on the
					 // modal help state.
					 if (::GetKeyState(VK_SHIFT) < 0) {
						  ContextHelp = TRUE;
						  HelpCursor = ::LoadCursor(
								MainWindow->GetModule()->GetInstance(),
								MAKEINTRESOURCE(IDC_HELPCURSOR));
						  ::SetCursor(HelpCursor);
						  return TRUE;        // Gobble up the message.
					 } else {
						  // If F1 w/o the Shift key then bring up help's main index.
						  MainWindow->WinHelp(HelpFileName, HELP_INDEX, 0L);
						  return TRUE;        // Gobble up the message.
					 }
				} else {
					 if (ContextHelp && (msg.wParam == VK_ESCAPE)) {
						  if (HelpCursor)
								::DestroyCursor(HelpCursor);
						  ContextHelp = FALSE;
						  HelpCursor = 0;
						  MainWindow->SetCursor(0, IDC_ARROW);
						  return TRUE;    // Gobble up the message.
					 }
				}
				break;

		  case WM_MOUSEMOVE:
		  case WM_NCMOUSEMOVE:
				if (ContextHelp) {
					 ::SetCursor(HelpCursor);
					 return TRUE;        // Gobble up the message.
				}
				break;

		  case WM_INITMENU:
				if (ContextHelp) {
					 ::SetCursor(HelpCursor);
					 return TRUE;        // Gobble up the message.
				}
				break;

		  case WM_ENTERIDLE:
				if (msg.wParam == MSGF_MENU)
					 if (GetKeyState(VK_F1) < 0) {
					 ContextHelp = TRUE;
					 MainWindow->PostMessage(WM_KEYDOWN, VK_RETURN, 0L);
					 return TRUE;       // Gobble up the message.
				}
				break;

		  default:
				;
		  };  // End of switch

	 // Continue normal processing.
	 return TApplication::ProcessAppMsg(msg);
}


int OwlMain (int , char* argv[])
{
	char *ptr = strrchr (argv[0], '\\') + 1;
	 filesrchApp     App (ptr);
	 int             result;

	 result = App.Run();

	 return result;
}

//	Define routine to determine INI file name

char *filesrchApp::BuildINIFileName(void)
{
	static char ININame[80];

	//	Get our module name, and build INI file name from it

	GetModuleFileName(ININame, sizeof(ININame));
	char *ptr = strstr(ININame, ".EXE");
	strncpy (ptr, ".INI", 4);
	ptr = strrchr (ININame, '\\');
	return (ptr == 0) ? ININame : ptr+1;
}

//	Define the InitInstance routine - Reads parameters from INI
//	file and checks the command line for parameters

void filesrchApp::InitInstance ()
{
	char		*ININame = BuildINIFileName();

	//	First, try to read our private profile strings to get
	//	previously saved file name, case sensitivity, and regular
	//	expression flag

	GetPrivateProfileString ("FileSrch", "FileName", "", fileName,
			sizeof(fileName), ININame);
	ignoreCase = (BOOL) GetPrivateProfileInt ("FileSrch", "Case", 0, ININame);
	regularExpressions = (BOOL) GetPrivateProfileInt ("FileSrch", "RegExp", 0,
			ININame);
	iconIndex = GetPrivateProfileInt ("FileSrch", "Icon", 0, ININame);

	//	Now scan the command line, to determine if filename entered

	char *token = strtok (lpCmdLine, " ");
	if (token != NULL)

		//	Get filename

		strcpy (fileName, token);

	//	Load the busy cursor

	busyCursor = ::LoadCursor (NULL, IDC_WAIT);
	TApplication::InitInstance();

	//	Initialize the awk library

	awk_init();
}

//  Define routine to handle the Set Preferences command

void filesrchApp::writeToINI ()
{
	char	buf[10];
	char  *INIFile = BuildINIFileName();
	WritePrivateProfileString ("FileSrch", "FileName", fileName, INIFile);
	WritePrivateProfileString ("FileSrch", "Case", itoa((int)ignoreCase, buf,
		10), INIFile);
	WritePrivateProfileString ("FileSrch", "RegExp",
		itoa((int)regularExpressions, buf, 10), INIFile);
	WritePrivateProfileString ("FileSrch", "Icon",
		itoa(iconIndex, buf, 10), INIFile);
}

void filesrchApp::CmSetPreferences ()
{
	char	szFile[80] = {0};
	char	tmpFile[80];
	char	moduleName[80];
	char	drive[_MAX_DRIVE];
	char	dir[_MAX_DIR];
	char	name[_MAX_FNAME];
	char	ext[_MAX_EXT];
	SetPrefTransferBuf	tb;

	if (strlen(fileName) != 0)
	{

		//	Get the current file name, and break it into its constituent parts

		lstrcpy (szFile, fileName);
		_splitpath (szFile, drive, dir, name, ext);

		//	Put things back together for OpenFileName

		strcpy(szFile, name);
		strcat(szFile, ext);
		strcpy (tmpFile, drive);
		strcat (tmpFile, dir);
		tmpFile[strlen(tmpFile)-1] = '\0';

		strcpy (FileData.FileName, szFile);
		FileData.InitialDir = tmpFile;
	}
	else
	{
		// No file name has been entered yet

		FileData.FileName[0] = '\0';
		FileData.InitialDir = NULL;
	}

	//	Set up transfer buffer to indicate the initial state of the ignore case and
	//	regular expression check boxes

	GetModuleFileName (moduleName, sizeof(moduleName));
	tb.Case = (ignoreCase) ? BF_CHECKED: BF_UNCHECKED;
	tb.RegExp = (regularExpressions) ? BF_CHECKED : BF_UNCHECKED;
	tb.iSelectedIcon = iconIndex;
	tb.szIconSourceFile = moduleName;

	//	Execute the dialog box

	if (SetPreferences(MainWindow, FileData, &tb,
			TResId("PREFERENCES")).Execute() == IDOK)
	{

		//	Construct the new file name, and copy it into the application object
		//	also set the ignore case and regular expression flags as per the
		//	users request

		lstrcpy (tmpFile, getcwd(dir, sizeof(dir)));
		if (tmpFile[strlen(tmpFile)-1] != '\\')
			lstrcat (tmpFile, "\\");
		lstrcat (tmpFile, FileData.FileName);
		strcpy (fileName, tmpFile);
		ignoreCase = (tb.Case == BF_CHECKED) ? TRUE : FALSE;
		regularExpressions = (tb.RegExp == BF_CHECKED) ? TRUE : FALSE;

		//	If the icon index changed, the switch to the new icon

		if (iconIndex != tb.iSelectedIcon)
		{
			iconIndex = tb.iSelectedIcon;
			HICON hIcon = GetIcon ();
			if (hIcon != 0)
			{
				hIcon = (HICON) MainWindow->SetClassWord (GCW_HICON, (UINT) hIcon);
				if (hIcon != 0)
					DestroyIcon (hIcon);
			}
		}

		//	Write the new values to the INI file

		writeToINI();

	}

	//	Update the status bar

	UpdateStatusBar();
}

//	Define routine to udpate the status bar

void filesrchApp::UpdateStatusBar(void)
{
	TTextGadget *tx = (TTextGadget *) sb->GadgetWithId(2);
	tx->SetText(regularExpressions ? "RegExp" : "");
	tx = (TTextGadget *) sb->GadgetWithId(3);
	tx->SetText (ignoreCase ? "" : "Match Case");

	//	 Display the file mask
	tx = (TTextGadget *) sb->GadgetWithId (0);
	tx->SetText (fileName);

	//	Now set up the window caption so that when the program
	// is minimized, it prints what we want

	char ProgName[80];
	GetModuleFileName(ProgName, sizeof(ProgName));
	char *ptr = strrchr (ProgName, '\\');
	ptr = (ptr == 0) ? ProgName : ptr+1;
	char caption[80];
	strcpy (caption, ptr);
	ptr = strrchr (caption, '.');
	if (ptr)
		*ptr = '\0';
	strcat (caption, " - ");
	strcpy (ProgName, fileName);
	ptr = strrchr (ProgName, '\\');
	ptr = (ptr == 0) ? ProgName : ptr+1;
	strcat (caption, ptr);
	MainWindow->SetCaption (caption);
}


void filesrchApp::CmEditFind ()
{
	//	Create the transfer structore for the dialog box

	struct TransferBuffer {
		char	searchString[80];
		UINT	caseFlag;
		UINT	regExp;
	} transferData;

	//	Set up the initial data for the dialog

	transferData.caseFlag = (ignoreCase) ? BF_CHECKED : BF_UNCHECKED;
	transferData.regExp = (regularExpressions) ? BF_CHECKED : BF_UNCHECKED;
	strcpy (transferData.searchString, searchString);

	//	Create the dialog box and required controls, and set the
	//	transfer buffer - We will sit in loop until we get a valid search
	//	string or operator cancels

	 BOOL Search = TRUE;
	 while (TRUE) {
		TDialog *setStringDialog = new TDialog (MainWindow, "SETSTRING");
		if (setStringDialog != NULL) {
			new TEdit (setStringDialog, ID_SEARCHSTRING, 80);
			new TCheckBox (setStringDialog, ID_IGNORE, NULL);
			new TCheckBox (setStringDialog, ID_REGEXP, NULL);
			setStringDialog->SetTransferBuffer(&transferData);

			//	Execute the dialog

			int result = setStringDialog->Execute();

			//	if IDOK entered, copy the search string back to app object
			//	along with case and regular expression flags

			if (result == IDOK) {

				ignoreCase = (transferData.caseFlag == BF_CHECKED) ? TRUE : FALSE;
				regularExpressions = (transferData.regExp == BF_CHECKED) ?
						TRUE : FALSE;

				//	If ignoring case, convert search pattern to upper case

				if (ignoreCase)
					strupr (transferData.searchString);
				strcpy (searchString, transferData.searchString);

				// Update the status bar to reflect new case and regular
				//	expression flags

				UpdateStatusBar();

				//	If using regular expressions, convert search string to
				//	pattern

				if (regularExpressions)
					if (!SetRegExp())
						BWCCMessageBox (MainWindow->HWindow,
								"Error in regular expression",
								"Syntax Error", MB_ICONSTOP | MB_OK);
					else	// Regular expression OK - exit loop and search
							break;
				else		// Not regular expression - exit loop and search
					break;
			}
			else		// IDCANCEL returned
			{
					Search = FALSE;
				break;
				}
		}
		else			// Could not create dialog box
		{
			Search = FALSE;
			break;
		  }
	}

	//	Now force the search

	if (Search)
		MainWindow->PostMessage (WM_COMMAND, CM_EDITFINDNEXT, 0L);

}

//////////////////////////////////////////////////////////
// filesrchApp
// ===========
// Menu Set Filename command
void filesrchApp::CmMDIFileNew ()
{
	char	szFile[80] = {0};
	char	tmpFile[80];
	char	drive[_MAX_DRIVE];
	char	dir[_MAX_DIR];
	char	name[_MAX_FNAME];
	char	ext[_MAX_EXT];

	if (strlen(fileName) != 0)
	{

		//	Get the current file name, and break it into its constituent parts

		lstrcpy (szFile, fileName);
		_splitpath (szFile, drive, dir, name, ext);

		//	Put things back together for OpenFileName

		strcpy(szFile, name);
		strcat(szFile, ext);
		strcpy (tmpFile, drive);
		strcat (tmpFile, dir);
		tmpFile[strlen(tmpFile)-1] = '\0';

		strcpy (FileData.FileName, szFile);
		FileData.InitialDir = tmpFile;
	}
	else
	{
		// No file name has been entered yet

		FileData.FileName[0] = '\0';
		FileData.InitialDir = NULL;
	}

	if (SetFileName(MainWindow, FileData, TResId("SETFILENAME")).Execute() == IDOK)
	{
		lstrcpy (tmpFile, getcwd(dir, sizeof(dir)));
		if (tmpFile[strlen(tmpFile)-1] != '\\')
			lstrcat (tmpFile, "\\");
		lstrcat (tmpFile, FileData.FileName);
		strcpy (fileName, tmpFile);

		//	Make sure the status bar is up to date

		UpdateStatusBar();

		//	Now initiate the search process if needed

		if (getSearchString)
		{
			getSearchString = FALSE;
			MainWindow->HandleMessage (WM_COMMAND, CM_EDITFIND, 0L);
		}
	}
}

//	Define routine to convert search string to regular expression
//	Returns False if an error occurs

BOOL filesrchApp::SetRegExp(void)
{
	return ((BOOL) (makepat(searchString, regExp) != NULL));
}


void filesrchApp::CmEditFindNext ()
{
	char			buf[256], upperbuf[256];
	char			localString[MAXPAT];
	struct ffblk 	fileblock;
	BOOL			firstLine;
	char			drive[_MAX_DRIVE];
	char			dir[_MAX_DIR];
	char			name[_MAX_FNAME];
	char			ext[_MAX_EXT];
	int			lineCount = 0;
	TLines		*lines = NULL;

	//	Switch Cursors

	TTextGadget *tx = (TTextGadget *) sb->GadgetWithId (1);
	tx->SetText("Searching...");
	HCURSOR oldCursor = SetCursor (busyCursor);

	//	Close all currently open MDI child windows

	TMDIFrame *frame = dynamic_cast<TMDIFrame *>(MainWindow);
	frame->GetClientWindow()->CloseChildren();

	//	Get the search string and convert to upper case if case
	//	insensitive search

	if (regularExpressions)
		strcpy (localString, regExp);
	else
		strcpy (localString, searchString);

	//	Get the current file name, and separate into component parts -
	//	Then make sure we are in the right drive/directory

	_splitpath (fileName, drive, dir, name, ext);
	if (lstrlen(drive) != 0)
		_chdrive ((int) (toupper(drive[0]) - 'A') + 1);
	if (lstrlen(dir) != 0)
	{
		dir[lstrlen(dir)-1] = '\0';		// kill trailing slash
		chdir (dir);
	}

	//	Now find all files matching pattern entered in case wild cards used


	BOOL done = (BOOL) findfirst (fileName, &fileblock, 0);
	while (!done) {

		lines = NULL;

		//	Open the next file for the search

		FILE *f = fopen (fileblock.ff_name, "r");
		if (f == NULL)
		{
			wsprintf (buf, "Could not open file %s", fileblock.ff_name);
			int rtn = BWCCMessageBox (MainWindow->HWindow, buf,
					"File Open Error", MB_ICONINFORMATION | MB_OKCANCEL);
			if (rtn == IDCANCEL)
				break;
		}
		else
		{
			//	Read all strings in the file and search for specified search string

			wsprintf (buf, "Searching %s", fileblock.ff_name);
			tx->SetText (buf);
			InvalidateRect (sb->HWindow, NULL, TRUE);
			UpdateWindow (sb->HWindow);
			firstLine = TRUE;
			while (fgets(buf, 256, f) != NULL)
			{
				strcpy (upperbuf, buf);
				if (ignoreCase)
					strupr (upperbuf);

				//	Perform regular expression search if required

				BOOL found;
				if (regularExpressions)
					found = (BOOL) (re_match(upperbuf, localString) != 0);
				else
					found = (BOOL) (strstr(upperbuf, localString) != 0);
				if (found)
				{
					if (firstLine)
					{
						lines = new TLines (10, 0, 5);
						firstLine = FALSE;
					}
					buf[strlen(buf)-1] = '\0';	// strip off trailing new line
					lines->Add(string(buf));
					lineCount++;
				}
			}
			fclose(f);

			//	If we found some lines in this file, create an MDI child
			// window to display them

			if (lines != NULL)
				((filesrchMDIClient *)(frame->GetClientWindow()))->OpenWindow (
						fileblock.ff_name, lines);
		}
		done = (BOOL) findnext (&fileblock);
	}

	//	Restore normal cursor

	SetCursor (oldCursor);
	wsprintf (buf, "%d lines found", lineCount);
	tx->SetText(buf);
}

//	Define routine to get the specified Icon from the file

HICON filesrchApp::GetIcon (void)
{
	char	moduleName[80];

	GetModuleFileName (moduleName, sizeof(moduleName));
	return (ExtractIcon (GetInstance(), moduleName, iconIndex));
}


BOOL filesrchApp::IdleAction (long idleCount)
{
	 BOOL result;
	 static BOOL firstCall = TRUE;

	 result = TApplication::IdleAction(idleCount);

	if (firstCall)
	{
		firstCall = FALSE;

		//	If we do not have a valid filename at this point, force a
		//	read of the filename. Otherwise, bring up the dialog to get
		//	the search string

		if (strlen(fileName) == 0)
		{
			getSearchString = TRUE;
			MainWindow->HandleMessage (WM_COMMAND, CM_MDIFILENEW, 0L);
		} else
			MainWindow->HandleMessage (WM_COMMAND, CM_EDITFIND, 0L);
	}

	 return result;
}

