#if !defined(__flsrchap_h)              // Sentry, use file only if it's not already included.
#define __flsrchap_h

/*  Project filesrch

	 Copyright  1993. All Rights Reserved.

	 SUBSYSTEM:    filesrch.exe Application
	 FILE:         flsrchap.h
	 AUTHOR:       Earl Bennett


	 OVERVIEW
	 ========
	 Class definition for filesrchApp (TApplication).
*/


#include <owl\owlpch.h>
#include <owl\opensave.h>
#include <stdio.h>
#include <bwcc.h>
#include <classlib\arrays.h>
extern "C" {
#include "d:\tools\awklib\awklib.h"
}
#pragma hdrstop

#include <owl\statusba.h>

#include "flsrchap.rh"            // Definition of all resources.

//	Define type for creating arrays used to hold strings found

	typedef TArrayAsVector<string>	TLines;
	
_CLASSDEF(filesrchApp)

//{{TApplication = filesrchApp}}
class filesrchApp : public TApplication {
private:
	BOOL				HelpState;      // Has the help engine been used.
	BOOL				ContextHelp;    // SHIFT-F1 state (context sensitive HELP)
	HCURSOR			HelpCursor;     // Context sensitive help cursor
	BOOL				getSearchString;
	char				fileName[80];
	char				searchString[80];
	char				regExp[MAXPAT];
	BOOL   			ignoreCase;
	BOOL   			regularExpressions;
	int				iconIndex;
	TStatusBar		*sb;
	HCURSOR			busyCursor;
   TOpenSaveDialog::TData FileData;   // Data to control open/saveas standard dialog.

public:
	filesrchApp (char *moduleName);
	virtual ~filesrchApp ();
	BOOL			IgnoreCase(void) { return ignoreCase; }
	BOOL			RegularExpressions(void) { return regularExpressions; }
	BOOL			SetRegExp(void);
	void			SetRegularExpressions(BOOL regexp)
						{ regularExpressions = regexp; }
	void			SetCase(BOOL newCase) { ignoreCase = newCase; }
	char			*FileName (void) { return fileName; }
	char			*SearchString (void) { return searchString; }
	char			*RegExp(void) { return regExp; }
	void			UpdateStatusBar (void);
	HICON			GetIcon (void);

protected:
	char			*BuildINIFileName ();
	void			writeToINI();

//{{filesrchAppVIRTUAL_BEGIN}}
public:
	 virtual void InitMainWindow();
	 virtual BOOL CanClose ();
	 virtual BOOL ProcessAppMsg (MSG& msg);
	 virtual void InitInstance ();
    virtual BOOL IdleAction (long idleCount);
//{{filesrchAppVIRTUAL_END}}
//{{filesrchAppRSP_TBL_BEGIN}}
protected:
	 void CmHelpContents ();
	 void CmHelpUsing ();
	 void CmHelpAbout ();
	 void CmFileSave ();
	 void CmSetPreferences ();
    void CmEditFind ();
    void CmMDIFileNew ();
    void CmEditFindNext ();
//{{filesrchAppRSP_TBL_END}}
DECLARE_RESPONSE_TABLE(filesrchApp);
};    //{{filesrchApp}}


#endif                                      // __flsrchap_h sentry.
