/*  Project filesrch

	 Copyright  1993. All Rights Reserved.

	 SUBSYSTEM:    filesrch.exe Application
	 FILE:         flsrmdic.cpp
	 AUTHOR:       Earl Bennett


	 OVERVIEW
	 ========
	 Source file for implementation of filesrchMDIClient (TMDIClient).
*/


#include <owl\owlpch.h>
#include <bwcc.h>
#pragma hdrstop

#include <dir.h>

#include "flsrchap.h"
#include "flsrmdic.h"
#include "flsrmdi1.h"


//{{filesrchMDIClient Implementation}}


//
// Build a response table for all messages/commands handled
// by filesrchMDIClient derived from TMDIClient.
//
DEFINE_RESPONSE_TABLE1(filesrchMDIClient, TMDIClient)
//{{filesrchMDIClientRSP_TBL_BEGIN}}
//{{filesrchMDIClientRSP_TBL_END}}
END_RESPONSE_TABLE;


//////////////////////////////////////////////////////////
// filesrchMDIClient
// ===========
// Construction/Destruction handling.
 filesrchMDIClient::filesrchMDIClient ()
 : TMDIClient ()
{
	 ChildCount = 0;

	 // INSERT>> Your constructor code here.

}


 filesrchMDIClient::~filesrchMDIClient ()
{
	 Destroy();

	 // INSERT>> Your destructor code here.

}


//////////////////////////////////////////////////////////
// filesrchMDIClient
// ===========
// MDIClient site initialization.
void filesrchMDIClient::SetupWindow ()
{
	// Default SetUpWindow processing.
	TMDIClient::SetupWindow ();

	// Display initial values in the status bar

	((PfilesrchApp) GetApplication())->UpdateStatusBar();
}


void filesrchMDIClient::OpenWindow (const char *fileName, TLines *lines)
{
	 //
	 // Create a MDIChild window whose client is TWindow.
	 //
	 filesrchMDIChild* child = new filesrchMDIChild(*this, fileName, lines, 0);

	 // Associate ICON w/ this child window.
	 child->SetIcon(GetApplication(), IDI_DOC);

	 // If the current active MDI child is maximize then this one should be also.
	 filesrchMDIChild *curChild = (filesrchMDIChild *)GetActiveMDIChild();
	 if (curChild && (curChild->GetWindowLong(GWL_STYLE) & WS_MAXIMIZE))
		  child->Attr.Style |= WS_MAXIMIZE;

	 if (child->Create())
		child->UpdateWindow();
}


