/*  Project filesrch

	 Copyright  1993. All Rights Reserved.

	 SUBSYSTEM:    filesrch.exe Application
	 FILE:         setfilnm.cpp
	 AUTHOR:       Earl Bennett


	 OVERVIEW
	 ========
	 Source file for implementation of SetFileName (TFileOpenDialog).
*/

#include <owl\owlpch.h>
#pragma hdrstop

#include "setfilnm.h"
#include <bwcc.h>

//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(SetFileName, TFileOpenDialog)
//{{SetFileNameRSP_TBL_BEGIN}}
	 EV_WM_CTLCOLOR,
//{{SetFileNameRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{SetFileName Implementation}}


SetFileName::SetFileName (TWindow* parent, TData& data, TResId templateId,
		const char far* title, TModule* module):
	 TFileOpenDialog(parent, data, templateId, title, module)
{
	 // INSERT>> Your constructor code here.

}


SetFileName::~SetFileName ()
{
    Destroy();

    // INSERT>> Your destructor code here.

}


HBRUSH SetFileName::EvCtlColor (HDC hDC, HWND hWndChild, UINT ctlType)
{
	if ((ctlType == CTLCOLOR_LISTBOX) || (ctlType == CTLCOLOR_EDIT))
	{
		SetBkColor (hDC, RGB(255,255,255));
		SetTextColor (hDC, RGB(0,0,0));
		return (HBRUSH) GetStockObject(WHITE_BRUSH);
	} else {
		SetBkColor (hDC, RGB(192, 192, 192));
		SetTextColor (hDC, RGB(0, 0, 0));
		return (HBRUSH) BWCCGetPattern();
	}
}

