/*  Project filesrch

	 Copyright  1993. All Rights Reserved.

	 SUBSYSTEM:    filesrch.exe Application
	 FILE:         stprfrnc.cpp
	 AUTHOR:       Earl Bennett


	 OVERVIEW
	 ========
	 Source file for implementation of SetPreferences (TFileOpenDialog).
*/

#include <owl\owlpch.h>
#include <owl\point.h>
#include <bwcc.h>
#pragma hdrstop

#include "stprfrnc.h"


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(SetPreferences, TFileOpenDialog)
//{{SetPreferencesRSP_TBL_BEGIN}}
	 EV_WM_MEASUREITEM,
	 EV_WM_DRAWITEM,
	 EV_WM_CTLCOLOR,
//{{SetPreferencesRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{SetPreferences Implementation}}


SetPreferences::SetPreferences (TWindow* parent, TData& data,
		SetPrefTransferBuf *tb, TResId templateId,
		const char far* title, TModule* module):
	 TFileOpenDialog(parent, data, templateId, title, module)
{
	 // INSERT>> Your constructor code here.

	new TRadioButton (this, ID_IGNORE, 0);
	new TRadioButton (this, ID_REGEXP, 0);
	TransferBuffer = tb;

	// Set things up for the Icon list box

	PTListBox_Icon = new TIconListBox (this, ID_ICONLIST);
	PTListBox_Icon->DisableTransfer();  // Keep this guy of out the transfer loop
	HIGHLIGHTCOLOR  = GetSysColor(COLOR_HIGHLIGHT);
	WINDOWCOLOR     = GetSysColor(COLOR_WINDOW);
	hWindowBrush    = CreateSolidBrush(WINDOWCOLOR);
	hHighlightBrush = CreateSolidBrush(HIGHLIGHTCOLOR);
}


SetPreferences::~SetPreferences ()
{
	// release icon memory!
	ClearIconList();

	DeleteObject(hWindowBrush);
	DeleteObject(hHighlightBrush);

	// select in old bitmap before killing our BMP and the DC
	SelectObject(hMemDC, hOldBMP);
	DeleteObject(hMyBMP);
	DeleteDC(hMemDC);

	Destroy();
}


LRESULT SetPreferences::EvCommand (UINT id, HWND hWndCtl, UINT notifyCode)
{
	 LRESULT result;

	if (id == IDOK)
	{
		TransferData (tdGetData);
		((SetPrefTransferBuf *)TransferBuffer)->iSelectedIcon =
				PTListBox_Icon->GetSelIndex();
	}

	result = TFileOpenDialog::EvCommand(id, hWndCtl, notifyCode);

	return result;
}


void SetPreferences::SetupWindow ()
{
	 TFileOpenDialog::SetupWindow();

	 // INSERT>> Your code here.

	int nError = 0;

	// put icons into listbox
	nError = FillIconList();

	if (!nError)
		{
		// the "current" icon is sent in, so set it.
		PTListBox_Icon->SetSelIndex(
				((SetPrefTransferBuf *)TransferBuffer)->iSelectedIcon);

		// setup stuff we'll need later.
		HDC hDC = GetDC(HWindow);
		hMemDC = CreateCompatibleDC(hDC);
		hMyBMP = CreateCompatibleBitmap (hDC, PTListBox_Icon->Width(),
														  PTListBox_Icon->Height());
		hOldBMP = (HBITMAP) SelectObject(hMemDC, hMyBMP);
		ReleaseDC(HWindow, hDC);
		}
	else
		{
		MessageBox("Error loading icons to List box.", "ERROR!", MB_OK);
		}
}

// returns 1 if file contains icons, 0 if there is a problem
int SetPreferences::IconsInFile(LPSTR szTestFile)
{
	HICON hIcon;

	hIcon = ExtractIcon(GetApplication()->GetInstance(), szTestFile, 0);

	if ( (int) hIcon == 1)
		{
		MessageBox("Not an appropriate file type.", "ERROR!", MB_OK);
		return 0;
		}
	else if ((int) hIcon == NULL)
		{
		MessageBox("No Icons in file!", "ERROR!", MB_OK);
		return 0;
		}
	DeleteObject(hIcon);
	return 1;
}


// returns 0 if all is well, 1 on error
int SetPreferences::FillIconList()
{
	HICON hIcon;
	HINSTANCE hInstance = GetApplication()->GetInstance();
	LRESULT lOK;
	char	*szIconSourceFile =
			((SetPrefTransferBuf *)TransferBuffer)->szIconSourceFile;

	if (IconsInFile(szIconSourceFile))
		{
		cIconsInFile = (int) ExtractIcon(hInstance, szIconSourceFile, (UINT) -1);

		for (UINT i=0; i<cIconsInFile; i++)
			{
			hIcon = ExtractIcon(hInstance, szIconSourceFile, i);

			lOK = SendDlgItemMsg(ID_ICONLIST, LB_ADDSTRING, 0, MAKELONG(hIcon, 0));
			if (lOK==LB_ERR || lOK==LB_ERRSPACE)
				{
				MessageBox("LB_ADDSTRING Error!", "ERROR!", MB_OK);
				return 1;
				}
			}

		// clear any selection
		PTListBox_Icon->SetSelIndex(-1);

		return 0;
		}
	else return 1;
}


void SetPreferences::ClearIconList()
{
	HICON hIcon;

	for (int i=0; i<cIconsInFile; i++)
		{
		hIcon = (HICON) LOWORD(SendDlgItemMsg(ID_ICONLIST, LB_GETITEMDATA, i, 0L));
		DestroyIcon(hIcon);
		}

	PTListBox_Icon->ClearList();
}


void SetPreferences::EvMeasureItem (UINT ctrlId,
		MEASUREITEMSTRUCT far& measureInfo)
{
	if (ctrlId == ID_ICONLIST)
	{
		measureInfo.itemWidth = PTListBox_Icon->Width();
		measureInfo.itemHeight = PTListBox_Icon->Height();
	}
	else
		TFileOpenDialog::EvMeasureItem(ctrlId, measureInfo);
}


void SetPreferences::EvDrawItem (UINT ctrlId, DRAWITEMSTRUCT far& drawInfo)
{
	HICON hIcon;

	// Since we get a WM_DRAWITEM message for every owner-draw control,
	// we want to handle only the ID_ICONLIST control.

	if (drawInfo.CtlID == ID_ICONLIST)
		{
		DWORD  dwBkColor,  dwOldBkColor;
		HBRUSH hOldBrush, hBackBrush;

		if (drawInfo.itemID == (UINT) -1)
			{
			DrawFocusRect (drawInfo.hDC, (LPRECT)&drawInfo.rcItem);
			return;
			}

		if (drawInfo.itemAction & ODA_FOCUS)
			{
			DrawFocusRect (drawInfo.hDC, (LPRECT)&drawInfo.rcItem);
			return;
			}

		if (drawInfo.itemState & ODA_SELECT)
			{
			DrawFocusRect (drawInfo.hDC, (LPRECT)&drawInfo.rcItem);
			return;
			}


		if (drawInfo.itemState & ODS_SELECTED)
			{
			dwBkColor  = HIGHLIGHTCOLOR;
			hBackBrush = hHighlightBrush;
			}
		else
			{
			dwBkColor  = WINDOWCOLOR;
			hBackBrush = hWindowBrush;
			}

		dwOldBkColor  = SetBkColor   (hMemDC, dwBkColor);
		hOldBrush     = (HBRUSH) SelectObject (hMemDC, hBackBrush);

		PatBlt (hMemDC, 0,0,
				  drawInfo.rcItem.right  - drawInfo.rcItem.left,
				  drawInfo.rcItem.bottom - drawInfo.rcItem.top,
				  PATCOPY);

		hIcon = (HICON) LOWORD(drawInfo.itemData);

		//Draw the icon onto the MemoryDC Assume (left,top) coordinates are (0,0)
		DrawIcon(hMemDC, ICONBORDER, ICONBORDER, hIcon);

		BitBlt (drawInfo.hDC,drawInfo.rcItem.left, drawInfo.rcItem.top,
				  drawInfo.rcItem.right  - drawInfo.rcItem.left,
				  drawInfo.rcItem.bottom - drawInfo.rcItem.top,
				  hMemDC, 0,0, SRCCOPY);

		SetBkColor (hMemDC, dwOldBkColor);       // Reset background color
		SelectObject (hMemDC, hOldBrush);

		if (drawInfo.itemState & ODS_FOCUS)
			DrawFocusRect (drawInfo.hDC, (LPRECT)&drawInfo.rcItem);
	} else
		TFileOpenDialog::EvDrawItem (ctrlId, drawInfo);
}


HBRUSH SetPreferences::EvCtlColor (HDC hDC, HWND, UINT ctlType)
{
	if ((ctlType == CTLCOLOR_LISTBOX) || (ctlType == CTLCOLOR_EDIT))
	{
		SetBkColor (hDC, RGB(255,255,255));
		SetTextColor (hDC, RGB(0,0,0));
		return (HBRUSH) GetStockObject(WHITE_BRUSH);
	} else {
		SetBkColor (hDC, RGB(192, 192, 192));
		SetTextColor (hDC, RGB(0, 0, 0));
		return (HBRUSH) BWCCGetPattern();
	}
}

