;--------------------------------------------------------------------------
; Fake HIMEM.SYS driver so SMARTDRV.EXE can be used on XT's and AT's
; that only have 640K and a chunk of EMS memory, but no extended.
;--------------------------------------------------------------------------
; SMARTDRV 4.X is a good cache, but is DOESN'T work with EMS memory
; like the prior SMARTDRV 3.X releases did.  This is a problem for 
; people with XT's and 640K AT's with no extended memory.  FAKEHI
; implements enough of the XMS spec to allow SMARTDRV 4.X to work 
; when EMS 4.0 memory is present.
;--------------------------------------------------------------------------
;    *** This driver requires a 4.0 level EMS driver to function! ***
;--------------------------------------------------------------------------
; Author: Tony Ingenoso
;--------------------------------------------------------------------------

GET_XMS_VERSION = 00h           ; XMS function numbers we support
XMS_QUERY_FREE  = 08h
XMS_ALLOC_EMB   = 09h
XMS_FREE_EMB    = 0Ah
XMS_MOVE_EMB    = 0Bh
XMS_GET_HINFO   = 0Eh
XMS_REALLOC_EMB = 0Fh

NOT_IMPLEMENTED = 80h           ; XMS error numbers we might return
ER_GENERAL      = 8Eh
ER_ALL_ALLOCATED= 0A0h
ER_NO_HANDLES   = 0A1h
ER_BAD_HANDLE   = 0A2h
ER_BAD_SRCHANDLE= 0A3h
ER_BAD_SRCOFFSET= 0A4h
ER_BAD_DSTHANDLE= 0A5h
ER_BAD_DSTOFFSET= 0A6h
ER_BAD_LENGTH   = 0A7h
ER_BAD_OVERLAP  = 0A8h

MY_EMB_HANDLE   = 0001h

EMSxlatbuf      struc
block_len       dd      ?
src_type        db      ?
src_handle      dw      ?
src_offset      dw      ?
src_segp        dw      ?
dst_type        db      ?
dst_handle      dw      ?
dst_offset      dw      ?
dst_segp        dw      ?
                ends

XMSbuf          struc
xblock_len      dd      ?
xsrc_handle     dw      ?
xsrc_offset     dw      ?
xsrc_segp       dw      ?
xdst_handle     dw      ?
xdst_offset     dw      ?
xdst_segp       dw      ?
                ends

;--------------------------------------------------------------------------
;                     Local vars for the emulation
;--------------------------------------------------------------------------

OldInt2F        equ     dword ptr cs:[128+0]      ; For chaining
EMSmaxpages     equ     word  ptr cs:[128+4]      ;
EMSframe        equ     word  ptr cs:[128+6]      ;
EMShandle       equ     word  ptr cs:[128+8]      ;
EMBsize         equ     word  ptr cs:[128+10]     ; Our EMB's size (in K)
Temp            equ     word  ptr cs:[128+12]     ; Scratch word
AllocFlag       equ     byte  ptr cs:[128+14]     ; Is our EMB allocated?
EMSxbuf         equ               cs:[128+16]     ; EMSxlatbuf <>

; Note: Int 2F hooker will be relocated into command tail at 80h+40
;       so make sure you don't extend any of the local vars into it...

Loc2FHook = (80h+40)

; Note: The pointer xlat will be relocated into command tail at 80h+40+22h
;       so make sure you don't extend any of the local vars into it...
;       This 4 bytes beyond the end of the 2F hook given current sizes...
;       the 2F hook is 18h bytes long

XlatPtrLoc = (80h+40+22h)



fakehi  segment para public 'CODE'
        assume  cs:fakehi

        org     XlatPtrLoc
XlatProc label near

        org     100h
start   label   near
        jmp     initialize
;--------------------------------------------------------------------------
; Putting this instruction in a proc saves some space.  Immediate compares
; to memory are BIG instructions.
;--------------------------------------------------------------------------
CmpAllocFlag0 proc near
        cmp     AllocFlag, 0
        ret
CmpAllocFlag0 endp

;--------------------------------------------------------------------------
;                          XMMControl
;--------------------------------------------------------------------------
; Main Entry point for EMS --> XMS converter
;
; ARGS:   AH = Function, AL = Optional parm
; RETS:   AX = Function Success Code, BL = Optional Error Code
; REGS:   AX, BX, DX and ES may not be preserved depending on func.
;--------------------------------------------------------------------------
        align   2
XMMControl  proc   far
        public  XMMControl

        jmp     short XMMControlEntry   	; Near JMP-->end hook chain
        nop                             	; NOP's allow
        nop                             	;   for "hookability"
        nop                             	;    by a subsequent driver.

XMMControlEntry:
        mov     al, ah
        cmp     al, XMS_MOVE_EMB        	; Move?
        je      toXMSmove               	;
        cmp     al, GET_XMS_VERSION     	; Version?
        je      XMSverCheck             	;
        cmp     al, XMS_ALLOC_EMB       	; Alloc?
        je      XMSalloc                	;
        cmp     al, XMS_FREE_EMB        	; Free?
        je      XMSfree                 	;
        cmp     al, XMS_GET_HINFO       	; Handle info req
        je      XMShandle_info          	;
        cmp     al, XMS_REALLOC_EMB     	; Realloc req
        je      XMSrealloc              	;
        cmp     al, XMS_QUERY_FREE      	; Query?
        je      XMSquery                	;

NotImplemented:
        mov     bl, NOT_IMPLEMENTED     	; Error code
MergeAX0Ret:                            	;
        xor     ax, ax                  	; Error condition
        ret                             	;

XMSverCheck:                            	; Fake up a version.
        mov     ax, 0200h               	; Version 2.00
        mov     bx, 0001                	; Rev 0001
        cwd                             	; DX=No HMA(i.e. 0000)
        ret                             	;

toXMSmove:
        jmp     short XMSmove                 	; Bridge jmp

SuccessReturn:
        mov     ax, 0001h               	; Return with
        ret                             	;   success RC.


;--------------------------------------------------------------------------
;                          Query free EMB's
;--------------------------------------------------------------------------
XMSquery:                               	; It's a query request
        call    CmpAllocFlag0           	;
        jne     Q_already_allocated     	;

        mov     ax, EMBsize             	; Total == largest
        mov     dx, ax                  	;
        mov     bl, 0                   	; No error
        ret                             	;

Q_already_allocated:
        xor     dx, dx                  	;
        mov     bl, ER_ALL_ALLOCATED    	;
        jmp     short MergeAX0Ret       	;

;--------------------------------------------------------------------------
;                          Allocate an EMB block
;--------------------------------------------------------------------------
XMSalloc:                               	; It's an alloc request
        mov     Temp, dx                	;
        call    CmpAllocFlag0           	; Unallocated?
        mov     dx, MY_EMB_HANDLE       	;
NE_AX0Ret:
        mov     bl, ER_ALL_ALLOCATED    	;
        jne     MergeAX0Ret             	; It's allocated already.
        mov     dx, Temp                	; Does the
        cmp     dx, EMBsize             	;  request fit?
        jnle    NE_AX0Ret               	; Note: NLE implies NE!
        mov     dx, MY_EMB_HANDLE       	; Handle to return
        mov     AllocFlag, 1            	; Now it's allocated
        jmp     short SuccessReturn     	;

;--------------------------------------------------------------------------
;                          Free EMB block
;--------------------------------------------------------------------------
XMSfree:                                	; It's a free request
        cmp     dx, MY_EMB_HANDLE       	; Handle OK?
        jne     BadHandle               	;
        xor     ax, ax                  	;
        xchg    AllocFlag, al           	; If 0,stay 0,if ~then==0
        dec     ax                      	; 0 --> -1,  1 --> 0
        jz      SuccessReturn           	; It *was* allocated
BadHandle:
        mov     bl, ER_BAD_HANDLE       	; For req w/bad handles
To_MergeAX0Ret:
        jmp     short MergeAX0Ret       	;

;--------------------------------------------------------------------------
;                          Get EMB handle info
;--------------------------------------------------------------------------
XMShandle_info:                         	; It's an info request
        cmp     dx, MY_EMB_HANDLE       	; Handle OK?
        jne     BadHandle               	;
        call    CmpAllocFlag0           	; Unallocated?
        je      BadHandle               	;
        xor     bx, bx                  	; Lock=0, Free=0
        mov     dx, EMBsize             	; Block size in K
To_SuccessReturn:
        jmp     short SuccessReturn     	;

;--------------------------------------------------------------------------
;                          Reallocate EMB block
;--------------------------------------------------------------------------
XMSrealloc:                             	; It's a realloc request
        cmp     dx, MY_EMB_HANDLE       	; Handle OK?
        jne     BadHandle               	;
        call    CmpAllocFlag0           	; Unallocated?
        je      BadHandle               	;
        cmp     bx, EMBsize             	; Too big?
        jbe     To_SuccessReturn        	;
        mov     bl, ER_BAD_LENGTH       	; For reallocs too big
        jmp     short To_MergeAX0Ret    	;

;--------------------------------------------------------------------------
;               Move EMB block (this is the tricky one)
;--------------------------------------------------------------------------
XMSmove:
        mov     ax, ds:[si].xsrc_handle
        cmp     ax, MY_EMB_HANDLE         	; Validate Src h
        je      SrcHandleOK                     ;
        or      ax, ax                          ; 0 == low mem
        jnz     BadHandle                       ;
SrcHandleOK:
        mov     EMSxbuf.src_type, 0             ; Default to lowmem
        or      ax, ax                          ; Low mem?
        jz      SaveSrcH                        ; Yes.  It's OK.
        mov     ax, EMShandle                   ; No, xlat to EMS
        mov     EMSxbuf.src_type, 1             ; Type = EMS
SaveSrcH:
        mov     EMSxbuf.src_handle, ax          ; Save Src h
        mov     ax, ds:[si].xdst_handle         ;
        cmp     ax, MY_EMB_HANDLE               ; Validate Dst h
        je      DstHandleOK                     ;
        or      ax, ax                          ; 0 == low mem
        jnz     BadHandle                       ;
DstHandleOK:
        mov     EMSxbuf.dst_type, 0             ; Default to lowmem
        or      ax, ax                          ; Low mem?
        jz      SaveDstH                        ; Yes.  It's OK.
        mov     ax, EMShandle                   ; No, xlat to EMS
        mov     EMSxbuf.dst_type, 1             ; Type = EMS
SaveDstH:
        push    ds
        push    es
        push    si
        push    di

        mov     EMSxbuf.dst_handle, ax
        les     di, dword ptr ds:[si].xblock_len        ; Move in the len
        mov     word ptr EMSxbuf.block_len, di
        mov     word ptr EMSxbuf.block_len+2, es
        les     di, dword ptr ds:[si].xsrc_offset       ; Move src addr
        mov     word ptr EMSxbuf.src_offset, di
        mov     word ptr EMSxbuf.src_offset+2, es
        les     di, dword ptr ds:[si].xdst_offset       ; Move dst addr
        mov     word ptr EMSxbuf.dst_offset, di
        mov     word ptr EMSxbuf.dst_offset+2, es

        ;---------------------------------------------------
        ; Translate Src pointer to EMS form (if necessary)
        ;---------------------------------------------------
        cmp     EMSxbuf.src_type, 0             ; Lowmem?
        je      ChkDstForXlat                   ; No xlat in this case...

        les     di, dword ptr EMSxbuf.src_offset
        call    XlatProc
        mov     word ptr EMSxbuf.src_offset, di
        mov     word ptr EMSxbuf.src_offset+2, es

ChkDstForXlat:
        ;---------------------------------------------------
        ; Translate Dst pointer to EMS form (if necessary)
        ;---------------------------------------------------
        cmp     EMSxbuf.dst_type, 0             ; Lowmem?
        je      XlatingDone                     ; No xlat in this case...

        les     di, dword ptr EMSxbuf.dst_offset
        call    XlatProc
        mov     word ptr EMSxbuf.dst_offset, di
        mov     word ptr EMSxbuf.dst_offset+2, es

XlatingDone:
        push    cs                              ; DS:SI --> EMS xlated info
        pop     ds                              ;
        mov     si, offset EMSxbuf              ;
        mov     ax, 5700h                       ;
        int     67h                             ; Call EMS manager

        pop     di
        pop     si
        pop     es
        pop     ds
        or      ah, ah                          ; EMS error?
        jnz     SomeEMSerror                    ; Yes,
        jmp     SuccessReturn                   ;

SomeEMSerror:
        mov     bl, ER_GENERAL                  ;
        jmp     MergeAX0Ret                     ;
XMMControl  endp

;--------------------------------------------------------------------------
; Anything beyond this point gets discarded when the driver goes resident.
;--------------------------------------------------------------------------

THROW_AWAY_CODE label near
        public  THROW_AWAY_CODE         	; For a MAP file

;--------------------------------------------------------------------------
; Translate EMB addresses into EMS ones.
;
; Input  ES:DI - Block offset in EMB form
; Output ES:DI - [logical page]:[offset within that page]
;
; Trashes:  AX, SI
;--------------------------------------------------------------------------
XlatPointer proc near
        push    dx                      	;
        mov     ax, di                  	; Get into divide form
        mov     dx, es                  	;
        mov     si, 16384               	; EMS page size
        div     si                      	;
        mov     di, dx                  	; DI == DWORD offset mod 16K
        mov     es, ax                  	; ES == logical page #
        pop     dx                      	;
        ret
XlatPointer endp

LenXLAT = ($-XlatPointer)

;------------------------------------------------------------
; This is our Int 2F hooker (relocated at init into the PSP)
;------------------------------------------------------------
; - Look for Int 2F fn 4310h and return our XMM entry point.
; - Look for Int 2F fn 4310h and respond to 4300.
;------------------------------------------------------------
; Note: all JMP's in this routine should be relative as it
; gets relocated at init time...
;------------------------------------------------------------

Int2FHook proc far
        public  Int2FHook

        cmp     ax, 4300h               	; Get installed state?
        je      SayYesToXMS             	; Yes,...
        cmp     ax, 4310h               	; Get entry point?
        je      ReturnXMSEntry          	;
GoToPrev2F:
        jmp     OldInt2F                	; Chain to the next guy.

SayYesToXMS:
        mov     al, 80h                 	; We're here.
        iret                            	;

ReturnXMSEntry:
        push    cs                      	; ES:BX --> XMM control entry
        pop     es                      	;
        mov     bx, offset XMMControl   	;
        iret                            	;
Int2FHook endp

Len2FHook = ($-Int2FHook)


EMSname db      'EMMXXXX0'

;--------------------------------------------------------------------------
;                    See if it's possible to load.
;--------------------------------------------------------------------------
initialize label near
        mov     EMBsize, 0
        mov     AllocFlag, 0

        ;--------------------------------------------------------------
	; Check for "/?" or "?" or "-?" parameter
        ;--------------------------------------------------------------
	xor	cx, cx
	mov	cl, cs:[80h]
	jcxz	DoSignon			; No parms 

	cld
	mov	si, 0081h
StripWhiteSpace:
	lodsb
	cmp	al, ' '
	je	StripWhiteSpace
	cmp	al, 9
	je	StripWhiteSpace
	cmp	al, 0Dh
	je	DoSignon
	cmp	al, 0h
	je	DoSignon

	cmp	al, '?'		; "?" ?
	je	ShowHelp
	cmp	al, '-'		; "-?" ?
	je	TryQuest
	cmp	al, '/'		; "/?" ?
	jne	BadParm
TryQuest:
	lodsb
	cmp	al, '?'
	jne	BadParm

ShowHelp:
	mov	dx, offset MSGhelp
QuitToDOS:
	mov	ah, 9
	int	21h
	ret

BadParm:
	mov	dx, offset MSGBadParm
	jmp	short QuitToDOS

DoSignon:
	;--------------------------------------------------------------
        ; Do signon message
        ;--------------------------------------------------------------
        mov     dx, offset MSGlogo      	; Spit out a logo message
        mov     ah, 9                   	;
        int     21h

        ;--------------------------------------------------------------
        ; Check for existing HIMEM driver
        ;--------------------------------------------------------------
        mov     ax, 4300h               	; Is a HIMEM of some sort
        int     2Fh                     	;   out there already?
        cmp     al, 80h                 	;
        jne     NoHIMEMhere             	;
        mov     dx, offset HIMEMpresent

InitError:
        ;--------------------------------------------------------------
        ; Initialization errors come here.  DX==offset of appropriate
        ; error message.
        ;--------------------------------------------------------------
        push    cs                      	; Emit an error message
        pop     ds                      	;  and terminate with
        mov     ah, 9                   	;   an error code.
        int     21h
        mov     ax, 4CFFh               	; Terminate, RC == 255
        int     21h                     	;

NoHIMEMhere:
        ;--------------------------------------------------------------
        ; Check for EMS driver
        ;--------------------------------------------------------------
        mov     ax, 3567h                       ; Get Int 67 vector
        int     21h                             ;
        mov     di, 10                          ; ES:DI --> dev name in header
        push    cs                              ;
        pop     ds                              ;
        mov     si, offset EMSname              ;
        cld                                     ;
        mov     cx, 4                           ; 4 words
        rep     cmpsw                           ;
        mov     dx, offset MSGnoEMS             ;
        jne     InitError                       ; No driver present

        ;--------------------------------------------------------------
        ; Check driver status
        ;--------------------------------------------------------------
        mov     ah, 40h                         ;
        int     67h                             ;
BadDriver:
        mov     dx, offset MSGbadEMSdr          ;
        cmp     ah, 0                           ;
ne_to_InitError:
        jne     InitError                       ; Driver's hosed

        ;--------------------------------------------------------------
        ; Check for EMS 4.0 driver
        ;--------------------------------------------------------------
        mov     ah, 46h                         ; EMS version check
        int     67h                             ;
        or      ah, ah                          ; OK?
        mov     dx, offset MSGbadEMSdr          ;
        jnz     InitError                       ;
        and     ax, 00F0h                       ; Mask major ver
        cmp     ax, 0040h                       ; EMS 4.0?
        mov     dx, offset MSGverEMS            ;
        jb      InitError                       ; We need 4.0+

        ;--------------------------------------------------------------
        ; Check available memory.
        ;--------------------------------------------------------------
        mov     ah, 42h                         ;
        int     67h                             ;
        cmp     ah, 0                           ;
        jne     BadDriver                       ;
        cmp     bx, dx                          ; avail = total?
        mov     ax, dx                          ; Save DX
        mov     dx, offset MSGbadOOPS           ;
        jne     InitError                       ; Somebody's got EMS allocated
        cmp     bx, 4                           ; Full frame?
        mov     dx, offset MSGnoEMSmem          ;
        jb      InitError                       ; <64K available
        mov     EMSmaxpages, bx

        ;--------------------------------------------------------------
        ; Get the frame address.
        ;--------------------------------------------------------------
        mov     ah, 41h                         ;
        int     67h                             ;
        cmp     ah, 0                           ;
        jne     BadDriver                       ;
        mov     EMSframe, bx                    ;

        ;--------------------------------------------------------------
        ; Take it all.
        ;--------------------------------------------------------------
        mov     bx, EMSmaxpages                 ;
        mov     ah, 43h                         ;
        int     67h                             ;
        mov     EMShandle, dx                   ;
        mov     dx, offset MSGnogo              ;
        cmp     ah, 0                           ;
        jne     ne_to_InitError                 ;

        ;--------------------------------------------------------------
        ; Compute size of our EMB.
        ;--------------------------------------------------------------
        mov     ax, EMSmaxpages                 ; Each page holds 16K
        mov     cl, 4                           ;
        shl     ax, cl                          ; *16
        mov     EMBsize, ax                     ; AX == EMB size (in K)

        ;--------------------------------------------------------------
        ; See if we should free the environment.
        ;--------------------------------------------------------------
        mov     cx, cs:[2Ch]            	; CX == Env pointer
        jcxz    NoEnvironment           	;

        mov     es, cx                  	; ES == Env seg
        mov     ah, 49h                 	; Free the environment
        int     21h                     	;				    
NoEnvironment:

        ;--------------------------------------------------------------
        ; Save the old 2F for chaining purposes...
        ;--------------------------------------------------------------
        mov     ax, 352Fh               	; Save old Int 2F
        int     21H                     	;  for chaining purposes
        mov     word ptr OldInt2F.0, bx 	;
        mov     word ptr OldInt2F.2, es 	;

        ;--------------------------------------------------------------
        ; Slide the Int 2F hook code up into the PSP
        ;--------------------------------------------------------------
        cld                             	;
        push    cs                      	;
        pop     ds                      	;
        push    cs                      	;
        pop     es                      	;
        mov     cx, Len2FHook           	;
        mov     si, offset Int2FHook    	;
        mov     di, Loc2FHook           	;
        rep     movsb                   	; Wham!

        ;--------------------------------------------------------------
        ; Slide xlat ptr function into the PSP
        ;--------------------------------------------------------------
        mov     cx, LenXLAT             	;
        mov     si, offset XlatPointer  	;
        mov     di, XlatPtrLoc          	;
        rep     movsb                   	; Wham!

        ;--------------------------------------------------------------
        ; Take Int 2F and go "hot".
        ;--------------------------------------------------------------
        mov     ax, 252Fh               	; Take Int 2F
        mov     dx, Loc2FHook           	;
        int     21h                     	; We're "hot"!

        mov     dx, offset THROW_AWAY_CODE
        int     27h                     	; go resident

	include fakehi.mri			; messages file

fakehi  ends
        end     start
