//
//       filename: F2PSCN3.POV
//
//       Pinwheel composed of monolith's ( 2001 a space odyessy 1:4:9 )
//        
//       by David Grossman  ( Monolith from Arthur C Clark )
//

#include "frct2pov.inc"

camera   {  location < 0, 6, 8 >
            direction < 0, 0, 7 >
            up < 0, 1, 0 >        // y is up
            right < -4/3, 0, 0 >  // right handed system
            look_at < 0, -.05, 0 >
         }
         
#declare monolith = box { < -.05,-.2,-.45 > , < .05,.2,.45 > rotate 45*z 
                          translate .45*z }

#declare pinwheel = union { object { monolith }
                            object { monolith rotate 60*y }
                            object { monolith rotate 120*y }
                            object { monolith rotate 180*y }
                            object { monolith rotate 240*y }
                            object { monolith rotate 300*y }
                           }

object   {  pinwheel  rotate 15*y
            texture  {  frct2pov
                        finish   {  ambient .5 diffuse .5 } rotate -90*x }  }


object   {  light_source   {  < 20, 15, 20 > color rgb < 1, 1, 1 > } }
                                    
                                
                                    
                                    
                                    
