//      
//       filename: F2PSCN5.POV
//
//       Fractint Mandelbrot height field with a Mandelbrot texture.
//
//       This source requires a Fractint '.gif' or '.pot' and its
//       corresponding Mandelbrot texture to render correctly.
//
//       
//       To render the sample parameter 'mandelpot' in 'f2p.par';
//
//       Plot the parameter in fractint at the desired resolution.
//         ( the higher the resolution the smoother but slower )
//       Move the image to somewhere in the POV-Ray path and
//         rename it 'mandel.pot'
//       Convert the parameter to a texture with Fractint to POV-Ray
//       ( Try ff=20 on the commandline )
//       Render this scene file.
//
//       by David Grossman 
//

#include "frct2pov.inc"

camera   {  location < 3,4,10 >
            direction < 0,0,7 >
            up < 0,1,0 >
            right < -4/3,0,0 >
            look_at < 0,0,0 >
         }
//                       -=>  gif "??????.gif"                 
object   {  height_field   {  pot "mandel.pot" } translate < -.5,-.5,-.5 > scale < 2,1,-1.5 > 
            texture { frct2pov finish { ambient .4 diffuse .6 } rotate -90*x } 
         }

object   {  light_source   {  < 50,50,50 > color rgb < 1,1,1 > } }



