;***************************************************************************;
;	       	     Binary file Iuput/Output Modules			    ;
;                        1993/4/20 --by Chio.T.I.		            ;
;							 		    ;
;       There are 12 functions for binary file I/O. Callable by C as:	    ;
;	  int  openfile( char *filename, int access );		    	    ;
;         int  closefile( int handle );				    	    ;
;	  long readfile( int handle, char far *buffer, long count );  	    ;
;	  long seekfile( int handle, long displace, int where );	    ;
;	  long filesize( int handle );				    	    ;
;	  int  writefile( int handle, char far *buffer, int count );        ;
;	  char getfilechar( int handle );				    ;
;	  int  findfile( char *filename, int attrib, char *foundfile );	    ;
;	  int  getdrive( void );					    ;
;	  int  changedrive( int driveNO );                                  ;
;	  int  changedir( char *directory );                                ;
;	  int  getdirectory( char *directory );                             ;
;                                                                           ;
;***************************************************************************;
		.Model	Small
		.Code

;---------------------------------------------------------------------------;
;   	int openfile( char *filename, int access );                         ;
;									    ;
;       When access = 0, read only.                                         ;
;            access = 1, write only. If file does not exist, creat it.      ;
;	     access = 2, read / write. If file does not exist, creat it.    ;
;       Return file handle if successful, else return -1.		    ;
;---------------------------------------------------------------------------;

		PUBLIC	_openfile
 _openfile	PROC
		push	bp
		mov	bp,sp
		push	ds
		push	dx
		mov	ax,[bp+6]
		mov	ah,3dh
		mov	dx,[bp+4]
		int	21h
		jnb	ExitOpen
		cmp	WORD PTR [bp+6],0
		je	OpenError
		mov	ah,3ch
		mov	cx,0
		int	21h
		jnb	ExitOpen
 OpenError:	mov	ax,-1
 ExitOpen:	pop	dx
		pop	ds
		pop	bp
		ret
 _openfile	ENDP

;---------------------------------------------------------------------------;
;       int closefile( int handle );					    ;
;	Return zero if successful else return -1.			    ;
;---------------------------------------------------------------------------;

		PUBLIC	_closefile
 _closefile	PROC
		push	bp
		mov	bp,sp
		push	bx
		mov	bx,[bp+4]
		mov	ah,3eh
		int	21h
		jc	CloseError
		mov	ax,0
		jmp	ExitClose
 CloseError:	mov	ax,-1
 ExitClose:     pop	bx
		pop	bp
		ret
 _closefile	ENDP

;---------------------------------------------------------------------------;
;       long readfile( int handle, char far *buffer, long count );	    ;
;       Return count on success, return -1 on failure.			    ;
;---------------------------------------------------------------------------;

		PUBLIC	_readfile
 _readfile	PROC
		push	bp
		mov	bp,sp
		push	ds
		push	cx
		push	bx
		mov	ax,[bp+8]
		mov	ds,ax
		mov	dx,[bp+6]
		mov	cl,4
		shr	dx,cl
		add	ax,dx
		mov	ds,ax
		mov	dx,[bp+6]
		and	dx,000fh
		mov	bx,[bp+4]
		mov	cx,[bp+12]
		add	cx,cx
		inc	cx
 DoRead:	push	cx
		cmp	cx,1
		je	LastRead
		mov	cx,8000h
		jmp	DosCall
 LastRead:	mov	cx,[bp+10]
 DosCall:       mov	ah,3fh
		int	21h
		jc	ReadError
		cmp	ax,cx
		jb	ReadEnd
		mov	ax,ds
		add	ax,0800h
		mov	ds,ax
 ReadAgain:	pop	cx
		loop	DoRead
		jmp	AllRead
 ReadEnd:	pop	cx
		push	ax
		mov	ax,[bp+12]
		add	ax,ax
		inc	ax
		sub	ax,cx
		xor	dx,dx
		mov	bx,8000h
		mul	bx
		pop	bx
		add	ax,bx
		adc	dx,0
		jmp	ExitRead
 ReadError:	mov	dx,-1
		mov	ax,-1
		jmp	ExitRead
 AllRead:	mov	dx,[bp+12]
		mov	ax,[bp+10]
 ExitRead:	pop	bx
		pop     cx
		pop	ds
		pop	bp
		ret
 _readfile	ENDP

;---------------------------------------------------------------------------;
;	long fileseek( int handle, long displace, int where );		    ;
;       When  where = 0, pointer moved from head of file 		    ;
;	      where = 1, pointer moved from current position.		    ;
;	      where = 2, pointer moved from end of file.		    ;
;	Return pointer position if successful else return -1.		    ;
;---------------------------------------------------------------------------;

		PUBLIC	_seekfile
 _seekfile	PROC
		push	bp
		mov	bp,sp
		push	cx
		push	bx
		mov	ax,[bp+10]
		mov	ah,42h
		mov	bx,[bp+4]
		mov	cx,[bp+8]
		mov	dx,[bp+6]
		int	21h
		jnb	ExitSeek
		mov	ax,-1
		mov	dx,-1
 ExitSeek:	pop	bx
		pop	cx
		pop	bp
		ret
 _seekfile	ENDP

;---------------------------------------------------------------------------;
;	long filesize( int handle );					    ;
;	Return file length on success, -1 on failure.			    ;
;---------------------------------------------------------------------------;

		PUBLIC	_filesize
 _filesize	PROC
		push	bp
		mov	bp,sp
		push	cx
		push	bx
		mov     ax,4202h
		mov	bx,[bp+4]
		xor	cx,cx
		xor	dx,dx
		int	21h
		jc	SeekError
		push	ax
		push	dx
		mov	ax,4200h
		xor	dx,dx
		int	21h
		jc	SeekError
		pop	dx
		pop     ax
		jmp	ExitSize
 SeekError:	mov	dx,-1
		mov	ax,-1
 ExitSize:	pop	bx
		pop	cx
		pop	bp
		ret
 _filesize	ENDP

;---------------------------------------------------------------------------;
;	int writefile( int handle, char far *buffer, int count );	    ;
;       Return count on success, -1 on failure.				    ;
;---------------------------------------------------------------------------;

		PUBLIC	_writefile
 _writefile	PROC
		push	bp
		mov	bp,sp
		push	ds
		push	bx
		push	cx
		push    dx
		mov	bx,[bp+4]
		mov	ax,[bp+8]
		mov	ds,ax
		mov	dx,[bp+6]
		mov	cx,[bp+10]
		mov	ah,40h
		int	21h
		jnb	ExitWrite
		mov	ax,-1
 ExitWrite:	pop	dx
		pop	cx
		pop	bx
		pop	ds
		pop	bp
		ret
 _writefile	ENDP

;--------------------------------------------------------------------------;
;	char getfilechar( int handle );					   ;
;	int  getfileint( int handle );					   ;
;--------------------------------------------------------------------------;

		PUBLIC	_getfilechar
 _getfilechar	PROC
		push	bp
		mov	bp,sp
		push	ds
		mov	ax,cs
		mov	ds,ax
		mov	cx,1
		mov	dx,OFFSET TempBuffer
		mov	bx,[bp+4]
		mov	ah,3fh
		int	21h
		xor	ax,ax
		mov	al,BYTE PTR cs:TempBuffer
		pop	ds
		pop	bp
		ret
 TempBuffer	DB	?
 _getfilechar	ENDP

		PUBLIC	_getfileint
 _getfileint	PROC
		push	bp
		mov	bp,sp
		push	ds
		mov	ax,cs
		mov	ds,ax
		mov	cx,2
		mov	dx,OFFSET TempBuff
		mov	bx,[bp+4]
		mov	ah,3fh
		int	21h
		mov	ax,WORD PTR cs:TempBuff
		pop	ds
		pop	bp
		ret
 TempBuff	DW	?
 _getfileint	ENDP

;---------------------------------------------------------------------------;
;	int findfile( char *filename, int attrib,  char *foundname );       ;
;	return count of found files.					    ;
;---------------------------------------------------------------------------;

		PUBLIC	_findfile
 _findfile	PROC
		push	bp
		mov	bp,sp
		push	es
		push	dx
		push	cx
		push	bx
		push	si
		push	di

		xor	di,di
		mov	si,[bp+8]
		mov	ah,2fh
		int	21h   			;Get DTA address
		mov	dx,[bp+4]
		mov	cx,[bp+6]
		mov	ah,4eh
		int	21h
		cmp	ax,0
		jne	EndFind
 FindAgain:     mov     cx,[bp+6]
		and	cx,es:[bx+21]
		cmp     cx,0
		je      DonotCopy
		inc	di
		push	bx
		mov	cx,13
 CopyName:	mov	al,es:[bx+30]
		mov	[si],al
		inc	si
		inc	bx
		loop	CopyName
		pop	bx
 DonotCopy:	mov	ah,4fh
		int	21h
		cmp	ax,0
		je	FindAgain
 EndFind:	mov	ax,di
		pop	di
		pop	si
		pop	dx
		pop	cx
		pop	bx
		pop	es
		pop	bp
		ret
 _findfile	ENDP
;---------------------------------------------------------------------------;
;	  int getdrive( void );				  		    ;
;---------------------------------------------------------------------------;
		PUBLIC	_getdrive
 _getdrive	PROC
		mov	ah,19h
		int	21h
		xor	ah,ah
		ret
 _getdrive	ENDP
;---------------------------------------------------------------------------;
;	  int getdirectory( char *dirname );					    ;
;---------------------------------------------------------------------------;

		PUBLIC	_getdirectory
 _getdirectory  PROC
		push	bp
		mov	bp,sp
		push	si
		push	dx
		call	_getdrive
		mov	dl,al
		inc	dl
		mov	si,[bp+4]
		mov	ah,47h
		int	21h
		pop	dx
		pop	si
		pop	bp
		ret
 _getdirectory  ENDP
;---------------------------------------------------------------------------;
;		int changedrive( int driveno );				    ;
;	        Return count of all drives!				    ;
;---------------------------------------------------------------------------;
		PUBLIC	_changedrive
 _changedrive	PROC
		push	bp
		mov	bp,sp
		push	dx
		mov	dx,[bp+4]
		mov	ah,0eh
		int	21h
		xor	ah,ah
		pop	dx
		pop	bp
		ret
 _changedrive	ENDP

;---------------------------------------------------------------------------;
;		int changedir( char *dirname );				    ;
;---------------------------------------------------------------------------;
		PUBLIC	_changedir
 _changedir	PROC
		push    bp
		mov	bp,sp
		push	dx
		mov	dx,[bp+4]
		mov	ah,3bh
		int	21h
		pop	dx
		pop	bp
		ret
 _changedir	ENDP

		END




