;***************************************************************************;
;              Sound Blaster and Sound Blaster Pro Liberary		    ;
;                      1992/12/22  Coded by Chio.T.I.			    ;
;	      National Central University, Chung-Li, Taiwan.		    ;
;---------------------------------------------------------------------------;
;      The Liberary includes following C callable functions:		    ;
;          int SB_Check( void );				   	    ;
;          void TurnOnSpeaker( void );				    	    ;
;	   void TurnOffSpeaker( void );                                     ;
;	   void SetSampleRate( unsigned Rate );				    ;
;          void TransferDMA( int Page, unsigned offset, unsigned count );   ;
;	   void HaltDMA( void );					    ;
;	   void ContinueDMA( void );					    ;
;***************************************************************************;

; Define DSP commands

 Speaker_On		Equ	0d1h
 Speaker_Off		Equ     0d3h
 Time_Constant		Equ	040h
 DMA_8bit_DAC		Equ	014h
 Halt_DMA		Equ	0d0h
 Continue_DMA		Equ	0d4h
 Mixer_Address		EQU	04h	;SoundBlaster Pro only
 Mixer_Data		EQU	05h	;SoundBlaster Pro only

; Define DSP R/W address

 DSP_WriteData		Equ	0ch
 DSP_DataAvailable	Equ	0eh
 DSP_ReadData		Equ	0ah
 DSP_Reset		Equ	06h

; Define DMA address and commands

 DMA_Mask        	Equ     0Ah     ; DMAC DMA_Mask (write-only)
 DMA_Mode            	Equ     0Bh     ; DMAC mode (read/write)
 DMA_Pointer        	Equ     00ch    ; byte pointer flip-flop
 DMA_ReadCmd        	Equ     048h    ; read mode
 DMA_WriteCmd       	Equ     044h    ; write mode
 DMA_SetCmd         	Equ     000h    ; DMA_Mask set
 DMA_ResetCmd       	Equ     004h    ; DMA_Mask reset

 True			Equ	1
 False			Equ	0

		.Model Small
		.286
		.Code

 Extrn		_SBIOAddr:Word
 Extrn		_DMAChannel:Word
 Extrn		_SBType:Word
 Extrn		_Stereo:Word

 Page_Table    	dw	0087h	; channel 0
		dw	0083h	; channel 1
		dw	0081h	; channel 2
		dw	0082h	; channel 3

;---------------------------------------------------------------------------;
;     Write command to Sound Blaster ( Command store in al )   		    ;
;---------------------------------------------------------------------------;
 SendCommand 	Proc 	near
		push    dx
		push    ax
		mov     dx,cs:_SBIOAddr
		add     dx,DSP_WriteData
 Sendcommandloop:
		in      al,dx
		test    al,80h
		jnz     sendcommandloop
		pop     ax
		out     dx,al
		pop     dx
		ret
 SendCommand 	Endp
;---------------------------------------------------------------------------;
;     Write commands to Sound Blaster Pro ( Command values in al,ah ).	    ;
;---------------------------------------------------------------------------;
 WriteMixer	PROC
		push	dx
		mov	dx,cs:_SBIOaddr
		add	dx,Mixer_Address	;Command1 in al
		out	dx,al
		mov	dx,cs:_SBIOaddr
		add	dx,Mixer_Data
		mov	al,ah			;Command2 in ah
		out	dx,al
		pop	dx
		ret
 WriteMixer	ENDP
;---------------------------------------------------------------------------;
;	void TransferDMA( int Page, unsigned Offset, unsigned count );      ;
;---------------------------------------------------------------------------;
		Public	_TransferDMA
 _TransferDMA   Proc    near
		push	bp
		mov	bp,sp
		pusha

		mov	ah,[bp+4]
		mov	bx,[bp+6]
		mov	cx,[bp+8]
		dec     cx
		mov     al,Byte Ptr cs:_DMAChannel
		add	al,DMA_ResetCmd
		out     DMA_Mask,al     	;Mask off channel
		xor     al,al
		out     DMA_Pointer,al  	;Clear byte pointer Flip/Flop to lowerbyte
		mov	al,Byte Ptr cs:_DMAChannel
		add     al,DMA_ReadCmd		;ReadCmd: Card read Bus
		out     DMA_Mode,al     	;Set transfer mode to DAC
		mov	dx,cs:_DMAChannel
		shl	dx,1
		mov     al,bl           	;LSB of Offset
		out     dx,al
		mov     al,bh           	;MSB of Offset
		out     dx,al
		mov     al,ah
		mov	bx,dx
		push	dx
		mov	dx,cs:[Page_Table+bx]
		out     dx,al          		;Page Number
		pop	dx
		inc	dx
		mov     al,cl
		out     dx,al            	;LSB of count
		mov     al,ch
		out     dx,al            	;MSB of count
		mov     al,Byte Ptr cs:_DMAChannel
		out     DMA_Mask,al          	;Enable DMA Channel
		cmp	Word Ptr cs:_Stereo,0
		je	NoStereo
		mov	ax,130eh                ;Stereo Output Command
		call	WriteMixer
 NoStereo:	mov     al,DMA_8bit_DAC 	;DMA 8-bit DAC function
		call    Sendcommand
		mov     al,cl           	;send LSB of count
		call    SendCommand
		mov     al,ch           	;send MSB of count
		call    SendCommand

		popa
		pop	bp
		ret
 _TransferDMA   Endp
;---------------------------------------------------------------------------;
;	void SetSampleRate( unsigned rate );			            ;
;---------------------------------------------------------------------------;
;Time Constant = 256 - 1,000,000 / rate

		Public	_SetSampleRate
 _SetSampleRate Proc 	near
		push	bp
		mov	bp,sp
		push	dx
		mov	dx,15
		mov	ax,16960
		div	Word Ptr [bp+4]
		mov     dx,256
		sub	dx,ax
		mov     al,Time_Constant
		call    SendCommand
		mov     al,dl
		call    SendCommand
		pop	dx
		pop	bp
		ret
 _SetSampleRate Endp
;---------------------------------------------------------------------------;
;	void HaltDMA( void );					  	    ;
;---------------------------------------------------------------------------;
		Public	_HaltDMA
 _HaltDMA 	Proc 	near
		mov     al,Halt_DMA
		call    SendCommand
		ret
 _HaltDma 	Endp
;---------------------------------------------------------------------------;
;	void ContinueDMA( void );					    ;
;---------------------------------------------------------------------------;
		Public	_ContinueDMA
 _ContinueDMA 	Proc 	near
		mov     al,Continue_DMA
		call    SendCommand
		ret
 _ContinueDma 	Endp
;---------------------------------------------------------------------------;
;	void TurnOnSpeaker( void );					    ;
;---------------------------------------------------------------------------;
		Public	_TurnOnSpeaker
 _TurnOnSpeaker Proc    near
		mov     al,Speaker_On
		call    SendCommand
		ret
 _TurnOnSpeaker Endp
;---------------------------------------------------------------------------;
;	void TurnOffSpeaker( void );					    ;
;---------------------------------------------------------------------------;
		Public	_TurnOffSpeaker
_TurnOffSpeaker Proc    near
		mov     al,Speaker_Off         ;turn off speaker
		call    Sendcommand
		ret
_TurnOffSpeaker Endp
;---------------------------------------------------------------------------;
; 	int  SB_Check( void );						    ;
;---------------------------------------------------------------------------;
		Public	_SB_Check
 _SB_Check	Proc
		mov	dx,cs:_SBIOAddr
		add	dx,DSP_Reset
		mov	al,1
		out	dx,al                   ;Wait a moment...
		in	al,dx
		in	al,dx
		in	al,dx
		in	al,dx
		mov	al,0
		out	dx,al
		mov	cx,100
		mov	dx,cs:_SBIOAddr
		add	dx,DSP_DataAvailable
 Wait_Data:	in	al,dx
		and	al,80h                  ;Test whether data is available
		cmp	al,0
		je	Reach
		loop	Wait_Data
		jmp	NoneSB
 Reach:		mov	dx,cs:_SBIOAddr
		add	dx,DSP_ReadData
		in	al,dx
		cmp	al,0aah                 ;ID of Sound Blaster
		je	SBfound
		loop	Wait_Data
 NoneSB:	mov	ax,False
		ret
 SBfound:	mov	ax,True
		ret
 _SB_Check 	Endp

		END

