/*  Ŀ
                            MicroGenesis Spell V1.2                   
                                                                      
                         Copyright 1991 by Jeff Heaton                
                                                                      
                Source code may not be distributed in any form.       
                                                                      
     */


/*	mgspell.h

	Defines structs, unions, macros, and functions for dealing
	with the MicroGenesis Spelling Checker.

	Copyright (c) Jeff Heaton 1990,1991
	All Rights Reserved.
*/
/* Include following line to produce shareware version */

/* #define SHAREWARE */


#include <stdio.h>
#include <windows.h>
#include <dir.h>

#ifndef __MGSPELL_H
#define __MGSPELL_H




typedef struct {
	long	index[26][26];
	long	words[26][26];
} 	INDEX;


typedef struct {
	FILE *fp;
	unsigned char bitpos;
	unsigned char curbyte;
}	DICT;


/* Variables */
extern  char           path_main[MAXPATH];
extern  char           path_user[MAXPATH];
extern	char 		suggest[10][30];
extern	char		lastword0[80];
extern	char		lastword1[80];
extern	INDEX		index;
extern int registered;

#ifdef __cplusplus
extern "C" {
#endif

/* IO.C */

void next_word	(DICT *fp,char *word);
void write_word	(DICT *fp,char *word);
void write_index	(FILE *fp);
void read_index	(FILE *fp);
void open_spell	(DICT *fp);
void s_seek	(DICT *fp, long position);
void s_putc	(DICT *fp, char chr);
char s_getc	(DICT *fp);

/* LOOKUP.C */
int PASCAL FAR _export spell_check	(char FAR *word);
int PASCAL FAR _export add_word(char FAR *word);
char fast_check(DICT *fp,char *word);


/* SUGGEST.C */
void PASCAL FAR _export suggest_word(char FAR *word);
int  comp	(char *word1, char *word2);
void PASCAL FAR _export suggestion(LPSTR s1,
	LPSTR s2,
	LPSTR s3,
	LPSTR s4,
	LPSTR s5,
	LPSTR s6,
	LPSTR s7,
	LPSTR s8,
	LPSTR s9,
	LPSTR s10);

/* MISC.C */
void	 inc	(int *dm1, int *dm2);
void	 dec	(int *dm1, int *dm2);
void	 scan_word(char *word);
long	 words	(int dm1, int dm2);
void	encode	(char *word);
void	 decode	(char *word);
void	 reset	(void);
void	 fgetstr	(FILE *fp,char *word);

/* WORD.C */


long PASCAL FAR _export word_count(void);

char   PASCAL FAR _export dump	(char FAR *name);
void   PASCAL FAR _export import	(void);
void PASCAL FAR _export reg(char FAR *str);


#ifdef  __cplusplus
}
#endif

#endif

