/******************************************************************************
* Module    :   Compiler include files, separated out to make configuration
*               different systems a little easier (I hate this, I really
*               hate this, but it has been requested, so here it is).
*
* Author    :   John W. M. Stevens
******************************************************************************/

#include    <stdio.h>
#include    <stdlib.h>
#include    <ctype.h>
#include    <errno.h>
#include    <string.h>

/*=============================================================================
*   Configure the program. . .
*
*   WARNING!  Be sure what you are doing here. . .
=============================================================================*/

/*  Debug macro.  Uncomment to get debug output.    */
/*	#define UNPOST_DEBUG    1	*/

/*  Uncomment to give you different file name munging under OS/2
*   on the basis of the File System.
*
*   Suggestions and help courtesy of:
*
*   Darrel R Hankerson <hankedr@mail.auburn.edu>
*
*   Without whose help and discussion, this would not have been done.
*   In other words, blame it all on him. . . :-)
*/
/*  #define     MUNGE_FILE_NAMES_PER_FS     1   */

/*  Change the one to a zero to make file name mungling default to
*   being off.
*/
#define     MUNGE_FILE_NMS      1

/*  Change the one to a zero to make description file dumping
*   default to being off.
*/
#define     DUMP_DESC_FILES     1

/*  Change zero to one to make incompletes separation be turned on
*   by default.
*/
#define     SEP_INCOMPLETES     0

/*-----------------------------------------------------------------------------
*   Compiler specific stuff below.
*
*   The first set is for the Lattice C compiler on the Amiga.
-----------------------------------------------------------------------------*/
#if     defined(LATTICE_C_COMPILER)

/*  Defines for fopen calls.    */
#define     TXT_APPEND  "at"
#define     TXT_READ    "rt"
#define     BIN_READ    "rb"
#define     TXT_WRITE   "wt"
#define     BIN_WRITE   "wb"

#define     SEEK_SET    0

/*-----------------------------------------------------------------------------
*   This set is for the GCC compiler on Unix systems.
-----------------------------------------------------------------------------*/
#elif   defined(GCC_COMPILER)

extern	char	*sys_errlist[];

#define	strerror(x)	sys_errlist[x]

/*  Defines for fopen calls.    */
#define     TXT_APPEND  "at"
#define     TXT_READ    "rt"
#define     BIN_READ    "rb"
#define     TXT_WRITE   "wt"
#define     BIN_WRITE   "wb"

#include    <malloc.h>
#include    <unistd.h>

/*-----------------------------------------------------------------------------
*   The GCC compiler on OS/2.
-----------------------------------------------------------------------------*/
#elif   defined(EMX_GCC_COMPILER)

/*  Defines for fopen calls.    */
#define     TXT_APPEND  "at"
#define     TXT_READ    "rt"
#define     BIN_READ    "rb"
#define     TXT_WRITE   "wt"
#define     BIN_WRITE   "wb"

#include    <sys/types.h>
#include    <sys/stat.h>

#if defined(SYSTEM_OS_2)
#define INCL_DOSFILEMGR
#include    <os2.h>
#else
#include    <dos.h>
#endif

#include    <malloc.h>
#include    <unistd.h>

/*-----------------------------------------------------------------------------
*   The IBM C Set++ compiler on OS/2.
*
* With thanks to: kevin@elvis.wicat.com
-----------------------------------------------------------------------------*/
#elif   defined(IBM_CSET_COMPILER)

/*  Defines for fopen calls.    */
#define     TXT_APPEND  "at"
#define     TXT_READ    "rt"
#define     BIN_READ    "rb"
#define     TXT_WRITE   "wt"
#define     BIN_WRITE   "wb"

#include    <sys/types.h>
#include    <sys/stat.h>

#if defined(SYSTEM_OS_2)
#define INCL_DOSFILEMGR
#include    <os2.h>
#else
#include    <dos.h>
#endif

#include    <malloc.h>

/*-----------------------------------------------------------------------------
*   The MSC compiler on OS/2.
-----------------------------------------------------------------------------*/
#elif   defined(OS_2_MSC_COMPILER)

/*  Defines for fopen calls.    */
#define     TXT_APPEND  "at"
#define     TXT_READ    "rt"
#define     BIN_READ    "rb"
#define     TXT_WRITE   "wt"
#define     BIN_WRITE   "wb"

#include    <sys/types.h>
#include    <sys/stat.h>

#if defined(SYSTEM_OS_2)
#define INCL_DOSFILEMGR
#include    <os2.h>
#else
#include    <dos.h>
#endif

/*-----------------------------------------------------------------------------
*   The BCC compiler on MS-DOS.
-----------------------------------------------------------------------------*/
#elif   defined(BCC_COMPILER)

#include    <io.h>

/*  Defines for fopen calls.    */
#define     TXT_APPEND  "at"
#define     TXT_READ    "rt"
#define     BIN_READ    "rb"
#define     TXT_WRITE   "wt"
#define     BIN_WRITE   "wb"

#include    <malloc.h>

/*-----------------------------------------------------------------------------
*   This set is for the CC compiler on VAX/VMS.
-----------------------------------------------------------------------------*/
#elif   defined(VMS)

/*  Defines for fopen calls.    */
#define     TXT_APPEND  "a"
#define     TXT_READ    "r"
#define     BIN_READ    "r"
#define     TXT_WRITE   "w"
#define     BIN_WRITE   "w"

/*-----------------------------------------------------------------------------
*   All others (Non-ANSI compatible).
-----------------------------------------------------------------------------*/
#else

/*  Defines for fopen calls.    */
#define     TXT_APPEND  "a"
#define     TXT_READ    "r"
#define     BIN_READ    "r"
#define     TXT_WRITE   "w"
#define     BIN_WRITE   "w"

#define	strerror	sys_errlist

#include    <malloc.h>

#endif
