/******************************************************************************
* Module    :   Identify a binary file.
*
* Author    :   John Stevens
******************************************************************************/

#include    "compiler.h"

#include    "ident.h"

/*  Define file type information for static storage.    */
typedef struct
{
    int             Offset;
    int             length;
    char            *string;
    char            ext[5];
    BIN_TYPES       FileType;
} FILE_TYPES;

static  FILE_TYPES  FileTypes[] =
{
    {   0,  6,  "GIF87a",   ".gif",     GIF87A          },
    {   0,  6,  "GIF89a",   ".gif",     GIF89A          },
    {   6,  4,  "JFIF",     ".jpg",     JFIF_JPEG       },
    {   0,  4,  "hsi1",     ".hsi",     HSI1_JPEG       },
    {   0,  0,  "",         "",         UNKNOWN_TYPE    }
};

/*-----------------------------------------------------------------------------
| Routine   :   IdUUFile() --- Identify a uuencoded binary file from it's
|               first line.  Currently this only works for graphics that
|               I have access to.
|
| Inputs    :   Bfr - Buffer containing first line.
|               Len - Number of bytes in buffer.
|               Ext - Pointer to extension buffer.
|
| Returns   :   Returns the file type.
-----------------------------------------------------------------------------*/

BIN_TYPES   IdUUFile(BYTE   *Bfr,
                     int    Len,
                     char   *Ext)
{
    register    int     i;
    register    int     j;
    auto        BYTE    *tp;

    /*  Run file types, looking for all listed types.   */
    *Ext = '\0';
    for (i = 0; FileTypes[i].length; i++)
    {
        /*  Make sure that there are enough bytes in the buffer
        *   to identify this file.
        */
        if (FileTypes[i].length + (int) FileTypes[i].Offset > Len)
            continue;

        /*  Compare the buffers.    */
        for (j = 0, tp = Bfr + FileTypes[i].Offset;
             j < FileTypes[i].length;
             j++)
            if (FileTypes[i].string[j] != (char) tp[j])
                break;

        /*  Check for file type found.  */
        if (j == FileTypes[i].length)
        {
            strcpy(Ext, FileTypes[i].ext);
            return( FileTypes[i].FileType );
        }
    }

    /*  Return type unknown.    */
    return( UNKNOWN_TYPE );
}
