
//------------------------------------------------------------------------------
// Copyright (c), David Welch, 1993
//------------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <alloc.h>
#include <string.h>
#include <mem.h>

void dspwrite ( unsigned char );
unsigned char dspread ( void );
void sbsetup ( void );
void sbsettc ( unsigned char );
void sbhaltdma ( void );
void sbplay ( unsigned short );
void sbrec ( unsigned short );
void spkon ( void );
void spkoff ( void );

unsigned char *data;
unsigned char *aligned;
unsigned long aligned_physical;
//------------------------------------------------------------------------------
void dspwrite ( unsigned char c )
{
    while(inportb(0x022C)&0x80);
    outportb(0x022C,c);
}
//------------------------------------------------------------------------------
unsigned char dspread ( void )
{
    while(!(inportb(0x22E)&0x80));
    return(inportb(0x22A));
}
//------------------------------------------------------------------------------
void sbsetup ( void )
{
    unsigned long physical;
    unsigned short x;
    data=farmalloc(131000L);
    if(data==NULL)
    {
        printf("Memory Allocation Error\n");
        exit(1);
    }
    physical=((unsigned long)FP_OFF(data))+(((unsigned long)FP_SEG(data))<<4);
    aligned_physical=physical+0x0FFFFL;
    aligned_physical&=0xF0000L;
    aligned=MK_FP((unsigned )((aligned_physical >> 4) & 0xFFFF),0);
    inportb(0x022E);
    outportb(0x0226,0x01);
    inportb(0x0226);
    inportb(0x0226);
    inportb(0x0226);
    inportb(0x0226);
    outportb(0x0226,0x00);
    for(x=0;x<100;x++)
    {
        if(inportb(0x022E)&0x80)
        {
            if(inportb(0x022A)==0xAA) break;
        }
    }
    if(x==100)
    {
        printf("Sound Blaster not found at 0220h\n");
        exit(1);
    }
}
//------------------------------------------------------------------------------
void sbsettc ( unsigned char tc )
// tc = time constant = 256L - (1000000UL/samples per second)
{
    inportb(0x022E);
    dspwrite(0x40);
    dspwrite(tc);
}
//------------------------------------------------------------------------------
void sbhaltdma ( void )
{
    dspwrite(0xD0);
}
//------------------------------------------------------------------------------
void spkon ( void )
{
    dspwrite(0xD1);
}
//------------------------------------------------------------------------------
void spkoff ( void )
{
    dspwrite(0xD3);
}
//------------------------------------------------------------------------------
void sbplay ( unsigned short len )
// len = number of bytes pointed to by unsigned char *aligned (<=65000)
{
    len--;
    outportb(0x0A,0x05);
    outportb(0x0C,0x00);
    outportb(0x0B,0x49);
    outportb(0x02,(unsigned char)(aligned_physical&0xFF));
    outportb(0x02,(unsigned char)((aligned_physical>>8)&0xFF));
    outportb(0x83,(unsigned char)((aligned_physical>>16)&0xFF));
    outportb(0x03,(unsigned char)(len&0xFF));
    outportb(0x03,(unsigned char)((len>>8)&0xFF));
    outportb(0x0A,0x01);
    dspwrite(0x14);
    dspwrite((unsigned char)(len&0xFF));
    dspwrite((unsigned char)((len>>8)&0xFF));
}
//------------------------------------------------------------------------------
void sbrec ( unsigned short len )
// len = number of bytes to record to unsigned char *aligned (<=65000)
{
    len--;
    outportb(0x0A,0x05);
    outportb(0x0C,0x00);
    outportb(0x0B,0x45);
    outportb(0x02,(unsigned char)(aligned_physical&0xFF));
    outportb(0x02,(unsigned char)((aligned_physical>>8)&0xFF));
    outportb(0x83,(unsigned char)((aligned_physical>>16)&0xFF));
    outportb(0x03,(unsigned char)(len&0xFF));
    outportb(0x03,(unsigned char)((len>>8)&0xFF));
    outportb(0x0A,0x01);
    dspwrite(0x24);
    dspwrite((unsigned char)(len&0xFF));
    dspwrite((unsigned char)((len>>8)&0xFF));
}
//------------------------------------------------------------------------------
unsigned short dmacount ( void )
{
    unsigned short x;
    x=inportb(0x03);
    x|=inportb(0x03)<<8;
    if(x==0xFFFF) inportb(0x022E);
    return(x);
}
//------------------------------------------------------------------------------
// Copyright (c), David Welch, 1993
//------------------------------------------------------------------------------

