(define (contains x y x1 y1 x2 y2)
  (and (> x x1) (< x x2) (> y y1) (< y y2)))

(define (demo )
  (window-title "newLISP - DEMO")
  (background 19)
  (show-menu nil)
  (demo-menu-draw)
  (mouse-down-event 'demo-menu-select)
  (paint-event 'demo-menu-draw))

(define (demo-menu-draw )
  (command-line true)
  (window-cursor 32512)
  (clear-screen)
  (rasterop 0)
  (scale 0 0)
  (brush-rgb 128 128 128)
  (pen 0 2 0)
  (text-font "Times" 24)
  (brush 3)
  (round-rect 350 50 550 100 30 30)
  (text 365 65 "Turtle graphics" 0 1)
  (brush 5)
  (round-rect 350 120 550 170 30 30)
  (text 365 135 "Dragon Curve" 0 1)
  (brush 6)
  (round-rect 350 190 550 240 30 30)
  (text 365 205 "Towers of Hanoi" 0 1)
  (brush 7)
  (round-rect 350 260 550 310 30 30)
  (text 365 275 "Sound" 0 1)
  (brush 12)
  (round-rect 70 190 180 240 30 30)
  (text 78 205 "Exit demo" 0 1)
  (text-font "Times New Roman" 36)
  (text 50 100 "Welcome to" 1)
  (text 65 130 "newLISP" 1))


(define (demo-menu-select )
  (paint-event 'nil)
  (mouse-down-event 'nil)
  (case 
   (get-mouse-selection 
    (mouse-x) 
    (mouse-y)) 
   ('turtle-demo 
     (load "turtle.lsp") 
     (rose-A) 
     (rose-B) 
     (demo))
   ('dragon-demo 
     (load "turtle.lsp") 
     (dragon-curve 12) 
     (demo))
   ('hanoi-demo 
     (load "hanoi.lsp") 
     (hanoi 6) 
     (demo))
   ('sound-demo 
     (load "mci.lsp") 
     (play-sound "c:\\windows\\tada.wav") 
     (demo))
   ('exit-demo 
     (mouse-down-event 'nil)
     (clear-screen) 
     (show-menu true)
     (window-title "newLISP")
     (print "Hit <enter> for system prompt"))
   (nil (demo))))

(define (get-mouse-selection x y)
  (cond 
   ((contains x y 350 50 550 100) 'turtle-demo) 
   ((contains x y 350 120 550 170) 'dragon-demo) 
   ((contains x y 350 190 550 240) 'hanoi-demo) 
   ((contains x y 350 260 550 310) 'sound-demo) 
   ((contains x y 70 190 180 240) 'exit-demo)))


(demo)

