;; simple drawing program demonstrating the use of mouse events and
;; how to program different cursor-shapes

(define (change-tool , color x y)
  (set 'x (mouse-x))
  (set 'y (mouse-y))
  (set 'color (/ 
    (- y 10) 
    30))
  (if (> x 29) (inc 'color 12))
  (if (< color 20) (begin 
    (rect 'set-brush color) 
    (brush color) 
    (rectangle 10 260 49 290))))

(define (contains x y x1 y1 x2 y2)
  (and (> x x1) (< x x2) (> y y1) (< y y2)))

(define (draw )
  (background 7)
  (draw-tools)
  (window-cursor 32515)
  (mouse-down-event 'mouse-down-handler)
  (mouse-move-event 'mouse-idle-handler)
  (paint-event 'draw-refresh)
  
  (command-line nil)
  (clear-screen))

(set 'draw-data '())

(define (draw-exit )
  (mouse-move-event 'nil)
  (mouse-down-event 'nil)
  (mouse-up-event 'nil)
  (paint-event 'nil)
  (command-line true)
  (clear-screen))

(define (draw-init-shape )
  (rect 'init (mouse-x) (mouse-y))
  (mouse-up-event 'mouse-up-handler)
  (mouse-move-event 'mouse-move-handler))

(define (draw-new )
  (set 'draw-data '())
  (clear-screen))

(define (draw-refresh , shape)
  (draw-tools)
  (dolist 
   (shape draw-data) 
   (brush 
    (nth 4 shape)) 
   (apply rectangle shape)))

(define (draw-tools , color offsetY)
  (set 'offsetY 10)
  (scale 0 0)
  (rasterop 0)
  (pen 0 0 0)
  (dolist 
   (color '
    (0 1 2 3 4 5 6 7)) 
   (brush color) 
   (rectangle 10 offsetY 30 
    (+ offsetY 31)) 
   (brush 
    (+ color 12)) 
   (rectangle 29 offsetY 49 
    (+ offsetY 31)) 
   (inc 'offsetY 30))
  (brush (rect 'get-brush))
  (rectangle 10 260 49 290)
  (brush 7)
  (text-font "Fixedsys" 0)
  (rectangle 10 300 49 325)
  (text 15 303 "exit")
  (rectangle 10 324 49 350)
  (text 15 327 "new"))

(define (mouse-down-handler , x y)
  (set 'x (mouse-x))
  (set 'y (mouse-y))
  (scale 0 0)
  (cond 
   ((contains x y 10 300 49 325) 
    (draw-exit)) 
   ((contains x y 10 324 49 350) 
    (draw-new)) 
   ((and (< x 50) (< y 250)) 
    (change-tool)) 
   (true 
    (draw-init-shape))))

(define (mouse-idle-handler )
  (if (< 
    (mouse-x) 
    50) 
   (window-cursor 32512) 
   (window-cursor 32515)))

(define (mouse-move-handler )
  (rect 'stretch (mouse-x) (mouse-y)))

(define (mouse-up-handler )
  (mouse-up-event 'nil)
  (mouse-move-event 'mouse-idle-handler)
  (rect 'draw)
  (rect 'draw-shape)
  (rect 'save-shape))

(define (rect procedure new-x new-y | x y x1 y1 color)
  (case procedure 
   ('init 
    (rect-init)) 
   ('stretch 
    (rect-stretch)) 
   ('draw 
    (rect-draw)) 
   ('draw-shape 
    (rect-draw-shape)) 
   ('save-shape 
    (rect-save-shape)) 
   ('set-brush 
    (set 'color new-x)) 
   ('get-brush 
    (if (= color nil) 19 color))))

(define (rect-draw )
  (line x y x1 y x1 y1 x y1 x y))

(define (rect-draw-shape )
  (if (= color nil) (set 'color 19))
  (rasterop 0)
  (brush color)
  (pen 0 0 0)
  (rectangle x y x1 y1))

(define (rect-init )
  (pen 0 0 0)
  (rasterop 6)
  (set 'x new-x)
  (set 'y new-y)
  (set 'x1 new-x)
  (set 'y1 new-y)
  (rect-draw))

(define (rect-save-shape )
  (push (list x y x1 y1 color) draw-data (length draw-data)))

(define (rect-stretch )
  (rect-draw)
  (set 'x1 (mouse-x))
  (set 'y1 (mouse-y))
  (rect-draw))

(draw)
