
;;
;;  Towers of Hanoi
;;  demonstrating complex graphics and recursion
;;


(define (delay n)
  (dotimes(x n)))

(define (draw-disk disk pole height , x width)
    (set 'x (case pole 
      ('pole1 21) 
      ('pole2 51) 
      ('pole3 81))) 
    (set 'width (+ 4 (* 2 disk))) 
    (set 'x (- x (/ width 2))) 
    (rectangle x height (+ x width) (+ height 4)))

(define (draw-pole-top pole , l x)
    (set 'x (case pole 
      ('pole1 20) 
      ('pole2 50) 
      ('pole3 80)))
    (set 'l (- 56 (* (length (eval pole)) 4))) 
    (pen 0 0 0) 
    (brush-rgb 128 128 0) 
    (rectangle x 60 (+ x 2) (- 60 l)))

(define (hanoi n)
  (if (> n 12) (set 'n 12))
  (setup-poles n)
  (text-font "Times New Roman" 24)
  (text 5 5 "Towers of Hanoi" 0)
  (move n 'pole1 'pole3 'pole2))

(define (move n from to with)
  (if (> n 0) (begin 
    (scale 100 -100) 
    (origin 0 100) 
    (move (- n 1) from with to) 
    (pull-disk n from) 
    (move-disk-over n from to) 
    (push-disk n to) 
    (move (- n 1) with to from))))

(define (move-disk-down n pole fromY toY , height)
    (set 'height fromY) 
    (while 
      (> height toY) 
      (pen 0 0 19) 
      (brush-rgb 255 255 255) 
      (draw-disk n pole height) 
      (draw-pole-top pole) 
      (pen 0 0 0) 
      (brush-rgb 255 0 0) 
      (draw-disk n pole (max 
        (- height 16) toY)) 
      (delay 1000) 
      (set 'height (- height 16))))

(define (move-disk-over n from to)
  (pen 0 0 0)
  (brush-rgb 255 0 0)
  (draw-disk n to 64)
  (pen 0 0 19)
  (brush-rgb 255 255 255)
  (draw-disk n from 64))

(define (move-disk-up n pole fromY toY , height)
    (set 'height fromY) 
    (while 
      (< height toY) 
      (pen 0 0 19) 
      (brush-rgb 255 255 255) 
      (draw-disk n pole height) 
      (draw-pole-top pole) 
      (pen 0 0 0) 
      (brush-rgb 255 0 0) 
      (draw-disk n pole (min 
        (+ height 16) toY)) 
      (delay 1000) 
      (set 'height (+ height 16))))

(define (pull-disk n pole)
  (pop (eval pole))
  (move-disk-up n pole (+ 
    (* 4 (length 
      (eval pole))) 4) 64))

(define (push-disk n pole)
  (move-disk-down n pole 64 (+ 
    (* 4 (length 
      (eval pole))) 4))
  (push n (eval pole)))

(define (setup-poles n)
  (set 'pole1 (set 'pole2 
    (set 'pole3 '())))
  (clear-screen)
  (row-column 1 2)
  (rasterop 0)
  (scale 100 -100)
  (origin 0 100)
  (pen 0 0 0)
  (brush-rgb 128 128 0)
  (rectangle 20 60 22 0)
  (rectangle 50 60 52 0)
  (rectangle 80 60 82 0)
  (round-rect 6 4 96 0 2 2)
  (pen 0 0 0)
  (brush-rgb 255 0 0)
  (while 
    (> n 0) 
    (push n pole1) 
    (draw-disk n 'pole1 (* 4 
      (length pole1))) 
    (set 'n (- n 1))))



