;;
;; extracts icons from .ICO, .EXE and .DLL files
;;
;; (icon X Y file-name icon-number)
;;
;; when passing 0 as the icon-number then 'icon'
;; returns the number of icons in the file.
;;

(define (draw-icons file-name)
  (clear-screen)
  (set 'count (icon 0 0 file-name 0))
  (while (> count 0) 
   (set 'x (+ (* (mod count 8) 40) 10)) 
   (set 'y (+ (*  (/ count 8) 40) 10)) 
   (icon x y file-name count) 
   (dec 'count)))

(define (mod x y)
  (- x (* 
    (/ x y) y)))

(draw-icons "progman.exe")


;; end of file
