;;
;; function to find out the host operating system
;;
(define (opsys )
  (cond 
   ((primitive? clear-screen) 'windows) 
   ((primitive? int86) (if (primitive? comm-read) 'dos 'extender))
   (true 'unix)))


;;
;; (setq x y) is equivalent to: (set 'x y) 
;;
(define-macro (setq p1 p2) 
    (set p1 (eval p2)))
    

;;
;; (edit functor) ; macro to edit a symbol (not required in MS Windos)
;; replace 'emacs' with your favourite editor
;;
(if (not(= (opsys) 'windows))
    (define-macro (edit functor)
        (if (not (= functor 'edit))
    	    (begin 
	        (save "edit.tmp" functor)
                (! "emacs edit.tmp")          
                (load "edit.tmp"))
            "Cannot edit myself !")))

;;
;; macro for 'defun' like in other Lisp's
;; usage: (defun foo (x y z) body1 body2 ... ) 
;;
;; Appends all the required stuff to an an empty lambda expression.
;; Note also the usage of 'args' to retrieve arguments which may
;; have been passed besides 'func-name' and 'arguments'.  In this case
;; it allows 'defun' to have several body1 ... expressions
;;
(define-macro (defun func-name arguments)
  (set func-name (append 
  	'(lambda ) 
	 (list arguments) 
    	 (rest (rest (args defun))))))

;;
;; macro for a function 'local for defining locals similar
;; to 'let in other Lisp's but without initilization
;;
;; (define (someFoo)
;;  (local (x y z)
;;         ...
;;         ... ))
;;
(define-macro (local var-list)
  ((append '(lambda ) (list var-list)  (rest (args local)))))


;;
;; load screen routines for DOS and UNIX
;;
(if (= (opsys) 'dos) (load "bios.lsp"))
(if (= (opsys) 'unix) (load "screen.lsp"))

(if (not(= (opsys) 'unix))
    (define (msdos-version)
	((lambda (version) 
          (set 'version (add (& version 0xFF) (div (>> version 8) 10)))
          (format "%3.1f" version)) 
         (& 0xFFFF (int86 0x21 0x3000 0 0 0)))))


        
;;
;; load other useful function definitions
;;
(load "math.lsp")

;;(if (= (opsys) 'windows)
;;	(begin
;;		(background 7)
;;		(console-font "LetterGothic" -14 4)))
		

;;;; end of file ;;;;


