/* getlogin for Novell + OS/2 */

/* by Frank Whaley */
/* further hacking by Paul Eggert and Kai Uwe Rommel */

	/* $Id: loginos2.c,v 1.2 1992/01/06 03:18:26 eggert Exp $ */

#include <string.h>

#define INCL_NOPM
#define INCL_DOS
#include <os2.h>

#define DOS_MODE	0
#define OS2_MODE	1
extern unsigned char _osmode;

/*
 * The OS/2 getlogin() calls functions located in the NWCALLS.DLL library
 * to fetch the default connection number, and the current connection status.
 * Because importing the functions directly would prevent the ececutables
 * from loading on systems without NetWare, me must link them in during
 * runtime manually with DosLoadModule/DosGetProcAddress/DosFreeModule.
 */

struct info {
	unsigned connectionID;
	unsigned connectFlags;
	unsigned sessionID;
	unsigned connectionNumber;
	char serverAddr[12];
	unsigned serverType;
	char serverName[48];
	unsigned clientType;
	char clientName[48];
};

typedef struct info far *PINFO;

	char *
getlogin()
{
	static struct info ci;

	USHORT (APIENTRY *NWGetDefaultConnectionID)(PUSHORT);
	USHORT (APIENTRY *NWGetConnectionStatus)(USHORT, PINFO, USHORT);
	HMODULE NWCalls;
	char buf[256];
	unsigned id;

	if (
	    _osmode != DOS_MODE &&
	    DosLoadModule(buf, sizeof(buf), "NWCALLS", &NWCalls) == 0
	) {
	    if (
		DosGetProcAddr(NWCalls,
			"NWGETDEFAULTCONNECTIONID",
			&NWGetDefaultConnectionID
		) == 0 &&
		DosGetProcAddr(NWCalls,
			"NWGETCONNECTIONSTATUS",
			&NWGetConnectionStatus
		) == 0 &&
		NWGetDefaultConnectionID(&id) == 0 &&
		NWGetConnectionStatus(id, &ci, sizeof(ci)) == 0
	    ) {
		strlwr(ci.clientName);
		return ci.clientName;
	    }
	    DosFreeModule(NWCalls);
	}

	return 0;
}
