(*******************************************************************)
(*                                                                 *)
(*                          Hot Tools                              *)
(* Tool:Dimmer                                                     *)
(* Zweck:Ein- und Ausblenden des Bildschirms                       *)
(* (C) Tronix 1994                                                 *)
(*******************************************************************)

UNIT Dimmer;

INTERFACE

TYPE FarbArray=ARRAY [0..44] OF BYTE;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE SetPalette256(FarbBytes:FarbArray);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE SetPalette16(FarbBytes:FarbArray);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE SetDemoColors;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerIn256;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerOut256;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerIn16;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerIn1to8(RestlFarben:BOOLEAN);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerIn9to15(RestlFarben:BOOLEAN);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerOut16;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerOut1to8(RestlFarben:BOOLEAN);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerOut9to15(RestlFarben:BOOLEAN);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)


IMPLEMENTATION

USES Graph,Crt,DOS;


VAR B:ARRAY [0..44] OF BYTE;
    Z:WORD;
    SOUND:BOOLEAN;
    regs:Registers;

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE SetPalette256(FarbBytes:FarbArray);

VAR Farbe:BYTE;
BEGIN
                              (* Interrupt:Mehrere DAC-Register setzen        *)
  regs.AH:=$10;               (* Interrupt Nummer 10H                         *)
  regs.AL:=$12;               (* Interrupt-Funktionsnummer                    *)
  regs.BX:=$1;                (* Nummer des ersten DAC-Registers              *)
  regs.CX:=$FF;               (* Anzahl der Register                          *)
  regs.ES:=Seg(FarbBytes);    (* Segment der Parameter-Tabelle Y              *)
  regs.DX:=Ofs(FarbBytes);    (* Offset der Parameter-Tabelle Y               *)
  Intr($10,regs);

  FOR Farbe:=1 TO 255 DO BEGIN
                              (* Interrupt:Einzelnes Paletten-Register setzen *)
    regs.AH:=$10;             (* Interrupt Nummer 10H                         *)
    regs.AL:=$0;              (* Interrupt-Funktionsnummer                    *)
    regs.BL:=Farbe;           (* Nummer des Paletten-Registers                *)
    regs.BH:=Farbe;           (* Farbwert (zugewiesenes DAC-Register)         *)
    Intr($10,regs);

  END;
END (*SetPalette256*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE SetPalette16(FarbBytes:FarbArray);

VAR Farbe:BYTE;
BEGIN

                              (* Interrupt:Mehrere DAC-Register setzen        *)
  regs.AH:=$10;               (* Interrupt Nummer 10H                         *)
  regs.AL:=$12;               (* Interrupt-Funktionsnummer                    *)
  regs.BX:=$1;                (* Nummer des ersten DAC-Registers              *)
  regs.CX:=$F;                (* Anzahl der Register                          *)
  regs.ES:=Seg(FarbBytes);    (* Segment der Parameter-Tabelle Y              *)
  regs.DX:=Ofs(FarbBytes);    (* Offset der Parameter-Tabelle Y               *)
  Intr($10,regs);

  FOR Farbe:=1 TO 15 DO BEGIN
                              (* Interrupt:Einzelnes Paletten-Register setzen *)
    regs.AH:=$10;             (* Interrupt Nummer 10H                         *)
    regs.AL:=$0;              (* Interrupt-Funktionsnummer                    *)
    regs.BL:=Farbe;           (* Nummer des Paletten-Registers                *)
    regs.BH:=Farbe;           (* Farbwert (zugewiesenes DAC-Register)         *)
    Intr($10,regs)

  END;
END (*SetPalette16*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE SetDemoColors;

VAR Farbe:BYTE;
BEGIN
    B[42]:=23;B[43]:=19;B[44]:=32;    (* Farbpalette mit den *)
    B[39]:=38;B[40]:=38;B[41]:=49;    (* Farbanteilen fr    *)
    B[36]:=60;B[37]:=63;B[38]:=26;    (* Rot, Grn und Blau  *)
    B[33]:=33;B[34]:=57;B[35]:=32;
    B[30]:=41;B[31]:=37;B[32]:=63;
    B[27]:=9;B[28]:=45;B[29]:=63;
    B[24]:=30;B[25]:=63;B[26]:=59;
    B[21]:=30;B[22]:=18;B[23]:=23;
    B[18]:=45;B[19]:=45;B[20]:=42;
    B[15]:=59;B[16]:=6;B[17]:=41;
    B[12]:=34;B[13]:=16;B[14]:=21;
    B[9]:=63;B[10]:=27;B[11]:=27;     (* usw.              *)
    B[6]:=56;B[7]:=42;B[8]:=42;       (* Werte fr Farbe 3 *)
    B[3]:=60;B[4]:=42;B[5]:=17;       (* Werte fr Farbe 2 *)
    B[0]:=59;B[1]:=57;B[2]:=42        (* Werte fr Farbe 1 *)
END (*SetDemoColors*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerIn256;

VAR Y:ARRAY [0..36864] OF BYTE;
    A,B:ARRAY [0..767] OF BYTE;
    S,P,H:WORD;
BEGIN
  FOR S:=0 TO 767 DO                  (* A[0]:=0, A[1]:=1, A[2]:=2, usw.     *)
    A[WORD(S)]:=S;

  H:=0;

  FOR S:=47 DOWNTO 0 DO               (* In dieser Schleife werden 48 Para-  *)
    FOR P:=0 TO 767 DO                (* metertabellen angelegt, wobei die   *)
      IF B[P]>S THEN Y[P+H]:=B[P]-S   (* einzelnen Werte der Farbanteile     *)
      ELSE Y[P+H]:=0;                 (* jeweils um eins grer werden.      *)
                                      (* Dabei ist darauf zu achten, da kein*)
                                      (* Wert kleiner als Null wird.         *)
    INC(H,768);                       (* Es werden insgesamt 48 Tabellen zu  *)
                                      (* je 256 Werten im Array Y angelegt   *)

  P:=0;
                              (* Interrupt:Alle Paletten-Register setzen      *)
  regs.AH:=$10;               (* Interrupt Nummer 10H                         *)
  regs.AL:=$2;                (* Interrupt-Funktionsnummer                    *)
  regs.ES:=Seg(A[0]);         (* Segment der Parameter-Tabelle Y              *)
  regs.DX:=Ofs(A[0]);         (* Offset der Parameter-Tabelle Y               *)
  Intr($10,regs);

  REPEAT
                              (* Interrupt:Mehrere DAC-Register setzen        *)
    regs.AH:=$10;             (* Interrupt Nummer 10H                         *)
    regs.AL:=$12;             (* Interrupt-Funktionsnummer                    *)
    regs.BX:=$1;              (* Nummer des ersten DAC-Registers              *)
    regs.CX:=$FF;             (* Anzahl der Register                          *)
    regs.ES:=Seg(Y[P]);       (* Segment der Parameter-Tabelle Y              *)
    regs.DX:=Ofs(Y[P]);       (* Offset der Parameter-Tabelle Y               *)
    Intr($10,regs);

    INC(P,768);               (* Die Parameter-Tabellen werden der Reihe nach *)
    Delay(17);                (* abgerufen. Sie liegen hintereinander in dem  *)
                              (* Feld Y.                                      *)

  UNTIL P>35282;
END (*DimmerIn256*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerOut256;

VAR Y:ARRAY [0..36864] OF BYTE;
    A,B:ARRAY [0..767] OF BYTE;
    S,P,H:WORD;
BEGIN
  FOR S:=0 TO 767 DO                  (* A[0]:=0, A[1]:=1, A[2]:=2, usw.     *)
    A[WORD(S)]:=S;

  H:=0;

  FOR S:=0 TO 47 DO                   (* In dieser Schleife werden 48 Para-  *)
    FOR P:=0 TO 767 DO                (* metertabellen angelegt, wobei die   *)
      IF B[P]>S THEN Y[P+H]:=B[P]-S   (* einzelnen Werte der Farbanteile     *)
      ELSE Y[P+H]:=0;                 (* jeweils um eins kleiner werden.     *)
                                      (* Dabei ist darauf zu achten, da kein*)
                                      (* Wert kleiner als Null wird.         *)
    INC(H,768);                       (* Es werden insgesamt 48 Tabellen zu  *)
                                      (* je 256 Werten im Array Y angelegt   *)

  P:=0;
                              (* Interrupt:Alle Paletten-Register setzen      *)
  regs.AH:=$10;               (* Interrupt Nummer 10H                         *)
  regs.AL:=$2;                (* Interrupt-Funktionsnummer                    *)
  regs.ES:=Seg(A[0]);         (* Segment der Parameter-Tabelle Y              *)
  regs.DX:=Ofs(A[0]);         (* Offset der Parameter-Tabelle Y               *)
  Intr($10,regs);

  REPEAT
                              (* Interrupt:Mehrere DAC-Register setzen        *)
    regs.AH:=$10;             (* Interrupt Nummer 10H                         *)
    regs.AL:=$12;             (* Interrupt-Funktionsnummer                    *)
    regs.BX:=$1;              (* Nummer des ersten DAC-Registers              *)
    regs.CX:=$FF;             (* Anzahl der Register                          *)
    regs.ES:=Seg(Y[P]);       (* Segment der Parameter-Tabelle Y              *)
    regs.DX:=Ofs(Y[P]);       (* Offset der Parameter-Tabelle Y               *)
    Intr($10,regs);

    INC(P,768);               (* Die Parameter-Tabellen werden der Reihe nach *)
    Delay(17);                (* abgerufen. Sie liegen hintereinander in dem  *)
                              (* Feld Y.                                      *)

  UNTIL P>35282
END (*DimmerOut256*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerIn16;

VAR Y:ARRAY [0..2745] OF BYTE;
    A:ARRAY [0..16] OF BYTE;
    S:BYTE;
    P,H:WORD;
BEGIN
  H:=0;

  FOR S:=60 DOWNTO 0 DO               (* In dieser Schleife werden 61 Para-  *)
    FOR P:=0 TO 44 DO                 (* metertabellen angelegt, wobei die   *)
      IF B[P]>S THEN Y[P+H]:=B[P]-S   (* einzelnen Werte der Farbanteile     *)
      ELSE Y[P+H]:=0;                 (* jeweils um eins kleiner werden.     *)
                                      (* Dabei ist darauf zu achten, da kein*)
                                      (* Wert kleiner als Null wird.         *)
    INC(H,45);                        (* Es werden insgesamt 61 Tabellen zu  *)
                                      (* je 45 Werten im Array Y angelegt    *)

  FOR S:=0 TO 15 DO                   (* A[0]:=0, A[1]:=1, A[2]:=2, usw.     *)
    A[WORD(S)]:=S;


  A[16]:=0;
  P:=0;
                              (* Interrupt:Alle Paletten-Register setzen      *)
  regs.AH:=$10;               (* Interrupt Nummer 10H                         *)
  regs.AL:=$2;                (* Interrupt-Funktionsnummer                    *)
  regs.ES:=Seg(A[0]);         (* Segment der Parameter-Tabelle Y              *)
  regs.DX:=Ofs(A[0]);         (* Offset der Parameter-Tabelle Y               *)
  Intr($10,regs);

  REPEAT
                              (* Interrupt:Mehrere DAC-Register setzen        *)
    regs.AH:=$10;             (* Interrupt Nummer 10H                         *)
    regs.AL:=$12;             (* Interrupt-Funktionsnummer                    *)
    regs.BX:=$1;              (* Nummer des ersten DAC-Registers              *)
    regs.CX:=$F;              (* Anzahl der Register                          *)
    regs.ES:=Seg(Y[P]);       (* Segment der Parameter-Tabelle Y              *)
    regs.DX:=Ofs(Y[P]);       (* Offset der Parameter-Tabelle Y               *)
    Intr($10,regs);

    INC(P,45);                (* Die Parameter-Tabellen werden der Reihe nach *)
    Delay(17);                (* abgerufen. Sie liegen hintereinander in dem  *)
                              (* Feld Y.                                      *)

  UNTIL P>2700;
END (*DimmerIn16*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerIn1to8(RestlFarben:BOOLEAN);

VAR Y:ARRAY [0..2745] OF BYTE;
    A:ARRAY [0..16] OF BYTE;
    S:BYTE;
    P,H:WORD;
BEGIN
  H:=0;

  FOR S:=60 DOWNTO 0 DO BEGIN         (* In dieser Schleife werden 61 Para-  *)
    FOR P:=0 TO 44 DO BEGIN                (* metertabellen angelegt, wobei die   *)
      IF P<24 THEN BEGIN              (* einzelnen Werte der Farbanteile     *)
        IF B[P]>S THEN Y[P+H]:=B[P]-S (* jeweils um eins kleiner werden.     *)
        ELSE Y[P+H]:=0;               (* Augenommen sind hier die Farbwerte *)
      END                             (* der Farben 9 bis 15. Sie bleiben    *)
      ELSE BEGIN
      IF RestlFarben THEN             (* gleich, wenn RestlFarben TRUE ist   *)
        Y[P+H]:=B[P]                  (* bzw. sind Null fr RestFarben=FALSE.*)
      ELSE Y[P+H]:=0                  (* Dabei ist darauf zu achten, da kein*)
      END;                            (* Wert kleiner als Null wird.         *)
    END;
    INC(H,45)                         (* Es werden insgesamt 61 Tabellen zu  *)
  END;                                (* je 45 Werten im Array Y angelegt    *)

  FOR S:=0 TO 15 DO                   (* A[0]:=0, A[1]:=1, A[2]:=2, usw.     *)
    A[WORD(S)]:=S;


  A[16]:=0;
  P:=0;
                              (* Interrupt:Alle Paletten-Register setzen      *)
  regs.AH:=$10;               (* Interrupt Nummer 10H                         *)
  regs.AL:=$2;                (* Interrupt-Funktionsnummer                    *)
  regs.ES:=Seg(A[0]);         (* Segment der Parameter-Tabelle Y              *)
  regs.DX:=Ofs(A[0]);         (* Offset der Parameter-Tabelle Y               *)
  Intr($10,regs);

  REPEAT
                              (* Interrupt:Mehrere DAC-Register setzen        *)
    regs.AH:=$10;             (* Interrupt Nummer 10H                         *)
    regs.AL:=$12;             (* Interrupt-Funktionsnummer                    *)
    regs.BX:=$1;              (* Nummer des ersten DAC-Registers              *)
    regs.CX:=$F;              (* Anzahl der Register                          *)
    regs.ES:=Seg(Y[P]);       (* Segment der Parameter-Tabelle Y              *)
    regs.DX:=Ofs(Y[P]);       (* Offset der Parameter-Tabelle Y               *)
    Intr($10,regs);

    INC(P,45);                (* Die Parameter-Tabellen werden der Reihe nach *)
    Delay(17);                (* abgerufen. Sie liegen hintereinander in dem  *)
                              (* Feld Y.                                      *)

  UNTIL P>2700;
END (*DimmerIn1to8*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerIn9to15(RestlFarben:BOOLEAN);

VAR Y:ARRAY [0..2745] OF BYTE;
    A:ARRAY [0..16] OF BYTE;
    S:BYTE;
    P,H:WORD;
BEGIN
  H:=0;

  FOR S:=60 DOWNTO 0 DO BEGIN         (* In dieser Schleife werden 61 Para-  *)
  FOR P:=0 TO 44 DO BEGIN             (* metertabellen angelegt, wobei die   *)
      IF P>23 THEN BEGIN              (* einzelnen Werte der Farbanteile     *)
        IF B[P]>S THEN Y[P+H]:=B[P]-S (* jeweils um eins grer werden.      *)
        ELSE Y[P+H]:=0                (* Augenommen sind hier die Farbwerte *)
      END                             (* der Farben 1 bis 8. Sie bleiben     *)
      ELSE BEGIN
      IF RestlFarben THEN             (* gleich, wenn RestlFarben TRUE ist   *)
        Y[P+H]:=B[P]                  (* bzw. sind Null fr RestFarben=FALSE.*)
      ELSE Y[P+H]:=0                  (* Dabei ist darauf zu achten, da kein*)
      END;                            (* Wert kleiner als Null wird.         *)
    END;
    INC(H,45)                         (* Es werden insgesamt 61 Tabellen zu  *)
  END;                                (* je 45 Werten im Array Y angelegt    *)

  FOR S:=0 TO 15 DO                   (* A[0]:=0, A[1]:=1, A[2]:=2, usw.     *)
    A[WORD(S)]:=S;


  A[16]:=0;
  P:=0;
                              (* Interrupt:Alle Paletten-Register setzen      *)
  regs.AH:=$10;               (* Interrupt Nummer 10H                         *)
  regs.AL:=$2;                (* Interrupt-Funktionsnummer                    *)
  regs.ES:=Seg(A[0]);         (* Segment der Parameter-Tabelle Y              *)
  regs.DX:=Ofs(A[0]);         (* Offset der Parameter-Tabelle Y               *)
  Intr($10,regs);

  REPEAT
                              (* Interrupt:Mehrere DAC-Register setzen        *)
    regs.AH:=$10;             (* Interrupt Nummer 10H                         *)
    regs.AL:=$12;             (* Interrupt-Funktionsnummer                    *)
    regs.BX:=$1;              (* Nummer des ersten DAC-Registers              *)
    regs.CX:=$F;              (* Anzahl der Register                          *)
    regs.ES:=Seg(Y[P]);       (* Segment der Parameter-Tabelle Y              *)
    regs.DX:=Ofs(Y[P]);       (* Offset der Parameter-Tabelle Y               *)
    Intr($10,regs);

    INC(P,45);                (* Die Parameter-Tabellen werden der Reihe nach *)
    Delay(17);                (* abgerufen. Sie liegen hintereinander in dem  *)
                              (* Feld Y.                                      *)

  UNTIL P>2700;
END (*DimmerIn9to15*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerOut16;

VAR Y:ARRAY [0..2745] OF BYTE;
    A:ARRAY [0..16] OF BYTE;
    S:BYTE;
    P,H:WORD;
BEGIN
  H:=0;
  FOR S:=0 TO 60 DO                   (* In dieser Schleife werden 61 Para-  *)
    FOR P:=0 TO 44 DO                 (* metertabellen angelegt, wobei die   *)
      IF B[P]>=S THEN Y[P+H]:=B[P]-S  (* einzelnen Werte der Farbanteile     *)
      ELSE Y[P+H]:=0;                 (* jeweils um eins kleiner werden.     *)
                                      (* Dabei ist darauf zu achten, da kein*)
                                      (* Wert kleiner als Null wird.         *)
    INC(H,45);                        (* Es werden insgesamt 61 Tabellen zu  *)
                                      (* je 45 Werten im Array Y angelegt    *)

  FOR S:=0 TO 15 DO                   (* A[0]:=0, A[1]:=1, A[2]:=2, usw.     *)
    A[WORD(S)]:=S;


  A[16]:=0;
  P:=0;
                              (* Interrupt:Alle Paletten-Register setzen      *)
  regs.AH:=$10;               (* Interrupt Nummer 10H                         *)
  regs.AL:=$2;                (* Interrupt-Funktionsnummer                    *)
  regs.ES:=Seg(A[0]);         (* Segment der Parameter-Tabelle Y              *)
  regs.DX:=Ofs(A[0]);         (* Offset der Parameter-Tabelle Y               *)
  Intr($10,regs);

  REPEAT
                              (* Interrupt:Mehrere DAC-Register setzen        *)
    regs.AH:=$10;             (* Interrupt Nummer 10H                         *)
    regs.AL:=$12;             (* Interrupt-Funktionsnummer                    *)
    regs.BX:=$1;              (* Nummer des ersten DAC-Registers              *)
    regs.CX:=$F;              (* Anzahl der Register                          *)
    regs.ES:=Seg(Y[P]);       (* Segment der Parameter-Tabelle Y              *)
    regs.DX:=Ofs(Y[P]);       (* Offset der Parameter-Tabelle Y               *)
    Intr($10,regs);

    INC(P,45);                (* Die Parameter-Tabellen werden der Reihe nach *)
    Delay(20);                (* abgerufen. Sie liegen hintereinander in dem  *)
                              (* Feld Y.                                      *)

  UNTIL P>2250;
END (*DimmerOut16*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerOut1to8(RestlFarben:BOOLEAN);

VAR Y:ARRAY [0..2745] OF BYTE;
    A:ARRAY [0..16] OF BYTE;
    S:BYTE;
    P,H:WORD;
BEGIN
  H:=0;
  FOR S:=0 TO 60 DO BEGIN             (* In dieser Schleife werden 61 Para-  *)
    FOR P:=0 TO 44 DO BEGIN           (* metertabellen angelegt, wobei die   *)
      IF P<24 THEN BEGIN              (* einzelnen Werte der Farbanteile     *)
        IF B[P]>=S THEN Y[P+H]:=B[P]-S(* jeweils um eins kleiner werden.     *)
        ELSE Y[P+H]:=0                (* Augenommen sind hier die Farbwerte *)
      END                             (* der Farben 9 bis 15. Sie bleiben    *)
      ELSE BEGIN
      IF RestlFarben THEN             (* gleich, wenn RestlFarben TRUE ist   *)
        Y[P+H]:=B[P]                  (* bzw. sind Null fr RestFarben=FALSE.*)
      ELSE Y[P+H]:=0                  (* Dabei ist darauf zu achten, da kein*)
      END;                            (* Wert kleiner als Null wird.         *)
    END;
    INC(H,45)                         (* Es werden insgesamt 61 Tabellen zu  *)
  END;                                (* je 45 Werten im Array Y angelegt    *)

  FOR S:=0 TO 15 DO                   (* A[0]:=0, A[1]:=1, A[2]:=2, usw.     *)
    A[WORD(S)]:=S;


  A[16]:=0;
  P:=0;
                              (* Interrupt:Alle Paletten-Register setzen      *)
  regs.AH:=$10;               (* Interrupt Nummer 10H                         *)
  regs.AL:=$2;                (* Interrupt-Funktionsnummer                    *)
  regs.ES:=Seg(A[0]);         (* Segment der Parameter-Tabelle Y              *)
  regs.DX:=Ofs(A[0]);         (* Offset der Parameter-Tabelle Y               *)
  Intr($10,regs);

  REPEAT
                              (* Interrupt:Mehrere DAC-Register setzen        *)
    regs.AH:=$10;             (* Interrupt Nummer 10H                         *)
    regs.AL:=$12;             (* Interrupt-Funktionsnummer                    *)
    regs.BX:=$1;              (* Nummer des ersten DAC-Registers              *)
    regs.CX:=$F;              (* Anzahl der Register                          *)
    regs.ES:=Seg(Y[P]);       (* Segment der Parameter-Tabelle Y              *)
    regs.DX:=Ofs(Y[P]);       (* Offset der Parameter-Tabelle Y               *)
    Intr($10,regs);

    INC(P,45);                (* Die Parameter-Tabellen werden der Reihe nach *)
    Delay(20);                (* abgerufen. Sie liegen hintereinander in dem  *)
                              (* Feld Y.                                      *)

  UNTIL P>2250;
END (*DimmerOut1to8*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE DimmerOut9to15(RestlFarben:BOOLEAN);

VAR Y:ARRAY [0..2745] OF BYTE;
    A:ARRAY [0..16] OF BYTE;
    S:BYTE;
    P,H:WORD;
BEGIN
  H:=0;
  FOR S:=0 TO 60 DO BEGIN             (* In dieser Schleife werden 61 Para-  *)
    FOR P:=0 TO 44 DO BEGIN           (* metertabellen angelegt, wobei die   *)
      IF P>23 THEN BEGIN              (* einzelnen Werte der Farbanteile     *)
        IF B[P]>=S THEN Y[P+H]:=B[P]-S(* jeweils um eins kleiner werden.     *)
        ELSE Y[P+H]:=0                (* Augenommen sind hier die Farbwerte *)
        END                           (* der Farben 1 bis 8. Sie bleiben     *)
      ELSE BEGIN
        IF RestlFarben THEN           (* gleich, wenn RestlFarben TRUE ist   *)
        Y[P+H]:=B[P]                  (* bzw. sind Null fr RestFarben=FALSE.*)
      ELSE Y[P+H]:=0                  (* Dabei ist darauf zu achten, da kein*)
      END;                            (* Wert kleiner als Null wird.         *)
    END;
    INC(H,45)                         (* Es werden insgesamt 61 Tabellen zu  *)
  END;                                (* je 45 Werten im Array Y angelegt    *)

  FOR S:=0 TO 15 DO                   (* A[0]:=0, A[1]:=1, A[2]:=2, usw.     *)
    A[WORD(S)]:=S;


  A[16]:=0;
  P:=0;
                              (* Interrupt:Alle Paletten-Register setzen      *)
  regs.AH:=$10;               (* Interrupt Nummer 10H                         *)
  regs.AL:=$2;                (* Interrupt-Funktionsnummer                    *)
  regs.ES:=Seg(A[0]);         (* Segment der Parameter-Tabelle Y              *)
  regs.DX:=Ofs(A[0]);         (* Offset der Parameter-Tabelle Y               *)
  Intr($10,regs);

  REPEAT
                              (* Interrupt:Mehrere DAC-Register setzen        *)
    regs.AH:=$10;             (* Interrupt Nummer 10H                         *)
    regs.AL:=$12;             (* Interrupt-Funktionsnummer                    *)
    regs.BX:=$1;              (* Nummer des ersten DAC-Registers              *)
    regs.CX:=$F;              (* Anzahl der Register                          *)
    regs.ES:=Seg(Y[P]);       (* Segment der Parameter-Tabelle Y              *)
    regs.DX:=Ofs(Y[P]);       (* Offset der Parameter-Tabelle Y               *)
    Intr($10,regs);

    INC(P,45);               (* Die Parameter-Tabellen werden der Reihe nach *)
    Delay(20);               (* abgerufen. Sie liegen hintereinander in dem  *)
                             (* Feld Y.                                      *)

  UNTIL P>2250;
END (*DimmerOut9to15*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

END (*Dimmer*).
