(*******************************************************************)
(*                                                                 *)
(*                          Hot Tools                              *)
(* Tool:GrafText                                                   *)
(* Zweck:Anzeigen von Strings im Grafik-Modus                      *)
(* (C) Tronix 1994                                                 *)
(*******************************************************************)

UNIT GrafText;

INTERFACE


(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE PlotStr(x,y:INTEGER;str:String; color,speed,colstep:WORD);

(*Zeichnet eine Zeichenkette gem der Attribute (siehe folgende
  Prozeduren).
  x,y:Koordinatenursprung des Strings {0..639},{0..479}
  str:Anzuzeigende Zeichenkette
  color:Farbe der Zeichenkette {0..15}
  speed:Geschwindigkeit, mit der die Zeichenkette ausgegeben werden
        soll {0..100}
  colstep:Ein Attribut zur Farbnderung whrend der Ausgabe {-15..15}
         -32..-25:Die Farbe ndert sich innerhalb jedes Zeichens
         -24..-17:Die Farbe ndert sich innerhalb jedes Zeichens
                  mehrmals
         -16..-10:Die Farbe ndert sich innerhalb jedes Zeichens
                  sehr oft
           -8..-1:Die Farbe ndert sich von Pixel zu Pixel
                0:Keine Farbnderungen
            1..15:Die Farbe ndert sich von Zeichen zu Zeichen
          Der Betrag der Zahl ist ein Ma dafr, um wieviel Farbregister
          innerhalb der Farbpalette gesprungen wird.

  Fr ASCII > 127 mu im DOS GRAFTABL geladen sein, sonst werden
  alle Zeichen durch '*' ersetzt! *)

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE PlotStrFast(x,y:INTEGER;str:String;color,colstep:WORD);

(*Zeichnet wie PlotStr eine Zeichenkette, jetzt aber mit festen
  Parametern. Es lassen sich nur color und colstep variieren.
  Die Prozedur ist deswegen wesentlich schneller, da alle Werte,
  die berechnet werden mssen, bereits in die Prozedur geschrieben
  wurden.*)

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE PlotStrFast2(x,y:INTEGER;str:String;color,colstep:WORD);

(*Zeichnet wie PlotStr eine Zeichenkette, jetzt aber mit festen
  Parametern. Es lassen sich nur color und colstep variieren.
  Die Prozedur ist deswegen wesentlich schneller, da alle Werte,
  die berechnet werden mssen, bereits in die Prozedur geschrieben
  wurden.*)

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharSize(CHeight,CWeight:WORD;CSpace:INTEGER);

(*Prozedur zum Festlegen der Gre der einzelnen Zeichen und deren Abstand
  zueinander.
  CHeight:Hhe der Zeichen {1..50}
  CWeight:Breite der Zeichen {1..50}
  CSpace:Abstand zwischen den Zeichen {-10..10}
         -10...0:Abstand geringer als normal
          0...10:Abstand grer als normal     *)

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharType(CItal,CSlope:INTEGER;xCBold,yCBold:INTEGER);

(*Prozedur zum Festlegen des Zeichen-Typs.
  CItal:Verndert die Neigung in x-Richtung {-5..5}
        -5..-1:Schreibt negativ-kursiv
             0:Schreibt normal
          1..5:Schreibt kursiv
  CSlope:Verndert die Neigung in y-Richtung {-5..5}
         -5..-1:Schreibt negativ-kursiv in y-Richtung
              0:Schreibt normal
           1..5:Schreibt kursiv in y-Richtung
  xBold:Gibt an, wie fett oder dnn die Zeichen in x-Richtung geschrieben
        werden {-CHeight..5}
        -CHeight+1..-1:dnn
                     0:normal
                  1..5:dick
  yBold:Gibt an, wie fett oder dnn die Zeichen in y-Richtung geschrieben
        werden (s.o)

        Die negativen Werte drfen betragsmig nicht grer sein
        als die entsprechenden Werte fr die Gre. Ein Zeichen der
        Gre CHeight=1 kann also nicht in x-Richtung dnn angezeigt
        werden. Es gilt fr xBold<0:  xBold>-CHeight+1
                    und fr yBold<0:  yBold>-CWeight+1       *)

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharEffect(xCStripe,yCStripe,xCSharp,yCSharp,xCSpike,yCSpike:INTEGER);

(*Prozedur fr spezielle grafische Effekte.
  xCStripe:Dicke der Streifen in x-Richtung {-5..5}
           -5..-1:Negative Streifen, d.h. die einzelnen Zeichen werden
                  "gedrngt" geschrieben. hnlicher Effekt wie bei
                  negativen xBold- und yBold-Werten.
                0:Kein Effekt
             1..5:Streifen
  yCStripe:Dicke der Streifen in y-Richtung (s.o);
  xCSharp:Unschrfe der Zeichen in x-Richtung {-5..5}
  yCSharp:Unschrfe der Zeichen in y-Richtung {-5..5}
  xCSpike:Erzeugt Zacken-Effekt in x-Richtung {-5..5}
  yCSpike:Erzeugt Zacken-Effekt in y-Richtung {-5..5}

  Die Art der Effekte kann man im Demo TestText genauer betrachten.
  Werden mehrere Effekte kombiniert, entstehen sehr bizarre Schriftformen.  *)

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharCut(CBottom,CTop,CLeft,CRight:WORD);

(*Prozedur zum Abschneiden der Zeichen.
  CBottom:Schneiden die Zeichen unten ab {0..3}
  CTop:Schneidet die Zeichen oben ab {0..3}
  CLeft:Schneidet die Zeichen links ab {0..3}
  CRight:Schneidet die Zeichen rechts ab {0..3}

  Auch hier gilt das gleiche wie bei CharEffekt. TestText anschauen und
  einfach experimentieren!                                                 *)

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharSound(CFreq,CSpeed,CMusic:WORD);

(*Prozedur zur Erzeugung von Musik-Effekten whrend der Zeichenausgabe.
  CFreq:Frequenz des Effektes {10..3000}
  CSpeed:Dauer der Klnge {0..20}
  CMusic:Musikeffekt {0..10}  0:Kein MusikEffekt                            *)

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharInit;

(*Prozedur zum Initialisieren aller Attribute. Mu vor dem Aufruf von
  PlotStr aufgerufen werden!*)

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)


IMPLEMENTATION

USES Graph,DOS,Crt;

TYPE SHORTBITSET=SET OF 0..7;
     BITARRAY=ARRAY [0..7] OF SHORTBITSET;

VAR Adress,AdressASCII,AdressExtASCII: RECORD CASE WORD OF
                                 0: (A       :^WORD);
                                 1: (P       :^BITARRAY);
                                 2: (Off,Seg :WORD);
                              END;

    SlowDown,ExtASCII,SoundOn                                        :BOOLEAN;
    chH,chW,CharItalics,xCharStripes,yCharStripes,CharSlope,xBold,
    yBold,xCharSharp,yCharSharp,xCharSpike,yCharSpike,CharLength,Freq:INTEGER;
    CharBottom,CharTop,CharLeft,CharRight,xSpace,
    Music,SoundSpeed,CharSpeed,Wait                                  :WORD;


(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE PlotStr(x,y:INTEGER;str:String;color,speed,colstep:WORD);

  VAR pixels     :BITARRAY;
      m,ordCh,i,j,k,l,xa,Plotx,Ploty:INTEGER;
      changecol:WORD;
BEGIN
  changecol:=color;
  IF speed>0 THEN SlowDown:=TRUE ELSE SlowDown:=FALSE;
  CharLength:=Length(str);
  FOR m:=0 TO CharLength-1 DO     (*    Schleife, um die einzelnen Buchstaben*)
    BEGIN                         (*    zu zeichnen                          *)
                                  (*    Block Buchstaben zeichnen **Anfang** *)
    IF (colstep>64) THEN                      (* Falls colstep grer als 64 *)
      changecol:=changecol+colstep-64;        (* wird es um 64 verkleinert   *)
                                              (* und an changecol bergeben  *)

    IF (changecol<17) AND (changecol>0) THEN  (* Farbe wird von Buchstabe    *)
      changecol:=color;                       (* zu Buchstabe gendert       *)


    ordCh:=ORD(str[m]);
    Plotx:=x+chW*7;
    Ploty:=y-chH*7;
    xa:=Plotx;

                                  (*    Block ASCII lesen **Anfang**         *)
    IF (ordCh>127) AND NOT ExtASCII THEN
      ordCh:=ORD('*');

    IF (ordCh<=127) THEN BEGIN
      Adress.Seg:=AdressASCII.Seg;
      Adress.Off:=AdressASCII.Off+WORD(ordCh)*8;
      END
    ELSE
      Adress.Seg:=AdressExtASCII.Seg;
      Adress.Off:=AdressExtASCII.Off+(WORD(ordCh)-128)*8;

    pixels:=Adress.P^;
                                  (*    Block ASCII lesen **Ende**           *)

    FOR k:=1 TO chH+xBold DO      (*    Schleife fr Buchstabenhhe          *)
      BEGIN

      IF SoundOn THEN             (*    Sound 5,6 und 7                      *)
        CASE Music OF
          5:BEGIN IF ODD(m) THEN Sound(m*Freq) ELSE Sound(m*Freq+300);
            Delay(3*SoundSpeed);NoSound;END;
          6:BEGIN Sound(Freq*4-k*Freq);Delay(3*SoundSpeed);NoSound;END;
          7:BEGIN Sound(RANDOM(Freq*30)+100);Delay(3*SoundSpeed);NoSound;END;
        END;

      FOR l:=1 TO chW+yBold DO    (*    Schleife fr Buchstabenbreite        *)
        BEGIN

        IF SoundOn THEN           (*    Sound 5,6 und 7                      *)
          CASE Music OF
            8:BEGIN Sound((Freq DIV 10)*k*k*k*l);Delay(SoundSpeed);
              NoSound;END;
            9:BEGIN Sound(ABS((ordCh-64)*(Freq DIV 2)-k*120));
              Delay(SoundSpeed);NoSound;END;
           10:BEGIN Sound(RANDOM(Freq)*WORD(k)*WORD(l));
              Delay(SoundSpeed);NoSound;END;
          END;

        FOR j:=CharTop TO 7-CharBottom DO     (* Schleife fr vertikale Pixel*)
          BEGIN

          IF SlowDown THEN Delay(speed);

          FOR i:=CharRight TO 7-CharLeft DO   (* Schleife fr horizont. Pixel*)
            BEGIN

            IF (BYTE(i) IN pixels[j]) THEN

                                  (*    eigentlicher Zeichnen-Befehl         *)
              PutPixel(Plotx-i*chW-(j*CharItalics DIV 2)-
                   (i*yCharStripes DIV 2)+l*xCharSharp+k*xCharSpike,
                   Ploty+j*chH+(j*xCharStripes DIV 2)+CharSlope*i
                   +l*yCharSharp+k*yCharSpike,changecol);
                                  (*die Buchstaben werden pixelweise gebildet*)

            IF (colstep>0) AND (colstep<17) THEN
              INC(changecol,colstep);

            END;                                  (* Hier wird je nach Gre *)
          IF (colstep>16) AND (colstep<33) THEN   (* von colstep die Farbe   *)
            INC(changecol,colstep-16);            (* gewechselt. Die unter-  *)
                                                  (* schiedlichen Effekte    *)
        END;                                      (* resultieren aus der     *)
        IF (colstep>32) AND (colstep<49) THEN     (* unterschiedlichen Posi- *)
          INC(changecol,colstep-32);              (* tion des Befehls INC.   *)
                                                  (* Er befindet sich jeweils*)
        INC(Plotx);                               (* vor dem Ende einer der  *)
      END;                                        (* Schleifen fr das       *)
      IF (colstep>48) AND (colstep<65) THEN       (* Zeichnen der Buchstaben.*)
        INC(changecol,colstep-48);                (* Je nach Position wird   *)
                                                  (* die Farbe verschieden   *)
      Plotx:=xa;                                  (* oft gewechselt          *)
      INC(Ploty);
    END;

    IF (colstep>64) THEN                          (* Hiermit wird vermieden, *)
      changecol:=changecol+colstep-64;            (* da die Variable change-*)
                                                  (* col berlaufen kann.    *)

                                  (*    Block Buchstaben zeichnen **Ende**   *)

    IF SoundOn THEN               (*    Sound 1,2,3 und 4                    *)
      CASE Music OF
       1:BEGIN Sound(Freq*2+20);Delay(5*SoundSpeed);
         NoSound;Delay(5*SoundSpeed);END;
       2:BEGIN Sound(Freq*20-m*Freq+100);
         Delay(5*SoundSpeed);NoSound;END;
       3:BEGIN Sound(RANDOM(Freq*20)+10);
         Delay(5*SoundSpeed);NoSound;END;
       4:BEGIN Sound(RANDOM(m*50)+WORD(Freq)*2);
         Delay(5*SoundSpeed);NoSound;END;
      END;

    INC(x,xSpace);                (*    Abstand zum nchsten Buchstaben      *)
    changecol:=color;
  END;
  changecol:=0;colstep:=0;
END (*PlotStr*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE PlotStrFast(x,y:INTEGER;str:String;color,colstep:WORD);

  VAR pixels     :BITARRAY;
      m,ordCh,i,j,k,l,xa,Plotx,Ploty:INTEGER;
      changecol:WORD;
BEGIN
  changecol:=color;
  xSpace:=28;

  FOR m:=0 TO Length(str)-1 DO
    BEGIN
                                  (*    Block Buchstaben zeichnen **Anfang** *)
    ordCh:=ORD(str[m]);
    Plotx:=x+21;
    Ploty:=y-21;
    xa:=Plotx;
                                  (*    Block ASCII lesen **Anfang**         *)


   {IF (ordCh>127) AND NOT ExtASCII THEN (* wenn keine Buchstaben des        *)
      ordCh:=ORD('*');}                  (* erweiterten ASCII-Modus verwendet*)
                                         (* werden, kann dieser Block        *)
                                         (* ausgeklammert werden             *)


    (***IF (ordCh<=127) THEN***)
      Adress.Seg:=AdressASCII.Seg;       (* die IF-Anweisung bentigen Sie,  *)
      Adress.Off:=AdressASCII.Off        (* falls Sie Buchstaben aus dem     *)
      +WORD(ordCh)*8;                    (* erweiterten ASCII-Modus bentigen*)
   {ELSE
      Adress.Seg:=AdressExtASCII.Seg;    (* diese Zeilen holen die Buchstaben*)
      Adress.Off:=AdressExtASCII.Off     (* aus dem erweiterten ASCII-Modus  *)
      +(WORD(ordCh)-128)*8
    END;}

    pixels:=Adress.P^;
                                  (*    Block ASCII lesen **Ende**           *)
    FOR k:=1 TO 2 DO
      FOR l:=1 TO 2 DO                            (* Aufgrund der fest vorge-*)
        FOR j:=0 TO 7 DO                          (* gebenen Variablen ver-  *)
          FOR i:=0 TO 7 DO                        (* krzt sich der Quellcode*)
            IF (BYTE(i) IN pixels[j]) THEN        (* enorm und die Prozedur  *)
              PutPixel(Plotx-i*3+l,               (* luft sprbar schneller *)
                    Ploty+j*3-l,changecol);       (* ab.                     *)


        IF colstep>0 THEN                         (* Hier wird die Farbe in  *)
          INC(changecol,8);                       (* der Schleife fr die    *)
                                                  (* Breite (Var l) gendert.*)
         INC(Plotx);

      Plotx:=xa;
      INC(Ploty);
                                  (*    Block Buchstaben zeichnen **Ende**   *)
    INC(x,xSpace);                (*    Abstand zum nchsten Buchstaben      *)
  END;
END (*PlotStrFast*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE PlotStrFast2(x,y:INTEGER;str:String;color,colstep:WORD);

  VAR pixels     :BITARRAY;
      m,ordCh,i,j,k,l,xa,Plotx,Ploty:INTEGER;
      changecol:WORD;
BEGIN
  changecol:=color;
  xSpace:=22;
  FOR m:=0 TO Length(str)-1 DO    (*    Block Buchstaben zeichnen **Anfang** *)
    BEGIN

    ordCh:=ORD(str[m]);
    Plotx:=x+14;
    Ploty:=y-14;
    xa:=Plotx;
                                  (*    Block ASCII lesen **Anfang**         *)
    IF (ordCh>127) AND NOT ExtASCII THEN
      ordCh:=ORD('*');

    IF (ordCh<=127) THEN BEGIN                    (* Hier wurde die Abfrage  *)
      Adress.Seg:=AdressASCII.Seg;                (* fr erweiterten ASCII-  *)
      Adress.Off:=AdressASCII.Off                 (* Modus belassen. In      *)
      +WORD(ordCh)*8;
      END                                         (* PlotStrFast ist Sie     *)
    ELSE BEGIN                                    (* ausgeklammert.          *)
      Adress.Seg:=AdressExtASCII.Seg;             (* Werden also aus dem er- *)
      Adress.Off:=AdressExtASCII.Off              (* weiterten ASCII-Modus   *)
      +(WORD(ordCh)-128)*8                        (* keine Zeichen bentigt, *)
    END;                                          (* kann es auch hier ausge-*)
                                                  (* klammert werde, um Zeit *)
                                                  (* zu sparen.              *)
    pixels:=Adress.P^;
                                  (*    Block ASCII lesen **Ende**           *)
    FOR k:=1 TO 2 DO
      FOR l:=1 TO 2 DO                            (* Aufgrund der fest vorge-*)
        FOR j:=0 TO 7 DO                          (* gebenen Variablen ver-  *)
          FOR i:=0 TO 7 DO                        (* krzt sich der Quellcode*)
            IF (BYTE(i) IN pixels[j]) THEN        (* enorm und die Prozedur  *)
              PutPixel(Plotx-i*2-j DIV 2,         (* luft sprbar schneller *)
                    Ploty+j*2-k,changecol);       (* ab.                     *)

        IF colstep>0 THEN                         (* Hier wird die Farbe in  *)
          INC(changecol,8);                       (* der Schleife fr die    *)
                                                  (* Breite (Var l) gendert.*)
         INC(Plotx);

      Plotx:=xa;
      INC(Ploty);
                                  (*    Block Buchstaben zeichnen **Ende**   *)
    INC(x,xSpace);                (*    Abstand zum nchsten Buchstaben      *)
  END;
END (*PlotStrFast2*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharSize(CHeight,CWeight:WORD;CSpace:INTEGER);

BEGIN
  chH:=CHeight;                   (* Werte mssen nur an globale Variablen   *)
  chW:=CWeight;                   (* bergeben werden                        *)
  xSpace:=WORD(TRUNC(             (* Hier wird der Abstand zwischen den      *)
          chH*chW*                (* Zeichen in Abhngigkeit von Breite und  *)
          8.0*(CSpace/            (* Hhe und der whlbaren Variable CSpace  *)
          10.0+1.0)));            (* berechnet.                              *)
END (*CharSize*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharType(CItal,CSlope:INTEGER;xCBold,yCBold:INTEGER);

BEGIN
  CharItalics:=CItal;
  CharSlope:=CSlope;              (* Werte mssen nur an globale Variablen   *)
  xBold:=xCBold;                  (* bergeben werden                        *)
  yBold:=yCBold;
END (*CharType*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharEffect(xCStripe,yCStripe,xCSharp,yCSharp,xCSpike,yCSpike:INTEGER);

BEGIN
  xCharStripes:=xCStripe;
  yCharStripes:=yCStripe;
  xCharSharp:=xCSharp;            (* Werte mssen nur an globale Variablen   *)
  yCharSharp:=yCSharp;            (* bergeben werden                        *)
  xCharSpike:=xCSpike;
  yCharSpike:=yCSpike;
END (*CharEffect*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharSound(CFreq,CSpeed,CMusic:WORD);
BEGIN
  Freq:=CFreq;                    (* Werte mssen nur an globale Variablen   *)
  SoundSpeed:=CSpeed;             (* bergeben werden                        *)
  Music:=CMusic;
  IF CMusic>0 THEN
    SoundOn:=TRUE ELSE SoundOn:=FALSE;

END (*CharSound*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharCut(CBottom,CTop,CLeft,CRight:WORD);

BEGIN
  CharBottom:=CBottom;
  CharTop:=CTop;                  (* Werte mssen nur an globale Variablen   *)
  CharLeft:=CLeft;                (* bergeben werden                        *)
  CharRight:=CRight;
END (*CharCut*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

PROCEDURE CharInit;

BEGIN
  CharItalics:=0;                 (* Initialisieren aller globalen Variablen,*)
  CharSlope:=0;                   (* d.h. alle globalen Variablen erhalten   *)
  xCharStripes:=0;                (* Standardwerte.                          *)
  yCharStripes:=0;
  xCharSharp:=0;
  yCharSharp:=0;                  (* Diese Prozedur mu vor dem Benutzen     *)
  xCharSpike:=0;                  (* der Prozeduren PlotStr oder PlotStrFast *)
  yCharSpike:=0;                  (* aufgerufen werden. Sonst haben alle     *)
  CharBottom:=0;                  (* globalen Variablen unbestimmte Werte!   *)
  CharTop:=0;
  CharLeft:=0;
  CharRight:=0;
  Freq:=0;
  SoundSpeed:=0;
  Music:=0;
  CharSpeed:=0;
  SlowDown:=FALSE;
  chH:=1;
  chW:=1;
  xSpace:=8;
  xBold:=0;
  yBold:=0;
END (*CharInit*);

(*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*)

BEGIN

  AdressASCII.Seg:=$F000; AdressASCII.Off:=$FA6E;
  Adress.Seg:=$0; Adress.Off:=$7E;           (* Initialisierung der     *)
  AdressExtASCII.Seg:=Adress.A^;             (* Variablen und Zeiger    *)
  Adress.Off:=$7C;
  AdressExtASCII.Off:=Adress.A^;

  IF (AdressExtASCII.Off=0) AND (AdressExtASCII.Seg=0) THEN
    ExtASCII:=FALSE               (* berprfen, ob erweiterte ASCII-Tabelle *)
      ELSE                        (* geladen, d.h. ob die Pixelmatrizen fr  *)
    ExtASCII:=TRUE;               (* ORD>127 vorhanden sind.                 *)

END (*GrafText*).