// GLOBAL DEFINITIONS

#ifndef _GLOBAL_H
#define _GLOBAL_H

// DEBUG

//#define SBSUPPORT // 1 - whether SB should be supported
#define FILLMASKOK // 0 - make fillmask? (not currently supported)
#define HISCOREFILTER  // 1 - should homemade-levels give hiscores?
#define QUICK // 0 - skips some menus
//#define BLANKHISCORE // 0 - blanks hiscore on initialization
//#define REALLIMITS // 1 - whether the player should be limited to levels
	// he has completed
#define ALLOWHOMEMADE // 0 - should homemade levels be allowed in
	// linkup-game?
//#define STRIPPED // 0 - no undo feature in editor
//#define UNFINISHED // 0
//#define NOMODEM	// 0
//#define BOSS // 0
//#define JOYDEFAULT // 0
#define DEBUG // 0
#define FREEZE asm push es;asm pusha; getch(); asm popa; asm pop es

#define ALIGNX // 1 - should the player automatically be x-aligned
#define HANGON // ? - is it possible to eat blocks suspended in thin air?
#define EASYFLYING // ? - should jetpack hang still in the air?
#define COPYPLAYER // ? - should the duplicators copy the players?

// FIXED DEFINES ////////////////////////////////////////////////////////////

#define VGAINT		 geninterrupt(0x10)
#define DOSINT     geninterrupt(0x21)
#define MOUSEINT	 geninterrupt(0x33)

#define VERBIT     1024
#define MAXKEYS		 128

#define XRES       320
#define YRES       240

//#define NPA        "That's all folks!      " // 23

#define GRAFOFF    (10*XRES/4)    // default start of visible page (vram)

#define READ       1
#define WRITE      2

#define ON				 1
#define OFF        0

#define AC_INDEX        0x03c0		// VGA-registers
#define MISC_OUTPUT     0x03c2
#define SC_INDEX        0x03c4
#define GC_INDEX				0x03ce
#define CRTC_INDEX      0x03d4
#define INPUT_STATUS_0  0x03da
#define MAP_MASK				0x02
#define READ_MAP        0x04
#define BIT_MASK				0x08

#define LCTRL    100
#define RCTRL    101
#define LALT     102
#define RALT     103
#define NUMON    120
#define CAPSON   121
#define SCROLLON 122
#define INSON    123

#define _LSHIFT  0x02
#define _CAPSON  0x40
#define _LCTRL   0x0100
#define _LALT    0x0200
#define _RCTRL   0x0400
#define _RALT    0x0800
#define _NUMON   0x20
#define _SCROLLON 0x40
#define _INSON   0x80

#define GAMEPORT				0x0201		// joystick-port

// ALTERABLE PARAMETERS /////////////////////////////////////////////////////

// BLOCKS/PLAYFIELD

// (also remember to change world_C::update()!)

#define BLOCKX		 24 						// width of blocks (pixels)
#define BLOCKY     24							// height of blocks (pixels)

#define PLAYX      240 						// width of playfield (pixels)
#define PLAYY			 240						// height of playfield (pixels)
#define COOKIE     101202303

#define PWIDTH     (PLAYX/BLOCKX) // width of playfield (blocks)
#define PHEIGHT    (PLAYY/BLOCKY) // height of playfield (blocks)

#define PLAYSTART  0							// upper left corner of playfield
																	// (adress in vram)
#define PATTERNS	 10							// # of different explosion-patterns

// TEXTSCREEN

// (also remember to change text_C::update()!)

//#define FLIPTEXT
#define DETPOS 50000

#define BKGROUND   0							// Background color
#define HILITE		 40							// Color of frame around selected func.

#define FONTX      8  						// width of font (pixels)
#define FONTY      8              // height of font (pixels)
#define TEXTX      40             // width of text page (chars)
#define TEXTY      30             // height of text page (chars)

#define TEXTPAGES	 5              // max # of text windows on top of each
																	// other (each using 2400b)

#define SPC 			 85
#define BLANK			 (ADRSMALL+16*SPC)	// ptr to blank char (vram)
#define ADRFRAME   21360					// adress of frame blocks (vram)
#define NUMFRAME    20
#define ADRSMALL   (ADRFRAME+16*NUMFRAME)
																	// adress of small letters (vram)
#define NUMSMALL   178            // total number of small letters
#define NUMTRI		 46							// # of letters available in 3 colors
#define ADRLARGE   (ADRSMALL+16*NUMSMALL)
																	// adress of large letters (vram)
#define NUMLARGE   232						// Note! this is the number of SMALL
																	// letters!
#define ADRPL1		 (ADRLARGE)     // Note! These large letters are loaded
																	// into the same position as the heroes'
																	// bmp.
																	// start of animation player 1 (vram)
#define LENPL1  	 6912						// # of quadruples in player #1's animation
#define ADRPL2		 ((long)ADRPL1+LENPL1)
#define LENPL2  	 6912						// # of quarduples in player #2's animation
																	// start of animation player 2 (vram)
#define ADRMENUIKON (ADRLARGE+16*NUMLARGE+25600/4)
																	// start of big icons
#define NUMMENUIKON 225						// # of 8x8 blocks building the big icons

#define ETCH			((long)ADRPL2+LENPL2) // Where the players are
																	// manipulated
#define POOL 			((long)ETCH+2*576)
																	// adress in vram of first block. From here
																	// on, all vram is occupied by the bmp
													// for the blocks
#define POOLEND    65534L

// WORLD

#define WORLDX     40             // width of world (squares)
#define WORLDY     30             // height of world (squares). Both of
																	// these include the surrounding wall

#define WORLDS		 5							// # of worlds, total
#define ZONES			 5							// # of zones/world
#define LEVELS		 3							// # of levels/zone
#define MAXLEVEL	 (WORLDS*ZONES*LEVELS)

// FILES

#define FBUFFER    512						// size of filebuffer (bytes)
#define CONFIGNAME "B2.CFG"				// name of config-file
#define DATANAME	 "DATA\\DATA.000" // default filename, data
#define DATANAMEL  13
#define LEVELNAME  "PREDEF\\1PLAYER\\PREDEF.000"
																	// default filename, predefined levels
#define LEVELNAMEL 25
#define LEVELCHOOSE 7

#define CUSTOMNAME "HOMEMADE\\1PLAYER\\HOMEMADE.000"
																	// default filename, customized levels
#define CUSTOMNAMEL 29
#define CUSTOMCHOOSE 9

// MISC

#define WALK			 1              // modes of movement
#define FLY        2

#define SAVE			 1
#define RESTORE    2
#define NUMNAMES   10 						// # of registered players one
																	// one/two-player

#define LEVMENUX   18
#define LEVMENUY   14
#define LEVNAMELEN 15							// length of name of the level

#define LIVES      5

#define HINAMELEN	 12							// characters in name on hiscore-list
#define LISTLEN		 7							// # of entries on each of the hiscore-
																	// lists
#define EXTRALEN	 70							// # of extra bytes saved with each level
#define MAXMIX		 75  						// max # of differen bmp/bitcode comb.
																	// on a level
#define SEVENSIXEIGHT	768					// to be 0 when colors aren't included
																	// in minidata
#define MAXACT		 (7*12)

// MOUSE

#define MAXBUTTON  130
#define MAXAREA		 15

#define MOUSEDELAY 11
#define MOUSEX     18             // width of mouse ptr (pixels)
#define MOUSEY     18							// height of mouse ptr (pixels)
#define MAXPIXELS  324  					// maximum # of pixels in any ptr
#define SAFEPTR    20800          // place to make a copy of the area behind
																	// the mouse (vram)
#define SAFEFRAME  21200          // place to make a copy of the area behind
																	// the frame (vram)
#define NUMPTRS		 15

#define MLINE			 97							// above this line wait...
#define MPAUSE		 9							// ... MPAUSE ms with mouse removal
#define LBUTTON    2
#define RBUTTON    1

#define NONE			 -1
#define DEFAULT    0
#define ARROW      1

// PLAYERS

#define ONEPLAYER  0
#define TWOPLAYER  1
#define LINKUP     2

#define KEYBOARD1  1							// used with player_C::player_C(int)
#define KEYBOARD2  2
#define JOYSTICK1  3
#define JOYSTICK2  4
#define MODEM      5
#define PLAYBACK   6

#define PREDEF     0
#define HOMEMADE   1

// LEVEL-EDITOR

#define DRAW       0 							// modes of operation
#define CLR				 1
#define CUT1       90
#define CUT2			 91
#define CUT3       92
#define CUT4       93
#define FILL       100
#define COPY1      120
#define COPY2      121
#define COPY3			 122
#define COPY4      123
#define TEST			 200

// KEYS

#define NUMKEYS    6             // # of keys pr. player (2=shared keys)

#define KEYUP      0
#define KEYRIGHT   1
#define KEYDOWN    2
#define KEYLEFT    3
#define KEYPUSH    4
#define KEYACT     5
#define KEYSAVE    0
#define KEYRESTART 1
#define KEYQUIT    2
#define KEYAUTO    3
#define KEYSOUND   4

// ERRORS

#define OUTOFMEM   0
#define NOVGA      1
#define FILEERROR  2
#define NO386      3

// COLORS

#define FRAME_COL  1

// FLAGS

#define Ifl				 64
#define Vfl        512
#define Dfl				 128
#define Mfl				 32768
#define Hfl				 4096
#define Ffl				 16384
#define Sfl				 2048

#define NUMMINI		 (264/2)				// # of miniature blocks (half the size of
																	// DATA\DATA.113 in bytes)

// BLOCKS

#define MAXBLOCKS  2996						// total # of entries in 'trans'. Static/
																	// dynamic things count as 1/41
#define TOTALBLOCKS 540						// total # of blocks. Dynamic things
																	// (like stones) count as ONE.
#define EDITBLOCKS 90              // max # of blocks to place in the level-
																	// editor

#define AIR				 576						// offset into 'trans', where the
#define WALL			 588      			// vram-ptr and width is given
#define	EARTH			 582
#define DIA1BMP
#define TUBBMP0 5484
#define TUBBMP1 5526

#define BITAIR     0x9800					// bitwise codes
#define BITWALL    0xa000
#define BITEARTH   0xb800
#define TIMEBMP    15588
#define TIMEBIT		 0x1c07

#define BITAIREX	 0x0826
#define BMPAIREX   1134
#define BITDIAEX   0x0806
#define BMPDIAEX   1188
#define BITDIAEX2  0x0806
#define BMPDIAEX2  1248
#define BITSTONEX  0x0806
#define BMPSTONEX  0
#define PLAYERBIT  (0x2d07 | Vfl)

// SOUND

#define BEEPER		 0
#define SBLASTER	 1
#define SILENCE    2


// GAMEPLAY

#define LEAPHEIGHT 2
#define MAXLEAP    5
#define SPEEDTIMER 300
#define RADARTIMER 1500
#define STONEFAC   28
#define FUELAMOUNT 25
#define FUELFAC    65l

// 'SCROLLTEXT'

#define LEFT			 0
#define CENTER     1
#define INITSCROLL 2
#define ENDSCROLL  3

// SCORES

#define QSCORE1    25
#define QSCORE2    50
#define QSCORE3    100
#define BONUSSTEP  10
#define DIASCORE	 1
#define GREENSCORE 3

// TYPEDEFS

#ifdef __LARGE
typedef unsigned char near byte;
typedef unsigned int near word;
#else
typedef unsigned char byte;
typedef unsigned int word;
#endif
typedef void (* func0)(void);

// Definert av jrn

#define FALSE 0
#define TRUE !FALSE

typedef int boolean;
typedef unsigned int uint;

#endif
