///////////////////////////////////////////////////////////////////////////
//                                                                       //
//            File: Kbd.h                                                //
//            started on: 28/7/93                                        //
//                                                                       //
///////////////////////////////////////////////////////////////////////////
//                                                                       //
//  KBD allows you to hook a hotkey. Just pass the constructor your      //
//  hotkey specifications and the hotkey function will be called         //
//  whenever that hotkey is pressed.                                     //
//                                                                       //
///////////////////////////////////////////////////////////////////////////
//                                                                       //
//                    by Ofer Laor (AKA LeucroTTA)                       //
//                                                                       //
///////////////////////////////////////////////////////////////////////////

#ifndef __KBD_H
#define __KBD_H

#include "isc.h"; // ISC.

// keyboard hooking class.
class KBD : public ISC {

      unsigned char bScanCode, bControls; // hotkey params.

      unsigned char far *pShift;          // bios shift state buffer.
      virtual void isr(void);
      int fKillKey;                       // should hotkey be ingnored by the forground app?

protected:
          virtual void hotkey(void) {};   // hotkey func.
          virtual int kill_key(void) { return fKillKey; };  // decides whether to kill key.

public:
       KBD(unsigned char scan_code, unsigned char controls= 0, int kill_key= 1);
};

// shift states.
const unsigned char KBS_ALT= 0x8,  KBS_CONTROL= 0x4, KBS_LSHIFT= 0x2, KBS_RSHIFT= 0x1;

// both shifts down.
const unsigned char KBS_SHIFT= KBS_LSHIFT| KBS_RSHIFT;

// normal KEYS states.
enum KB_KEYS {KB_Esc= 0x1,
              KB_1,KB_2,KB_3,KB_4,KB_5,KB_6,KB_7,KB_8,KB_9,KB_0,
              KB_MINUS= 0xc,KB_PLUS,
              KB_BKSP,
              KB_TAB,
              KB_Q,KB_W,KB_E,KB_R,KB_T,KB_Y,KB_U,KB_I,KB_O,KB_P,
              KB_SQUARE_OPEN= 0x1a,KB_SQUARE_CLOSE,
              KB_ENTER,
              KB_CTRL,
              KB_A,KB_S,KB_D,KB_F,KB_G,KB_H,KB_J,KB_K,KB_L= 0X26,
              KB_SEMICOLON,KB_QUOTE,KB_APOSTROPHE,
              KB_LSHIFT,
              KB_BACKSLASH,
              KB_Z,KB_X,KB_C,KB_V,KB_B,KB_N,KB_M,
              KB_COMMA,KB_DOT,KB_SLASH,
              KB_RSHIFT,
              KB_PRTSCR,
              KB_ALT,
              KB_SPACE,
              KB_CAPS= 0x3a,
              KB_F1,KB_F2,KB_F3,KB_F4,KB_F5,KB_F6,KB_F7,KB_F8,KB_F9,KB_F10,
              KB_NUMLOCK,KB_SCROLL,KB_HOME,
              KB_UP,KB_PGUP,
              KB_GRAY_MINUS,
              KB_LEFT,
              KB_GRAY_5,
              KB_RIGHT,
              KB_GRAY_PLUS,
              KB_END,KB_DOWN,KB_PGDWN,
              KB_INS,KB_DEL,
              KB_F11= 0x85, KB_F12
};


#endif /* __KBD_H */