//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                             example4 of ISC...                           //
//                             ------------------                           //
//                                                                          //
//  will put a Novell look alike message on the screen, preventing the      //
//  forground to work- will free with a ^Enter. The message will be sent    //
//  every few seconds...                                                    //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////
//                                                                          //
//                       By:- Ofer Laor (AKA LeucroTTa)                     //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include "isc.h"   // ISC.
#include <dos.h>;  // enable, disable.
#include <conio.h>;

class Msg: public ISC {

      virtual void isr(void);
      void put_TSR_message(const char *);
      static char* static_message;

public:
       void activate(void) {
            ISC::activate (0x8);
       }

       Msg(): ISC() {};

};


char *Msg::static_message= ">>                                                       (CTRL-ENTER to clear)";

void Msg::isr(void)
{
    static unsigned index= 0;
    static unsigned char recursive= 0;

    old_vect();

    if (recursive)
       return;
    recursive++;

    enable();

    if (index== 50) {
       put_TSR_message("   Hello there");
       index= 0;
    }
    else
        index++;

    recursive--;
}

void Msg::put_TSR_message(const char *text)
{
    static unsigned char recursive= 0;
    static char old_screen[160];
    static int i;

    if (recursive)
       return;
    recursive++;


    char far *sp= (char far *)MK_FP(0xb800, 3840);

    for (i= 0; i< 160; i++)
        old_screen[i]= sp[i];

    for (i= 0; static_message[i]; i++) {
        sp[i*2]= static_message[i];
        sp[i*2+ 1]= 0x70;
    }

    for (i=0; (i< 80)&& (text[i]); i++) {
        if (sp[i*2]== ' ')
           sp[i*2]= text[i];
    }

    // now beep...
    asm {
        mov ax, 0e07h
        xor bx,bx
        int 10h
    }


    // now get ^Enter.

no_key:
    asm {
        xor ah,ah
        int 16h

        cmp al, 10
        jne no_key
    }


    for (i= 0; i< 160; i++)
        sp[i]= old_screen[i];

    recursive--;
}


Msg message; // can be either static or dynamic (not automatic- because
               //     it gets used after the program goes TSR).

int main()
{
    if (ISC::is_TSR("EXAMPLE4"))
       return 1; // too much processing in background will kill the forground.

    message.activate();

    return ISC::TSR();
}