// ex13-10.c -- MI and Object I/O readFrom()

// $Header: /afs/alw.nih.gov/system/src/local/nihcl/311/share/ex/RCS/ex13-10.c,v 3.12 92/08/13 12:47:30 sandy Exp $

#include <fstream.h>
//#include <osfcn.h>
#include "LandVhcl.h"
#include "WaterVhc.h"
#include "AmphibVh.h"
#include "StopLigh.h"
#include "DrawBrid.h"
#include <OrderedC.h>
#include <OIOnih.h>

StopLightQ* stopLightQ[2];
DrawBridgeQ* drawBridgeQ;

void main()
{
    ifstream in("trafficf.ile");
    if (in.fail()) {
        cerr << "Failed to open trafficfile\n";
        exit(1);
    }
    OrderedCltn& allQueues = *OrderedCltn::readFrom(OIOnihin(in));
    stopLightQ[0] = StopLightQ::castdown(allQueues[1]);
    stopLightQ[1] = StopLightQ::castdown(allQueues[2]);
    drawBridgeQ = DrawBridgeQ::castdown(allQueues[3]);

    cout << "allVehicles:\n"; Vehicle::printAll();
    cout << endl;
    cout << "stopLightQ[0]:\n"; stopLightQ[0]->printOn();
    cout << endl;
    cout << "stopLightQ[1]:\n"; stopLightQ[1]->printOn();
    cout << endl;
    cout << "drawBridgeQ:\n"; drawBridgeQ->printOn();
    cout << endl;
}
