// ex13-7.c -- Calling a virtual function from a
//             base class constructor

// $Header: /afs/alw.nih.gov/system/src/local/nihcl/311/share/ex/RCS/ex13-7.c,v 3.10 91/02/23 21:59:53 kgorlen Rel Locker: sandy $

#include <iostream.h>

class V {
public:
    virtual void vf();
};

void V::vf()    { cout << "V::vf()" << endl; }

class A: public virtual V {
public:
    A()         { /* ... */ }
    virtual void vf();
};

void A::vf()    { cout << "A::vf()" << endl; }

class B: public virtual V {
public:
    B()         { vf(); }   // Calls A::vf(), not
                            // V::vf() or C::vf()
};

class C: public A, public B {
public:
    C()         { vf(); }   // Calls C::vf()
    virtual void vf();
};

void C::vf()    { cout << "C::vf()" << endl; }

void main()
{
    C c;
}
