// ex8-3.c -- Nested Iterators

// $Header: /afs/alw.nih.gov/system/src/local/nihcl/311/share/ex/RCS/ex8-3.c,v 3.11 92/08/13 11:59:58 sandy Exp $

#include <OrderedC.h>
#include <Iterator.h>
#include <NIHStrin.h>

void printPairs(const Collection& c1, const Collection& c2)
{
    Iterator it1(c1), it2(c2);

    while(it1++) {
        while (it2++) {
            cout << '[' << *it1() << ',' << *it2() << "]  ";
        }
        cout << endl;
        it2.reset();
    }
}

void main()
{
    OrderedCltn symbols;
    symbols.add(*new String("A"));
    symbols.add(*new String("C"));
    symbols.add(*new String("G"));
    symbols.add(*new String("T"));
    printPairs(symbols,symbols);
}
