// ex9-3.c -- Correct handling of member pointers
//            to class instances

// $Header: /afs/alw.nih.gov/system/src/local/nihcl/311/share/ex/RCS/ex9-3.c,v 3.11 92/08/13 12:00:08 sandy Exp $

#include <NIHStrin.h>

class X {
    String* s;
public:
    X(const char* t="")     { s = new String(t); }
    X(const X& x)           { s = new String(*x.s); }
    void operator=(const X&);
    ~X()                    { delete s; }
    void set(const char* t) { *s = t; }
    friend ostream& operator<<(ostream& strm, X& x) {
        strm << *x.s;
        return strm;
    }
};

void X::operator=(const X& x)
{
    if (this == &x) return;
    delete s;
    s = new String(*x.s);
}

void main()
{
    X a = "abc";
    X b = a;
    X c;
    c = a;
    a.set("xyz");
    cout << "a=" << a << endl;
    cout << "b=" << b << endl;
    cout << "c=" << c << endl;
}
