// LandVhcl.c -- Land Vehicle

#include "LandVhcl.h"
#include <nihclIO.h>

#define THIS    LandVhcl
#define BASE    Vehicle
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Vehicle::desc()

DEFINE_CLASS(LandVhcl,1,"$"__FILE__" "__DATE__" "__TIME__"$",NULL);

void LandVhcl::_printOn(ostream& strm) const
{
    Vehicle::_printOn(strm);
    strm << "  axles " << axles;
}

void LandVhcl::deepenShallowCopy()
{
    Vehicle::deepenVBase();
}

LandVhcl::LandVhcl(OIOin& strm) :
    Object(strm),
    BASE(strm)
{
    strm >> axles;
}

void LandVhcl::storer(OIOout& strm) const
{
    Vehicle::storeVBaseOn(strm);
    strm << axles;
}

LandVhcl::LandVhcl(OIOifd& fd) :
    Object(fd),
    BASE(fd)
{
    fd >> axles;
}

void LandVhcl::storer(OIOofd& fd) const
{
    Vehicle::storeVBaseOn(fd);
    fd << axles;
}
